/*
 * Decompiled with CFR 0.152.
 */
package org.libpag;

import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import android.opengl.EGLContext;
import android.os.Build;
import android.view.Surface;
import org.extra.tools.LibraryLoadUtils;

public class PAGSurface {
    private Surface surface = null;
    private boolean needsReleaseSurface = false;
    private int textureID = 0;
    long nativeSurface = 0L;

    public static PAGSurface FromSurfaceTexture(SurfaceTexture surfaceTexture) {
        return PAGSurface.FromSurfaceTexture(surfaceTexture, EGL14.EGL_NO_CONTEXT);
    }

    public static PAGSurface FromSurfaceTexture(SurfaceTexture surfaceTexture, EGLContext shareContext) {
        if (surfaceTexture == null) {
            return null;
        }
        PAGSurface pagSurface = PAGSurface.FromSurface(new Surface(surfaceTexture), shareContext);
        if (pagSurface != null) {
            pagSurface.needsReleaseSurface = true;
        }
        return pagSurface;
    }

    public static PAGSurface FromSurface(Surface surface) {
        return PAGSurface.FromSurface(surface, EGL14.EGL_NO_CONTEXT);
    }

    public static PAGSurface FromSurface(Surface surface, EGLContext shareContext) {
        long nativeSurface;
        if (surface == null) {
            return null;
        }
        long handle = 0L;
        if (shareContext != null && shareContext != EGL14.EGL_NO_CONTEXT) {
            handle = Build.VERSION.SDK_INT >= 21 ? shareContext.getNativeHandle() : (long)shareContext.getHandle();
        }
        if ((nativeSurface = PAGSurface.SetupFromSurfaceWithGLContext(surface, handle)) == 0L) {
            return null;
        }
        PAGSurface pagSurface = new PAGSurface(nativeSurface);
        pagSurface.surface = surface;
        return pagSurface;
    }

    public static PAGSurface FromTexture(int textureID, int width, int height) {
        return PAGSurface.FromTexture(textureID, width, height, false);
    }

    public static PAGSurface FromTexture(int textureID, int width, int height, boolean flipY) {
        long nativeSurface = PAGSurface.SetupFromTexture(textureID, width, height, flipY, false);
        if (nativeSurface == 0L) {
            return null;
        }
        PAGSurface pagSurface = new PAGSurface(nativeSurface);
        pagSurface.textureID = textureID;
        return pagSurface;
    }

    public static PAGSurface FromTextureForAsyncThread(int textureID, int width, int height) {
        return PAGSurface.FromTextureForAsyncThread(textureID, width, height, false);
    }

    public static PAGSurface FromTextureForAsyncThread(int textureID, int width, int height, boolean flipY) {
        long nativeSurface = PAGSurface.SetupFromTexture(textureID, width, height, flipY, true);
        if (nativeSurface == 0L) {
            return null;
        }
        PAGSurface pagSurface = new PAGSurface(nativeSurface);
        pagSurface.textureID = textureID;
        return pagSurface;
    }

    private static native long SetupFromSurfaceWithGLContext(Surface var0, long var1);

    public static native long SetupFromTexture(int var0, int var1, int var2, boolean var3, boolean var4);

    private PAGSurface(long nativeSurface) {
        this.nativeSurface = nativeSurface;
    }

    public native int width();

    public native int height();

    public native void updateSize();

    public native boolean clearAll();

    public native void freeCache();

    public native Bitmap makeSnapshot();

    public void release() {
        if (this.needsReleaseSurface && this.surface != null) {
            this.surface.release();
        }
        this.nativeRelease();
    }

    private native void nativeRelease();

    private static native void nativeInit();

    private native void nativeFinalize();

    protected void finalize() {
        this.nativeFinalize();
    }

    static {
        LibraryLoadUtils.loadLibrary("pag");
        PAGSurface.nativeInit();
    }
}

