/*
 * Decompiled with CFR 0.152.
 */
package org.libpag;

import android.graphics.Matrix;
import android.graphics.RectF;
import org.extra.tools.LibraryLoadUtils;
import org.ffavc.DecoderFactory;
import org.libpag.PAGComposition;
import org.libpag.PAGLayer;
import org.libpag.PAGSurface;
import org.libpag.VideoDecoder;

public class PAGPlayer {
    private PAGSurface pagSurface = null;
    private long nativeContext = 0L;

    public PAGPlayer() {
        this.nativeSetup();
    }

    public native PAGComposition getComposition();

    public native void setComposition(PAGComposition var1);

    public PAGSurface getSurface() {
        return this.pagSurface;
    }

    public void setSurface(PAGSurface surface) {
        this.pagSurface = surface;
        if (surface == null) {
            this.nativeSetSurface(0L);
        } else {
            this.nativeSetSurface(surface.nativeSurface);
        }
    }

    private native void nativeSetSurface(long var1);

    public native boolean videoEnabled();

    public native void setVideoEnabled(boolean var1);

    public native boolean cacheEnabled();

    public native void setCacheEnabled(boolean var1);

    public native float cacheScale();

    public native void setCacheScale(float var1);

    public native float maxFrameRate();

    public native void setMaxFrameRate(float var1);

    public native int scaleMode();

    public native void setScaleMode(int var1);

    public Matrix matrix() {
        float[] values = new float[9];
        this.nativeGetMatrix(values);
        Matrix matrix = new Matrix();
        matrix.setValues(values);
        return matrix;
    }

    private native void nativeGetMatrix(float[] var1);

    public void setMatrix(Matrix matrix) {
        float[] values = new float[9];
        matrix.getValues(values);
        this.nativeSetMatrix(values[0], values[3], values[1], values[4], values[2], values[5]);
    }

    private native void nativeSetMatrix(float var1, float var2, float var3, float var4, float var5, float var6);

    public native long duration();

    public native double getProgress();

    public native void setProgress(double var1);

    public native void prepare();

    public boolean flush() {
        return this.flushAndFenceSync(null);
    }

    public native boolean flushAndFenceSync(long[] var1);

    public native boolean waitSync(long var1);

    public native RectF getBounds(PAGLayer var1);

    public native PAGLayer[] getLayersUnderPoint(float var1, float var2);

    public native boolean hitTestPoint(PAGLayer var1, float var2, float var3, boolean var4);

    public void release() {
        this.nativeRelease();
    }

    private final native void nativeRelease();

    protected void finalize() {
        this.nativeFinalize();
    }

    private native void nativeFinalize();

    private final native void nativeSetup();

    private static final native void nativeInit();

    static {
        LibraryLoadUtils.loadLibrary("pag");
        PAGPlayer.nativeInit();
        VideoDecoder.RegisterSoftwareDecoderFactory(DecoderFactory.GetHandle());
    }
}

