/*
 * Decompiled with CFR 0.152.
 */
package org.libpag;

import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.os.Build;
import android.util.Log;
import org.extra.tools.LibraryLoadUtils;

public class PAGImage {
    long nativeContext = 0L;

    public static PAGImage FromBitmap(Bitmap bitmap) {
        long context;
        if (bitmap == null) {
            return null;
        }
        Bitmap.Config config = bitmap.getConfig();
        if (Build.VERSION.SDK_INT >= 26 && config == Bitmap.Config.HARDWARE) {
            Log.e((String)"libpag", (String)"PAGImage.LoadFromBitmap() does not support Bitmap with hardware config.");
            return null;
        }
        if (!(config == Bitmap.Config.ALPHA_8 || config == Bitmap.Config.ARGB_8888 && bitmap.isPremultiplied())) {
            Bitmap newBitmap = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(newBitmap);
            Paint paint = new Paint();
            canvas.drawBitmap(bitmap, 0.0f, 0.0f, paint);
            bitmap = newBitmap;
        }
        if ((context = PAGImage.LoadFromBitmap(bitmap)) == 0L) {
            return null;
        }
        return new PAGImage(context);
    }

    public static PAGImage FromPath(String path) {
        long context = PAGImage.LoadFromPath(path);
        if (context == 0L) {
            return null;
        }
        return new PAGImage(context);
    }

    public static PAGImage FromBytes(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        long context = PAGImage.LoadFromBytes(bytes, bytes.length);
        if (context == 0L) {
            return null;
        }
        return new PAGImage(context);
    }

    public static PAGImage FromAssets(AssetManager manager, String fileName) {
        long context = PAGImage.LoadFromAssets(manager, fileName);
        if (context == 0L) {
            return null;
        }
        return new PAGImage(context);
    }

    public static PAGImage FromTexture(int textureID, int textureTarget, int width, int height) {
        return PAGImage.FromTexture(textureID, textureTarget, width, height, false);
    }

    public static PAGImage FromTexture(int textureID, int textureTarget, int width, int height, boolean flipY) {
        long context = PAGImage.LoadFromTexture(textureID, textureTarget, width, height, flipY);
        if (context == 0L) {
            return null;
        }
        return new PAGImage(context);
    }

    private static native long LoadFromBitmap(Bitmap var0);

    private static native long LoadFromPath(String var0);

    private static native long LoadFromBytes(byte[] var0, int var1);

    private static native long LoadFromAssets(AssetManager var0, String var1);

    private static native long LoadFromTexture(int var0, int var1, int var2, int var3, boolean var4);

    PAGImage(long nativeContext) {
        this.nativeContext = nativeContext;
    }

    public native int width();

    public native int height();

    public native int scaleMode();

    public native void setScaleMode(int var1);

    public Matrix matrix() {
        float[] values = new float[9];
        this.nativeGetMatrix(values);
        Matrix matrix = new Matrix();
        matrix.setValues(values);
        return matrix;
    }

    private native void nativeGetMatrix(float[] var1);

    public void setMatrix(Matrix matrix) {
        float[] values = new float[9];
        matrix.getValues(values);
        this.nativeSetMatrix(values[0], values[3], values[1], values[4], values[2], values[5]);
    }

    private native void nativeSetMatrix(float var1, float var2, float var3, float var4, float var5, float var6);

    public void release() {
        this.nativeRelease();
    }

    private final native void nativeRelease();

    private static final native void nativeInit();

    protected void finalize() {
        this.nativeFinalize();
    }

    private native void nativeFinalize();

    static {
        LibraryLoadUtils.loadLibrary("pag");
        PAGImage.nativeInit();
    }
}

