/*
 * Decompiled with CFR 0.152.
 */
package org.extra.tools;

import android.app.Application;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import org.extra.relinker.ReLinker;

public class LibraryLoadUtils {
    public static final String TAG = LibraryLoadUtils.class.getSimpleName();
    private static Context appContext;

    public static void loadLibrary(String libName) {
        try {
            Application app = (Application)Class.forName("android.app.ActivityThread").getMethod("currentApplication", new Class[0]).invoke(null, (Object[])null);
            appContext = app.getApplicationContext();
        }
        catch (Exception exception) {
            // empty catch block
        }
        LibraryLoadUtils.loadLibrary(appContext, libName);
    }

    public static Context getAppContext() {
        return appContext;
    }

    private static void loadLibrary(Context context, String libName) {
        if (LibraryLoadUtils.load(libName)) {
            return;
        }
        if (LibraryLoadUtils.load(context, libName)) {
            return;
        }
        LibraryLoadUtils.relinker(context, libName);
    }

    private static boolean load(String libName) {
        if (TextUtils.isEmpty((CharSequence)libName)) {
            return false;
        }
        boolean result = true;
        try {
            System.loadLibrary(libName);
        }
        catch (Throwable t) {
            result = false;
            Log.i((String)TAG, (String)("loadLibrary " + libName + " fail! Error: " + t.getMessage()));
        }
        return result;
    }

    private static boolean load(Context context, String libName) {
        if (context == null || TextUtils.isEmpty((CharSequence)libName)) {
            return false;
        }
        boolean result = true;
        try {
            String libDir = context.getApplicationInfo().dataDir + "/lib";
            String libPath = libDir + File.separator + "lib" + libName + ".so";
            System.load(libPath);
        }
        catch (Throwable t) {
            result = false;
            Log.i((String)TAG, (String)("load  fail! Error: " + t.getMessage()));
        }
        return result;
    }

    private static boolean relinker(Context context, String libName) {
        if (context == null || TextUtils.isEmpty((CharSequence)libName)) {
            return false;
        }
        try {
            ReLinker.loadLibrary(context, libName);
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }
}

