/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.trtc.hardwareearmonitor.daisy;

import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.trtc.hardwareearmonitor.daisy.DaisyAudioKaraokeFeatureKit;
import com.tencent.trtc.hardwareearmonitor.daisy.DaisyAudioKit;
import com.tencent.trtc.hardwareearmonitor.daisy.DaisyFeatureKitManager;
import com.tencent.trtc.hardwareearmonitor.daisy.IDaisyAudioKitCallback;

@JNINamespace(value="liteav::extensions")
public class HardwareEarMonitorDaisy
implements IDaisyAudioKitCallback {
    private DaisyAudioKit mDaisyAudioKit;
    private DaisyAudioKaraokeFeatureKit mDaisyKaraokeKit;
    private Object mLock = new Object();
    private long mNativeHardwareEarMonitorHandle = 0L;

    public static HardwareEarMonitorDaisy create(long nativeHardwareEarMonitorHandle) {
        return new HardwareEarMonitorDaisy(nativeHardwareEarMonitorHandle);
    }

    public static boolean isAudioKitSupport() {
        return DaisyFeatureKitManager.isAudioKitSupport(ContextUtils.getApplicationContext());
    }

    public boolean isKaraokeServiceSupport() {
        return this.mDaisyAudioKit.isFeatureSupported(DaisyAudioKit.FeatureType.HWAUDIO_FEATURE_KARAOKE);
    }

    public void createKaraokeService() {
        this.mDaisyKaraokeKit = (DaisyAudioKaraokeFeatureKit)this.mDaisyAudioKit.createFeature(DaisyAudioKit.FeatureType.HWAUDIO_FEATURE_KARAOKE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.mLock;
        synchronized (object) {
            this.mNativeHardwareEarMonitorHandle = 0L;
        }
        if (this.mDaisyAudioKit != null) {
            this.mDaisyAudioKit.destroy();
            this.mDaisyAudioKit = null;
        }
        if (this.mDaisyKaraokeKit != null) {
            this.mDaisyKaraokeKit.destroy();
            this.mDaisyKaraokeKit = null;
        }
    }

    public boolean enableKaraoke(boolean enable) {
        if (this.mDaisyKaraokeKit == null) {
            return false;
        }
        return this.mDaisyKaraokeKit.enableKaraokeFeature(enable) == 0;
    }

    public boolean setReverberation(int value) {
        if (this.mDaisyKaraokeKit == null) {
            return false;
        }
        return this.mDaisyKaraokeKit.setParameter(DaisyAudioKaraokeFeatureKit.ParameName.CMD_SET_AUDIO_EFFECT_MODE_BASE, value) == 0;
    }

    private boolean setEqualizer(int value) {
        if (this.mDaisyKaraokeKit == null) {
            return false;
        }
        return this.mDaisyKaraokeKit.setParameter(DaisyAudioKaraokeFeatureKit.ParameName.CMD_SET_VOCAL_EQUALIZER_MODE, value) == 0;
    }

    private boolean setVolume(int value) {
        if (this.mDaisyKaraokeKit == null) {
            return false;
        }
        return this.mDaisyKaraokeKit.setParameter(DaisyAudioKaraokeFeatureKit.ParameName.CMD_SET_VOCAL_VOLUME_BASE, value) == 0;
    }

    public boolean isHardwareEarMonitorSupported() {
        if (this.mDaisyAudioKit == null) {
            return false;
        }
        return this.mDaisyAudioKit.isFeatureSupported(DaisyAudioKit.FeatureType.HWAUDIO_FEATURE_KARAOKE);
    }

    public HardwareEarMonitorDaisy(long nativeHardwareEarMonitorHandle) {
        this.mNativeHardwareEarMonitorHandle = nativeHardwareEarMonitorHandle;
        this.mDaisyAudioKit = new DaisyAudioKit(ContextUtils.getApplicationContext(), this);
        this.mDaisyAudioKit.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onResult(int result) {
        Object object = this.mLock;
        synchronized (object) {
            HardwareEarMonitorDaisy.nativeHandleResult(this.mNativeHardwareEarMonitorHandle, result);
            return;
        }
    }

    private static native void nativeHandleResult(long var0, int var2);
}

