/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videobase.frame;

import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.Size;
import com.tencent.liteav.base.util.k;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.frame.MirrorInfo;

@JNINamespace(value="liteav::video")
public class FrameMetaData {
    private final MirrorInfo mCaptureMirror = new MirrorInfo();
    private boolean mIsFrontCamera = false;
    private final Size mCaptureRealFrameSize = new Size();
    private boolean mIsBlackFrame = false;
    private final MirrorInfo mPreprocessorMirror = new MirrorInfo();
    private k mPreprocessorRotation = k.a;
    private GLConstants.GLScaleType mPreprocessorScaleType = GLConstants.GLScaleType.a;
    private final MirrorInfo mRenderMirror = new MirrorInfo();
    private k mRenderRotation = k.a;
    private final Size mRenderSize = new Size();
    private final MirrorInfo mEncodeMirror = new MirrorInfo();
    private k mEncodeRotation = k.a;
    private final Size mEncodeSize = new Size();

    public void setCaptureMetaData(boolean isHorizontal, boolean isVertical, boolean isFrontCamera, int width, int height) {
        this.mCaptureMirror.isHorizontal = isHorizontal;
        this.mCaptureMirror.isVertical = isVertical;
        this.mIsFrontCamera = isFrontCamera;
        this.mCaptureRealFrameSize.width = width;
        this.mCaptureRealFrameSize.height = height;
    }

    public boolean isCaptureMirrorHorizontal() {
        return this.mCaptureMirror.isHorizontal;
    }

    public boolean isCaptureMirrorVertical() {
        return this.mCaptureMirror.isVertical;
    }

    public boolean isFrontCamera() {
        return this.mIsFrontCamera;
    }

    public Size getCaptureRealSize() {
        return this.mCaptureRealFrameSize;
    }

    public void setPreprocessorMetaData(boolean isHorizontal, boolean isVertical, int rotation, int scaleType) {
        this.mPreprocessorMirror.isHorizontal = isHorizontal;
        this.mPreprocessorMirror.isVertical = isVertical;
        this.mPreprocessorRotation = k.a(rotation);
        this.mPreprocessorScaleType = GLConstants.GLScaleType.a(scaleType);
    }

    public void setPreprocessorMirror(MirrorInfo mirrorInfo) {
        if (mirrorInfo == null) {
            return;
        }
        this.mPreprocessorMirror.isHorizontal = mirrorInfo.isHorizontal;
        this.mPreprocessorMirror.isVertical = mirrorInfo.isVertical;
    }

    public boolean isPreprocessorMirrorHorizontal() {
        return this.mPreprocessorMirror.isHorizontal;
    }

    public boolean isPreprocessorMirrorVertical() {
        return this.mPreprocessorMirror.isVertical;
    }

    public void setPreprocessorRotation(k rotation) {
        if (rotation == null) {
            return;
        }
        this.mPreprocessorRotation = rotation;
    }

    public k getPreprocessorRotation() {
        return this.mPreprocessorRotation;
    }

    public int getPreprocessorRotationValue() {
        return this.mPreprocessorRotation.mValue;
    }

    public void setPreprocessorScaleType(GLConstants.GLScaleType scaleType) {
        if (scaleType == null) {
            return;
        }
        this.mPreprocessorScaleType = scaleType;
    }

    public GLConstants.GLScaleType getPreprocessorScaleType() {
        return this.mPreprocessorScaleType;
    }

    public int getPreprocessorScaleTypeValue() {
        return this.mPreprocessorScaleType.mValue;
    }

    public void setRenderMetaData(boolean isHorizontal, boolean isVertical, int rotation, int width, int height) {
        this.mRenderMirror.isHorizontal = isHorizontal;
        this.mRenderMirror.isVertical = isVertical;
        this.mRenderRotation = k.a(rotation);
        this.mRenderSize.width = width;
        this.mRenderSize.height = height;
    }

    public void setRenderMirror(MirrorInfo mirrorInfo) {
        if (mirrorInfo == null) {
            return;
        }
        this.mRenderMirror.isHorizontal = mirrorInfo.isHorizontal;
        this.mRenderMirror.isVertical = mirrorInfo.isVertical;
    }

    public boolean isRenderMirrorHorizontal() {
        return this.mRenderMirror.isHorizontal;
    }

    public boolean isRenderMirrorVertical() {
        return this.mRenderMirror.isVertical;
    }

    public void setRenderRotation(k rotation) {
        if (rotation == null) {
            return;
        }
        this.mRenderRotation = rotation;
    }

    public k getRenderRotation() {
        return this.mRenderRotation;
    }

    public int getRenderRotationValue() {
        return this.mRenderRotation.mValue;
    }

    public void setRenderSize(Size size) {
        this.mRenderSize.set(size);
    }

    public Size getRenderSize() {
        return this.mRenderSize;
    }

    public int getRenderWidth() {
        return this.mRenderSize.width;
    }

    public int getRenderHeight() {
        return this.mRenderSize.height;
    }

    public void setEncodeMetaData(boolean isHorizontal, boolean isVertical, int rotation, int width, int height) {
        this.mEncodeMirror.isHorizontal = isHorizontal;
        this.mEncodeMirror.isVertical = isVertical;
        this.mEncodeRotation = k.a(rotation);
        this.mEncodeSize.width = width;
        this.mEncodeSize.height = height;
    }

    public void setEncodeMirror(MirrorInfo mirrorInfo) {
        if (mirrorInfo == null) {
            return;
        }
        this.mEncodeMirror.isHorizontal = mirrorInfo.isHorizontal;
        this.mEncodeMirror.isVertical = mirrorInfo.isVertical;
    }

    public boolean isEncodeMirrorHorizontal() {
        return this.mEncodeMirror.isHorizontal;
    }

    public boolean isEncodeMirrorVertical() {
        return this.mEncodeMirror.isVertical;
    }

    public void setEncodeRotation(k rotation) {
        if (rotation == null) {
            return;
        }
        this.mEncodeRotation = rotation;
    }

    public k getEncodeRotation() {
        return this.mEncodeRotation;
    }

    public int getEncodeRotationValue() {
        return this.mEncodeRotation.mValue;
    }

    public void setEncodeSize(Size size) {
        this.mEncodeSize.set(size);
    }

    public Size getEncodeSize() {
        return this.mEncodeSize;
    }

    public int getEncodeWidth() {
        return this.mEncodeSize.width;
    }

    public int getEncodeHeight() {
        return this.mEncodeSize.height;
    }

    public void setIsBlackFrame(boolean isBlackFrame) {
        this.mIsBlackFrame = isBlackFrame;
    }

    public boolean isBlackFrame() {
        return this.mIsBlackFrame;
    }
}

