/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.trtc;

import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.trtc.TRTCCloud;
import com.tencent.trtc.TRTCCloudDef;
import com.tencent.trtc.TXChorusMusicPlayer;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

@JNINamespace(value="liteav::chorus")
public class TXChorusMusicPlayerImpl
extends TXChorusMusicPlayer {
    private static final String TAG = "TXChorusMusicPlayerImpl";
    private final ChorusPlayerListener mListener = new ChorusPlayerListener(0);
    private long mNativePtr = 0L;
    private TRTCCloud mTRTCCloud = null;
    private TRTCCloud mSubTRTCCloud = null;

    public static TXChorusMusicPlayer create(TRTCCloud cloud, String roomId, TXChorusMusicPlayer.ITXChorusPlayerListener listener) {
        return new TXChorusMusicPlayerImpl(cloud, roomId, listener);
    }

    @Override
    public synchronized void destroy() {
        if (this.mNativePtr != 0L) {
            TXChorusMusicPlayerImpl.nativeDestroy(this.mNativePtr);
            this.mNativePtr = 0L;
        }
        if (this.mTRTCCloud != null && this.mSubTRTCCloud != null) {
            this.mTRTCCloud.destroySubCloud(this.mSubTRTCCloud);
            this.mSubTRTCCloud = null;
            this.mTRTCCloud = null;
        }
        this.mListener.a = null;
    }

    @Override
    public synchronized void setChorusRole(TXChorusMusicPlayer.TXChorusRole role, TRTCCloudDef.TRTCParams param) {
        if (this.mNativePtr != 0L && role != null) {
            EnterRoomParams enterRoomParams = param != null ? new EnterRoomParams(param) : null;
            TXChorusMusicPlayerImpl.nativeSetChorusRole(this.mNativePtr, TXChorusMusicPlayerImpl.getTXChorusRoleIntValue(role), enterRoomParams);
        }
    }

    @Override
    public void setListener(TXChorusMusicPlayer.ITXChorusPlayerListener listener) {
        this.mListener.a = listener;
    }

    @Override
    public synchronized void loadMusic(TXChorusMusicPlayer.TXChorusCopyrightedMusicParams params) {
        if (this.mNativePtr != 0L && params != null) {
            TXChorusMusicPlayerImpl.nativeLoadMusic(this.mNativePtr, params.musicId, params.playToken, params.copyrightedLicenseKey, params.copyrightedLicenseUrl);
        }
    }

    @Override
    public synchronized void loadExternalMusic(TXChorusMusicPlayer.TXChorusExternalMusicParams params) {
        if (this.mNativePtr != 0L && params != null) {
            TXChorusMusicPlayerImpl.nativeLoadExternalMusic(this.mNativePtr, params.musicUrl, params.isEncrypted, params.encryptBlockLength);
        }
    }

    @Override
    public synchronized void start() {
        if (this.mNativePtr != 0L) {
            TXChorusMusicPlayerImpl.nativeStart(this.mNativePtr);
        }
    }

    @Override
    public synchronized void stop() {
        if (this.mNativePtr != 0L) {
            TXChorusMusicPlayerImpl.nativeStop(this.mNativePtr);
        }
    }

    @Override
    public synchronized void pause() {
        if (this.mNativePtr != 0L) {
            TXChorusMusicPlayerImpl.nativePause(this.mNativePtr);
        }
    }

    @Override
    public synchronized void resume() {
        if (this.mNativePtr != 0L) {
            TXChorusMusicPlayerImpl.nativeResume(this.mNativePtr);
        }
    }

    @Override
    public synchronized void seek(long timestampMs) {
        if (this.mNativePtr != 0L) {
            TXChorusMusicPlayerImpl.nativeSeek(this.mNativePtr, timestampMs);
        }
    }

    @Override
    public synchronized void switchMusicTrack(TXChorusMusicPlayer.TXChorusMusicTrack track) {
        if (this.mNativePtr != 0L && track != null) {
            TXChorusMusicPlayerImpl.nativeSwitchMusicTrack(this.mNativePtr, TXChorusMusicPlayerImpl.getTXChorusMusicTrackIntValue(track));
        }
    }

    @Override
    public synchronized void setPlayoutVolume(int volume) {
        if (this.mNativePtr != 0L) {
            TXChorusMusicPlayerImpl.nativeSetPlayoutVolume(this.mNativePtr, volume);
        }
    }

    @Override
    public synchronized void setPublishVolume(int volume) {
        if (this.mNativePtr != 0L) {
            TXChorusMusicPlayerImpl.nativeSetPublishVolume(this.mNativePtr, volume);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.mNativePtr != 0L) {
            LiteavLog.w(TAG, "object is not destroyed. will be memory leak. native pointer is %#x.", this.mNativePtr);
        }
    }

    private TXChorusMusicPlayerImpl(TRTCCloud cloud, String roomId, TXChorusMusicPlayer.ITXChorusPlayerListener listener) {
        if (cloud == null) {
            return;
        }
        this.mTRTCCloud = cloud;
        long l2 = 0L;
        try {
            l2 = TXChorusMusicPlayerImpl.parseNativePointer(cloud.callExperimentalAPI("{\"api\":\"getNativeHandle\"}"));
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "get main trtcCloud native handle fail.", throwable);
        }
        long l3 = 0L;
        try {
            this.mSubTRTCCloud = cloud.createSubCloud();
            l3 = TXChorusMusicPlayerImpl.parseNativePointer(this.mSubTRTCCloud.callExperimentalAPI("{\"api\":\"getNativeHandle\"}"));
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "get sub trtcCloud native handle fail.", throwable);
        }
        this.mListener.a = listener;
        this.mNativePtr = TXChorusMusicPlayerImpl.nativeCreate(l2, l3, roomId, this.mListener);
    }

    private static long parseNativePointer(String nativePointer) {
        BigInteger bigInteger;
        try {
            bigInteger = new BigInteger(nativePointer);
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "Parsing pointer fail. native pointer is ".concat(String.valueOf(nativePointer)), throwable);
            return 0L;
        }
        if (bigInteger.bitLength() > 64) {
            LiteavLog.e(TAG, "Parsing pointer exceeding 64 bits. native pointer is ".concat(String.valueOf(nativePointer)));
            return 0L;
        }
        return bigInteger.longValue();
    }

    private static int getTXChorusRoleIntValue(TXChorusMusicPlayer.TXChorusRole chorusRole) {
        if (chorusRole == null) {
            LiteavLog.w(TAG, "chorus role enum is null. chorusRole=".concat(String.valueOf((Object)chorusRole)));
            return -1;
        }
        switch (chorusRole) {
            case TXChorusRoleLeadSinger: {
                return 1;
            }
            case TXChorusRoleBackSinger: {
                return 2;
            }
            case TXChorusRoleAnchor: {
                return 3;
            }
            case TXChorusRoleAudience: {
                return 4;
            }
        }
        LiteavLog.w(TAG, "chorus role enum is unknown. chorusRole=".concat(String.valueOf((Object)chorusRole)));
        return -1;
    }

    private static int getTXChorusMusicTrackIntValue(TXChorusMusicPlayer.TXChorusMusicTrack musicTrack) {
        if (musicTrack == null) {
            LiteavLog.w(TAG, "music track enum is null. musicTrack=".concat(String.valueOf((Object)musicTrack)));
            return -1;
        }
        switch (musicTrack) {
            case TXChorusAccompaniment: {
                return 1;
            }
            case TXChorusOriginalSong: {
                return 2;
            }
        }
        LiteavLog.w(TAG, "music track enum is unknown. musicTrack=".concat(String.valueOf((Object)musicTrack)));
        return -1;
    }

    private static TXChorusMusicPlayer.TXChorusError convertIntValueToTXChorusError(int chorusErrorValue) {
        switch (chorusErrorValue) {
            case 1: {
                return TXChorusMusicPlayer.TXChorusError.TXChorusErrorInvalidParameters;
            }
            case 2: {
                return TXChorusMusicPlayer.TXChorusError.TXChorusErrorTrtcCloudNotFound;
            }
            case 3: {
                return TXChorusMusicPlayer.TXChorusError.TXChorusErrorRestrictedToLeadSinger;
            }
            case 4: {
                return TXChorusMusicPlayer.TXChorusError.TXChorusErrorMusicPreloadRequired;
            }
            case 5: {
                return TXChorusMusicPlayer.TXChorusError.TXChorusErrorMusicLoadFailed;
            }
            case 6: {
                return TXChorusMusicPlayer.TXChorusError.TXChorusErrorMusicDecodeFailed;
            }
            case 7: {
                return TXChorusMusicPlayer.TXChorusError.TXChorusErrorEnterRoomFailed;
            }
            case 8: {
                return TXChorusMusicPlayer.TXChorusError.TXChorusErrorRoomDisconnected;
            }
            case 9: {
                return TXChorusMusicPlayer.TXChorusError.TXChorusErrorTrtcError;
            }
        }
        LiteavLog.w(TAG, "chorus error value is undefined. chorusErrorValue=".concat(String.valueOf(chorusErrorValue)));
        return null;
    }

    private static native long nativeCreate(long var0, long var2, String var4, ChorusPlayerListener var5);

    private static native void nativeDestroy(long var0);

    private static native void nativeSetChorusRole(long var0, int var2, EnterRoomParams var3);

    private static native void nativeLoadMusic(long var0, String var2, String var3, String var4, String var5);

    private static native void nativeLoadExternalMusic(long var0, String var2, boolean var3, int var4);

    private static native void nativeStart(long var0);

    private static native void nativeStop(long var0);

    private static native void nativePause(long var0);

    private static native void nativeResume(long var0);

    private static native void nativeSeek(long var0, long var2);

    private static native void nativeSwitchMusicTrack(long var0, int var2);

    private static native void nativeSetPlayoutVolume(long var0, int var2);

    private static native void nativeSetPublishVolume(long var0, int var2);

    static class TXReferencePitchList {
        final List<TXChorusMusicPlayer.TXReferencePitch> a;

        public TXReferencePitchList(int initialCapacity) {
            this.a = new ArrayList<TXChorusMusicPlayer.TXReferencePitch>(initialCapacity);
        }

        public void add(int index, long startTimeMs, long durationMs, int referencePitch) {
            TXChorusMusicPlayer.TXReferencePitch tXReferencePitch = new TXChorusMusicPlayer.TXReferencePitch();
            new TXChorusMusicPlayer.TXReferencePitch().startTimeMs = startTimeMs;
            tXReferencePitch.durationMs = durationMs;
            tXReferencePitch.referencePitch = referencePitch;
            this.a.add(index, tXReferencePitch);
        }

        public List<TXChorusMusicPlayer.TXReferencePitch> getTXReferencePitchList() {
            return this.a;
        }
    }

    static class TXChorusLyricCharacterList {
        final List<TXChorusMusicPlayer.TXChorusLyricCharacter> a;

        public TXChorusLyricCharacterList(int initialCapacity) {
            this.a = new ArrayList<TXChorusMusicPlayer.TXChorusLyricCharacter>(initialCapacity);
        }

        public void add(int index, long startTimeMs, long durationMs, String utf8Character) {
            TXChorusMusicPlayer.TXChorusLyricCharacter tXChorusLyricCharacter = new TXChorusMusicPlayer.TXChorusLyricCharacter();
            new TXChorusMusicPlayer.TXChorusLyricCharacter().startTimeMs = startTimeMs;
            tXChorusLyricCharacter.durationMs = durationMs;
            tXChorusLyricCharacter.utf8Character = utf8Character;
            this.a.add(index, tXChorusLyricCharacter);
        }

        public List<TXChorusMusicPlayer.TXChorusLyricCharacter> getChorusLyricCharacterList() {
            return this.a;
        }
    }

    static class TXLyricLineList {
        final List<TXChorusMusicPlayer.TXLyricLine> a;

        public TXLyricLineList(int initialCapacity) {
            this.a = new ArrayList<TXChorusMusicPlayer.TXLyricLine>(initialCapacity);
        }

        public void add(int index, long startTimeMs, long durationMs, List<TXChorusMusicPlayer.TXChorusLyricCharacter> characterArray) {
            TXChorusMusicPlayer.TXLyricLine tXLyricLine = new TXChorusMusicPlayer.TXLyricLine();
            new TXChorusMusicPlayer.TXLyricLine().startTimeMs = startTimeMs;
            tXLyricLine.durationMs = durationMs;
            tXLyricLine.characterArray = characterArray;
            this.a.add(index, tXLyricLine);
        }

        public List<TXChorusMusicPlayer.TXLyricLine> getLyricLineList() {
            return this.a;
        }
    }

    static class EnterRoomParams {
        private final TRTCCloudDef.TRTCParams a;

        public EnterRoomParams(TRTCCloudDef.TRTCParams params) {
            this.a = params;
        }

        public int getSdkAppId() {
            return this.a.sdkAppId;
        }

        public String getUserId() {
            return this.a.userId;
        }

        public String getUserSig() {
            return this.a.userSig;
        }

        public int getRoomId() {
            return this.a.roomId;
        }

        public String getStrRoomId() {
            return this.a.strRoomId;
        }

        public int getRole() {
            return this.a.role;
        }

        public String getStreamId() {
            return this.a.streamId;
        }

        public String getUserDefineRecordId() {
            return this.a.userDefineRecordId;
        }

        public String getPrivateMapKey() {
            return this.a.privateMapKey;
        }

        public String getBusinessInfo() {
            return this.a.businessInfo;
        }
    }

    static class ChorusPlayerListener {
        TXChorusMusicPlayer.ITXChorusPlayerListener a = null;

        private ChorusPlayerListener() {
        }

        public void onChorusError(int errCode, String errMsg) {
            TXChorusMusicPlayer.ITXChorusPlayerListener iTXChorusPlayerListener = this.a;
            if (iTXChorusPlayerListener != null) {
                iTXChorusPlayerListener.onChorusError(TXChorusMusicPlayerImpl.convertIntValueToTXChorusError(errCode), errMsg);
            }
        }

        public void onNetworkQualityUpdated(int quality, int rtt, int loss) {
            TXChorusMusicPlayer.ITXChorusPlayerListener iTXChorusPlayerListener = this.a;
            if (iTXChorusPlayerListener != null) {
                iTXChorusPlayerListener.onNetworkQualityUpdated(quality, rtt, loss);
            }
        }

        public void onChorusRequireLoadMusic(String musicId) {
            TXChorusMusicPlayer.ITXChorusPlayerListener iTXChorusPlayerListener = this.a;
            if (iTXChorusPlayerListener != null) {
                iTXChorusPlayerListener.onChorusRequireLoadMusic(musicId);
            }
        }

        public void onChorusMusicLoadSucceed(String musicId, List<TXChorusMusicPlayer.TXLyricLine> lyricList, List<TXChorusMusicPlayer.TXReferencePitch> pitchList) {
            TXChorusMusicPlayer.ITXChorusPlayerListener iTXChorusPlayerListener = this.a;
            if (iTXChorusPlayerListener != null) {
                iTXChorusPlayerListener.onChorusMusicLoadSucceed(musicId, lyricList, pitchList);
            }
        }

        public void onChorusStarted() {
            TXChorusMusicPlayer.ITXChorusPlayerListener iTXChorusPlayerListener = this.a;
            if (iTXChorusPlayerListener != null) {
                iTXChorusPlayerListener.onChorusStarted();
            }
        }

        public void onChorusPaused() {
            TXChorusMusicPlayer.ITXChorusPlayerListener iTXChorusPlayerListener = this.a;
            if (iTXChorusPlayerListener != null) {
                iTXChorusPlayerListener.onChorusPaused();
            }
        }

        public void onChorusResumed() {
            TXChorusMusicPlayer.ITXChorusPlayerListener iTXChorusPlayerListener = this.a;
            if (iTXChorusPlayerListener != null) {
                iTXChorusPlayerListener.onChorusResumed();
            }
        }

        public void onChorusStopped() {
            TXChorusMusicPlayer.ITXChorusPlayerListener iTXChorusPlayerListener = this.a;
            if (iTXChorusPlayerListener != null) {
                iTXChorusPlayerListener.onChorusStopped();
            }
        }

        public void onMusicProgressUpdated(long progressMs, long durationMs) {
            TXChorusMusicPlayer.ITXChorusPlayerListener iTXChorusPlayerListener = this.a;
            if (iTXChorusPlayerListener != null) {
                iTXChorusPlayerListener.onMusicProgressUpdated(progressMs, durationMs);
            }
        }

        public void onVoicePitchUpdated(int pitch, boolean hasVoice, long progressMs) {
            TXChorusMusicPlayer.ITXChorusPlayerListener iTXChorusPlayerListener = this.a;
            if (iTXChorusPlayerListener != null) {
                iTXChorusPlayerListener.onVoicePitchUpdated(pitch, hasVoice, progressMs);
            }
        }

        public void onVoiceScoreUpdated(int currentScore, int averageScore) {
            TXChorusMusicPlayer.ITXChorusPlayerListener iTXChorusPlayerListener = this.a;
            if (iTXChorusPlayerListener != null) {
                iTXChorusPlayerListener.onVoiceScoreUpdated(currentScore, averageScore);
            }
        }

        public void shouldDecryptAudioData(ByteBuffer audioData) {
            TXChorusMusicPlayer.ITXChorusPlayerListener iTXChorusPlayerListener = this.a;
            if (iTXChorusPlayerListener != null) {
                iTXChorusPlayerListener.shouldDecryptAudioData(audioData);
            }
        }

        /* synthetic */ ChorusPlayerListener(byte by) {
            this();
        }
    }
}

