/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk.common;

import android.text.TextUtils;
import android.util.Log;
import com.tencent.imsdk.common.SystemUtil;

public class IMLog {
    private static final String TAG = IMLog.class.getSimpleName();
    public static final int LOG_LEVEL_OFF = 0;
    public static final int LOG_LEVEL_VERBOSE = 2;
    public static final int LOG_LEVEL_DEBUG = 3;
    public static final int LOG_LEVEL_INFO = 4;
    public static final int LOG_LEVEL_WARN = 5;
    public static final int LOG_LEVEL_ERROR = 6;

    public static void v(String strTag, String strInfo) {
        IMLog.log(2, strTag, strInfo);
    }

    public static void d(String strTag, String strInfo) {
        IMLog.log(3, strTag, strInfo);
    }

    public static void i(String strTag, String strInfo) {
        IMLog.log(4, strTag, strInfo);
    }

    public static void w(String strTag, String strInfo) {
        IMLog.log(5, strTag, strInfo);
    }

    public static void e(String strTag, String strInfo) {
        IMLog.log(6, strTag, strInfo);
    }

    private static void log(int logLevel, String strTag, String strInfo) {
        if (!SystemUtil.loadIMLibrary()) {
            Log.e((String)TAG, (String)"libimsdk.so is not loaded");
            return;
        }
        if (logLevel < 0 || logLevel > 6) {
            IMLog.e(TAG, "invalid logLevel\uff1a " + logLevel);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)strTag)) {
            IMLog.e(TAG, "empty logTag");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)strInfo)) {
            IMLog.e(TAG, "empty logContent");
            return;
        }
        IMLog.nativeWriteLog(logLevel, strTag, "", 0, strInfo);
    }

    public static void writeException(String strTag, String strInfo, Throwable tr) {
        if (!SystemUtil.loadIMLibrary()) {
            Log.e((String)TAG, (String)"libimsdk.so is not loaded");
            return;
        }
        Log.e((String)strTag, (String)(strInfo + " exception : " + Log.getStackTraceString((Throwable)tr)));
    }

    protected static native void nativeWriteLog(int var0, String var1, String var2, int var3, String var4);
}

