/*
 * Decompiled with CFR 0.152.
 */
package com.thunder.livesdk.video.serviceConfig;

import com.thunder.livesdk.ThunderPublishInfo;
import com.thunder.livesdk.ThunderPublishVideoConfig;
import com.thunder.livesdk.helper.ThunderNative;
import com.thunder.livesdk.log.ThunderLog;
import com.thunder.livesdk.video.serviceConfig.VideoLiveConfig;
import com.yy.mediaframework.CameraPreviewConfig;
import com.yy.mediaframework.YYVideoCodec;
import com.yy.mediaframework.base.VideoEncoderConfig;
import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.mediaframework.inteligence.common.ResolutionModifyConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class VideoConfigManager {
    private static final String TAG = "cfg_VideoConfigManage";
    private VideoLiveConfig mCurrentConfig = null;
    private int mCurrentVideoLevel = -1;
    public boolean mDisableHardEncode = false;
    public boolean mDisableHardDecode = false;
    private boolean mPreviewShareCtx = true;
    private boolean mUseClear = false;
    private HashMap<Integer, VideoLiveConfig> mVideoConfigsList = new HashMap();
    private int mCurMultiLianMaiUsers = 0;

    public void updateCurLianMaiUsers(int num) {
        this.mCurMultiLianMaiUsers = num;
    }

    public static VideoConfigManager instance() {
        return SingletonHolder.INSTANCE;
    }

    private VideoConfigManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VideoLiveConfig getVideoLiveConfigByPlayType(int playType) {
        VideoConfigManager videoConfigManager = this;
        synchronized (videoConfigManager) {
            return this.mVideoConfigsList.get(playType);
        }
    }

    public CameraPreviewConfig getCameraPreviewConfigByType(int playType, int mode) {
        CameraPreviewConfig result = new CameraPreviewConfig();
        VideoLiveConfig videoConfig = this.getVideoLiveConfigByPlayType(playType);
        if (videoConfig == null) {
            ThunderLog.error(TAG, " getCameraPreviewConfigByType failed, return default!");
            return result;
        }
        for (int i = 0; i < videoConfig.resolutions.size(); ++i) {
            VideoLiveConfig.ResolutionInfo info = videoConfig.resolutions.get(i);
            if (info.key != mode && (mode != -1 || info.isDefault != 1)) continue;
            result.mCaptureFrameRate = info.previewFrameRate > 0 ? info.previewFrameRate : result.mCaptureFrameRate;
            result.mCaptureResolutionWidth = info.previewWidth > 0 ? info.previewWidth : result.mCaptureResolutionWidth;
            result.mCaptureResolutionHeight = info.previewHeight > 0 ? info.previewHeight : result.mCaptureResolutionHeight;
            this.mCurrentConfig = videoConfig;
            this.mCurrentVideoLevel = info.key;
            break;
        }
        if (ThunderLog.isInfoValid()) {
            ThunderLog.info(TAG, "getCameraPreviewConfigByType playtype:" + playType + " mode:" + mode + "->" + result.toString());
        }
        return result;
    }

    private int convertPlayType(int playType) {
        switch (playType) {
            case 0: {
                playType = 0;
                break;
            }
            case 1: {
                playType = 1;
                break;
            }
            case 2: {
                playType = 5;
                break;
            }
            case 3: {
                playType = 7;
                break;
            }
        }
        return playType;
    }

    public VideoEncoderConfig getVideoEncodeConfigByType(int playType, int mode) {
        VideoEncoderConfig result = new VideoEncoderConfig();
        VideoLiveConfig videoConfig = this.getVideoLiveConfigByPlayType(playType);
        if (videoConfig == null) {
            ThunderLog.warn(TAG, " getVideoEncodeConfigByType failed, return default!");
            return result;
        }
        if (playType != 7 || this.mCurMultiLianMaiUsers == 0) {
            for (int i = 0; i < videoConfig.resolutions.size(); ++i) {
                VideoLiveConfig.ResolutionInfo info = videoConfig.resolutions.get(i);
                if (info.key != mode && (mode != -1 || info.isDefault != 1)) continue;
                result.mEncodeWidth = info.width > 0 ? info.width : result.mEncodeWidth;
                result.mEncodeHeight = info.height > 0 ? info.height : result.mEncodeHeight;
                result.mBitRate = info.currate > 0 ? info.currate * 1000 : result.mBitRate;
                result.mEncodeType = this.convertEncodeIdToType(info.encode_id);
                result.mEncodeParameter = info.encode_param;
                result.mMaxBitRate = info.maxrate * 1000;
                result.mFrameRate = info.frameRate > 0 ? info.frameRate : result.mFrameRate;
                this.mCurrentConfig = videoConfig;
                this.mCurrentVideoLevel = info.key;
                break;
            }
        } else {
            for (int i = 0; i < videoConfig.resolutions.size(); ++i) {
                VideoLiveConfig.ResolutionInfo info = videoConfig.resolutions.get(i);
                if (this.mCurMultiLianMaiUsers < info.minUsers || this.mCurMultiLianMaiUsers > info.maxUsers) continue;
                result.mEncodeWidth = info.width > 0 ? info.width : result.mEncodeWidth;
                result.mEncodeHeight = info.height > 0 ? info.height : result.mEncodeHeight;
                result.mBitRate = info.currate > 0 ? info.currate * 1000 : result.mBitRate;
                result.mEncodeType = this.convertEncodeIdToType(info.encode_id);
                result.mEncodeParameter = info.encode_param;
                result.mMaxBitRate = info.maxrate * 1000;
                result.mFrameRate = info.frameRate > 0 ? info.frameRate : result.mFrameRate;
                this.mCurrentConfig = videoConfig;
                this.mCurrentVideoLevel = info.key;
                break;
            }
        }
        if (this.mDisableHardEncode) {
            if (result.mEncodeType == VideoEncoderType.HARD_ENCODER_H264) {
                result.mEncodeType = VideoEncoderType.SOFT_ENCODER_X264;
                result.mEncodeParameter = "";
            } else if (result.mEncodeType == VideoEncoderType.HARD_ENCODER_H265) {
                result.mEncodeType = VideoEncoderType.SOFT_ENCODER_X264;
                result.mEncodeParameter = "";
            }
        }
        if (ThunderLog.isInfoValid()) {
            ThunderLog.info(TAG, "getVideoEncodeConfigByType :" + playType + " mode:" + mode + "->" + result.toString());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyVideoConfig(HashMap<Integer, VideoLiveConfig> configMap) {
        if (configMap.isEmpty()) {
            return;
        }
        VideoConfigManager videoConfigManager = this;
        synchronized (videoConfigManager) {
            this.mVideoConfigsList.clear();
            this.mVideoConfigsList.putAll(configMap);
        }
    }

    public void notifyBlackCodecConfig(String config) {
        if (config.isEmpty()) {
            return;
        }
        String[] blockEncode = config.split(",");
        for (int i = 0; i < blockEncode.length; ++i) {
            if (blockEncode[i].equalsIgnoreCase(YYVideoCodec.getH264EncodeName())) {
                this.mDisableHardEncode = true;
                continue;
            }
            if (!blockEncode[i].equalsIgnoreCase(YYVideoCodec.getH265EncodeName())) continue;
            this.mDisableHardEncode = true;
        }
    }

    public List<ResolutionModifyConfig> getCurrentModifyConfig() {
        if (this.mCurrentConfig == null) {
            return null;
        }
        ArrayList<ResolutionModifyConfig> modifyconfigs = null;
        for (int i = 0; i < this.mCurrentConfig.resolutions.size(); ++i) {
            VideoLiveConfig.ResolutionInfo resolutionInfo = this.mCurrentConfig.resolutions.get(i);
            if (resolutionInfo.key != this.mCurrentVideoLevel) continue;
            modifyconfigs = new ArrayList<ResolutionModifyConfig>(resolutionInfo.modifyConfig.size());
            for (int j = 0; j < resolutionInfo.modifyConfig.size(); ++j) {
                VideoLiveConfig.ModifyInfo info = resolutionInfo.modifyConfig.get(j);
                ResolutionModifyConfig tmp = new ResolutionModifyConfig(info.width, info.height, info.minCodeRate * 1000, info.maxCodeRate * 1000, info.minFrameRate, info.maxFrameRate, this.convertEncodeIdToType(info.encode_id), info.encode_param);
                modifyconfigs.add(tmp);
            }
        }
        return modifyconfigs;
    }

    public VideoLiveConfig getCurrentVideoLiveConfig() {
        return this.mCurrentConfig;
    }

    public int getCurrentVideoLevel() {
        return this.mCurrentVideoLevel;
    }

    public int getCurrentIntervalSecs() {
        if (this.mCurrentConfig == null) {
            return 10;
        }
        return this.mCurrentConfig.intervalSecs;
    }

    public boolean checkLowDelayByType(int playType) {
        return playType == 1 || playType == 3 || playType == 7;
    }

    public boolean checkMultiLianMaiModeByType(int playType) {
        return playType == 7;
    }

    public void resetCurrentVideoLiveConfig() {
        this.mCurrentConfig = null;
    }

    public int getCurrentBeautifyLevel() {
        return ThunderNative.getBeautifyLevel();
    }

    public boolean getAbroadNetWorkStrategy() {
        return ThunderNative.getAbroadNetWorkStrategy() != 0;
    }

    public boolean getPreviewShareCtxSupport() {
        return this.mPreviewShareCtx;
    }

    public boolean getUseClear() {
        return this.mUseClear;
    }

    public static int getAppCpuSupportMode() {
        return ThunderNative.getAppCpuSupportMode();
    }

    public void disableHardDecode(Boolean disable) {
        this.mDisableHardDecode = disable;
        if (ThunderLog.isInfoValid()) {
            ThunderLog.info(TAG, "disableHardDecode " + this.mDisableHardEncode);
        }
    }

    public void disableHardEncode(Boolean disable) {
        this.mDisableHardEncode = disable;
        if (ThunderLog.isInfoValid()) {
            ThunderLog.info(TAG, "disableHardEncode " + this.mDisableHardEncode);
        }
    }

    public int getDefaultPublishVideoMode(int playType) {
        int mode = -1;
        VideoLiveConfig tmpConfigs = this.getVideoLiveConfigByPlayType(playType);
        if (tmpConfigs == null) {
            ThunderLog.warn(TAG, " getDefaultPublishVideoMode configs == null ");
            return -1;
        }
        for (int i = 0; i < tmpConfigs.resolutions.size(); ++i) {
            VideoLiveConfig.ResolutionInfo info = tmpConfigs.resolutions.get(i);
            if (info.isDefault != 1) continue;
            mode = info.key;
            break;
        }
        if (ThunderLog.isInfoValid()) {
            ThunderLog.info(TAG, " getDefaultPublishVideoMode mode " + mode);
        }
        return mode;
    }

    public int getPlayViewTypeFromStream(int streamType) {
        int decodeType = 0;
        if (this.mDisableHardDecode) {
            if (ThunderLog.isInfoValid()) {
                ThunderLog.info(TAG, " getPlayViewTypeFromStream soft decoder ");
            }
            return decodeType;
        }
        if (streamType == 2) {
            int h265Mode = ThunderNative.getH265SupportMode();
            if (h265Mode == 2) {
                decodeType = 1;
            } else if (ThunderLog.isInfoValid()) {
                ThunderLog.info(TAG, " getPlayViewTypeFromStream  h265 mode " + h265Mode);
            }
        } else if (streamType == 1) {
            int h264Mode = ThunderNative.getH264SupportMode();
            if (h264Mode == 1) {
                decodeType = 1;
            } else if (ThunderLog.isInfoValid()) {
                ThunderLog.info(TAG, " getPlayViewTypeFromStream  h264 mode " + h264Mode);
            }
        }
        if (ThunderLog.isInfoValid()) {
            ThunderLog.info(TAG, " getPlayViewTypeFromStream decodeType :" + decodeType + " streamType " + streamType);
        }
        return decodeType;
    }

    public ThunderPublishVideoConfig getCurrentVideoConfig() {
        ThunderPublishVideoConfig result = new ThunderPublishVideoConfig();
        if (this.mCurrentConfig == null) {
            return result;
        }
        result.playType = this.mCurrentConfig.playType;
        result.mode = this.mCurrentVideoLevel;
        for (int i = 0; i < this.mCurrentConfig.resolutions.size(); ++i) {
            VideoLiveConfig.ResolutionInfo info = this.mCurrentConfig.resolutions.get(i);
            if (info.key != this.mCurrentVideoLevel) continue;
            if (info.encode_id == 200 && !this.mDisableHardEncode) {
                result.hardwareEncoder = true;
                result.encodeType = 1;
            } else if (info.encode_id == 220 && !this.mDisableHardEncode) {
                result.hardwareEncoder = true;
                result.encodeType = 2;
            } else {
                result.hardwareEncoder = false;
                result.encodeType = 1;
            }
            result.encodeBitrate = info.currate;
            result.encodeFrameRate = info.frameRate;
            result.encodeResolutionHeight = info.height;
            result.encodeResolutionWidth = info.width;
            break;
        }
        return result;
    }

    public ThunderPublishInfo getCurrentPublishInfo() {
        ThunderPublishInfo result = new ThunderPublishInfo();
        if (this.mCurrentConfig == null) {
            return result;
        }
        result.playType = this.mCurrentConfig.playType;
        result.publishMode = this.mCurrentVideoLevel;
        for (int i = 0; i < this.mCurrentConfig.resolutions.size(); ++i) {
            VideoLiveConfig.ResolutionInfo info = this.mCurrentConfig.resolutions.get(i);
            if (info.key != this.mCurrentVideoLevel) continue;
            if (info.encode_id == 200 && !this.mDisableHardEncode) {
                result.hardwareEncoder = true;
                result.encodeType = 1;
            } else if (info.encode_id == 220 && !this.mDisableHardEncode) {
                result.hardwareEncoder = true;
                result.encodeType = 2;
            } else {
                result.hardwareEncoder = false;
                result.encodeType = 1;
            }
            result.bitrate = info.currate;
            result.frameRate = info.frameRate;
            result.encodeHeight = info.height;
            result.encodeWidth = info.width;
            break;
        }
        return result;
    }

    public ThunderPublishVideoConfig getRemoteVideoConfig(int playType, int publishMode) {
        ThunderPublishVideoConfig result = new ThunderPublishVideoConfig();
        result.playType = playType;
        result.mode = publishMode;
        result.encodeBitrate = 1200;
        result.encodeFrameRate = 24;
        result.encodeResolutionWidth = 544;
        result.encodeResolutionHeight = 960;
        VideoLiveConfig videoConfig = this.getVideoLiveConfigByPlayType(playType);
        if (videoConfig == null) {
            return result;
        }
        if (playType != 7 || this.mCurMultiLianMaiUsers == 0) {
            for (int i = 0; i < videoConfig.resolutions.size(); ++i) {
                VideoLiveConfig.ResolutionInfo info = videoConfig.resolutions.get(i);
                if (info.key != publishMode && (publishMode != -1 || info.isDefault != 1)) continue;
                if (info.encode_id == 200 && !this.mDisableHardEncode) {
                    result.hardwareEncoder = true;
                    result.encodeType = 1;
                } else if (info.encode_id == 220 && !this.mDisableHardEncode) {
                    result.hardwareEncoder = true;
                    result.encodeType = 2;
                } else {
                    result.hardwareEncoder = false;
                    result.encodeType = 1;
                }
                result.encodeBitrate = info.currate;
                result.encodeMaxBitrate = info.maxrate;
                result.encodeFrameRate = info.frameRate;
                result.encodeResolutionHeight = info.height;
                result.encodeResolutionWidth = info.width;
                break;
            }
        } else {
            for (int i = 0; i < videoConfig.resolutions.size(); ++i) {
                VideoLiveConfig.ResolutionInfo info = videoConfig.resolutions.get(i);
                if (info.minUsers > this.mCurMultiLianMaiUsers || info.maxUsers < this.mCurMultiLianMaiUsers) continue;
                if (info.encode_id == 200 && !this.mDisableHardEncode) {
                    result.hardwareEncoder = true;
                    result.encodeType = 1;
                } else if (info.encode_id == 220 && !this.mDisableHardEncode) {
                    result.hardwareEncoder = true;
                    result.encodeType = 2;
                } else {
                    result.hardwareEncoder = false;
                    result.encodeType = 1;
                }
                result.encodeBitrate = info.currate;
                result.encodeMaxBitrate = info.maxrate;
                result.encodeFrameRate = info.frameRate;
                result.encodeResolutionHeight = info.height;
                result.encodeResolutionWidth = info.width;
                break;
            }
        }
        return result;
    }

    public HashMap<Integer, String> getModeListByPlayType(int playType) {
        HashMap<Integer, String> modeList = new HashMap<Integer, String>();
        VideoLiveConfig videoConfig = this.getVideoLiveConfigByPlayType(playType);
        if (videoConfig == null) {
            ThunderLog.error(TAG, "getModeListByPlayType  config null");
            modeList.put(playType, String.valueOf(2));
            return modeList;
        }
        String modeString = "";
        for (int i = 0; i < videoConfig.resolutions.size(); ++i) {
            VideoLiveConfig.ResolutionInfo info = videoConfig.resolutions.get(i);
            modeList.put(info.key, info.description);
            modeString = modeString + info.key + ":" + info.description;
        }
        if (ThunderLog.isInfoValid()) {
            ThunderLog.info(TAG, "getModeListByPlayType " + playType + " :" + modeString);
        }
        return modeList;
    }

    private VideoEncoderType convertEncodeIdToType(int encodeId) {
        if (encodeId == 200) {
            return VideoEncoderType.HARD_ENCODER_H264;
        }
        if (encodeId == 201) {
            return VideoEncoderType.SOFT_ENCODER_X264;
        }
        if (encodeId == 220) {
            return VideoEncoderType.HARD_ENCODER_H265;
        }
        if (encodeId == 221) {
            return VideoEncoderType.SOFT_ENCODER_H265;
        }
        return VideoEncoderType.SOFT_ENCODER_X264;
    }

    private static class SingletonHolder {
        private static final VideoConfigManager INSTANCE = new VideoConfigManager();

        private SingletonHolder() {
        }
    }
}

