/*
 * Decompiled with CFR 0.152.
 */
package com.thunder.livesdk.video;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.os.Handler;
import android.os.Looper;
import com.thunder.livesdk.ExternalVideoSource;
import com.thunder.livesdk.ThunderConstant;
import com.thunder.livesdk.ThunderDefaultCamera;
import com.thunder.livesdk.ThunderEngine;
import com.thunder.livesdk.ThunderPreviewConfig;
import com.thunder.livesdk.ThunderPublisher;
import com.thunder.livesdk.ThunderScreenCapture;
import com.thunder.livesdk.ThunderVideoCapture;
import com.thunder.livesdk.helper.ThunderNative;
import com.thunder.livesdk.log.ThunderLog;
import com.thunder.livesdk.video.ThunderPreviewView;
import com.thunder.livesdk.video.ThunderVideoHiidoUtil;
import com.thunder.livesdk.video.serviceConfig.VideoConfigManager;
import com.yy.mediaframework.CameraInterface;
import com.yy.mediaframework.CameraListener;
import com.yy.mediaframework.Constant;
import com.yy.mediaframework.IPublishListener;
import com.yy.mediaframework.ITextureListener;
import com.yy.mediaframework.YMFLiveAPI;
import com.yy.mediaframework.YYVideoCodec;
import com.yy.mediaframework.api.YMFVideoEncodeFrame;
import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.mediaframework.base.VideoPublisheParam;
import com.yy.mediaframework.base.YMFLowStreamEncoderConfig;
import com.yy.mediaframework.inteligence.common.ResolutionModifyConfig;
import com.yy.mediaframework.model.Rect;
import com.yy.mediaframework.stat.IYMFBehaviorEventListener;
import com.yy.mediaframework.stat.IYMFExceptionListener;
import com.yy.mediaframework.stat.VideoDataStat;
import com.yy.mediaframework.stat.YMFLiveExceptionStat;
import com.yy.mediaframework.stat.YMFLiveExceptionType;
import com.yy.mediaframework.stat.YMFLiveStatisticManager;
import com.yy.mediaframework.stat.YMFLiveUsrBehaviorStat;
import com.yy.videoplayer.decoder.YYVideoLibMgr;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class ThunderVideoPublishEngineImp
implements ITextureListener,
IPublishListener,
IYMFBehaviorEventListener,
IYMFExceptionListener,
CameraListener {
    private static final String TAG = "ThunderVideoPublishEngineImp";
    private YMFLiveAPI mPublisher = null;
    private static long mCallBackPtr = 0L;
    private static final int VIDEO_STAT_FPS = 0;
    private static final int VIDEO_STAT_BITRATE = 1;
    private static final int VIDEO_STATE_RESOLUTION = 2;
    private static final int VIDEO_PREVIEW_FRAME_RATE = 3;
    private static final int VIDEO_DYNAMIC_ENC_FRAME_RATE = 4;
    private static final int VIDEO_ENCODED_TYPE = 5;
    private ThunderVideoHiidoUtil mVideoPubHiidoUtil = null;
    private ThunderVideoCapture mCapture = null;
    private int mCaptureType = 0;
    private int mCameraState = 5;
    private float mCurZoomFactor = 0.0f;
    private boolean bStartEncode = false;
    private boolean bUserCallEncode = false;
    private boolean bStartCameraCapture = true;
    private Handler mUiHandler = new Handler(Looper.getMainLooper());

    public void onVideoAnchorStatus(Constant.AnchorStatus status) {
        if (!this.bUserCallEncode && status == Constant.AnchorStatus.AnchorStatus_Encoding) {
            return;
        }
        if (status == Constant.AnchorStatus.AnchorStatus_Encoding) {
            this.bUserCallEncode = false;
        }
        if (mCallBackPtr != 0L) {
            this.onVideoAnchorStatus(mCallBackPtr, status.ordinal());
        }
    }

    public void onVideoFrameProcessTime(float maxTime, float avgTime) {
        if (mCallBackPtr != 0L) {
            this.onVideoFrameProcessTime(mCallBackPtr, avgTime, maxTime);
        }
    }

    public void onEncodeFrameData(YMFVideoEncodeFrame videoEncodeFrame) {
        int encodeType = 1;
        boolean bHardware = false;
        byte[] data = videoEncodeFrame.data;
        int len = videoEncodeFrame.len;
        int svcTid = videoEncodeFrame.svcTid;
        int svcSid = videoEncodeFrame.svcSid;
        int frameType = videoEncodeFrame.frameType;
        int streamId = videoEncodeFrame.streamId;
        long pts = videoEncodeFrame.pts;
        long dts = videoEncodeFrame.dts;
        VideoEncoderType encoderType = videoEncodeFrame.encodeType;
        byte[] extraData = videoEncodeFrame.extraData;
        int extraDataLen = videoEncodeFrame.extraDataLen;
        switch (encoderType) {
            case SOFT_ENCODER_X264: {
                bHardware = false;
                encodeType = 1;
                break;
            }
            case HARD_ENCODER_H264: {
                bHardware = true;
                encodeType = 1;
                break;
            }
            case SOFT_ENCODER_H265: {
                bHardware = false;
                encodeType = 2;
                break;
            }
            case HARD_ENCODER_H265: {
                bHardware = true;
                encodeType = 2;
                break;
            }
            case DEFAULT: 
            case ERROR: {
                ThunderLog.warn("yvideo-Java", "unknown encoder type" + encoderType.toString());
                break;
            }
        }
        if (mCallBackPtr != 0L) {
            this.onVideoEncodedFrame(mCallBackPtr, data, len, pts, dts, frameType, encodeType, bHardware, svcTid, svcSid, streamId, extraData, extraDataLen);
        }
    }

    public void onUpdateVideoSizeChanged(long l, int i, int i1) {
        if (mCallBackPtr != 0L) {
            this.onUpdateVideoSizeChanged(mCallBackPtr, l, i, i1);
        }
    }

    public void notifyCameraPreviewParameter(int i, int i1, int i2, CameraInterface.CameraResolutionMode cameraResolutionMode) {
    }

    public void notifyCameraOpenFail(String s) {
    }

    public void onDualOpen(boolean b) {
    }

    public void notifyCameraOpenSuccess() {
    }

    public void onDualPictureSwitch() {
    }

    public void reSetEncodingState() {
    }

    public void onCameraFocusAreaChanged(Rect rect) {
        this.onVideoCaptureFocusChanged(mCallBackPtr, rect.left, rect.top, rect.right - rect.left, rect.top - rect.bottom);
    }

    public void onCameraExposureAreaChanged(Rect rect) {
        this.onVideoCaptureExposureChanged(mCallBackPtr, rect.left, rect.top, rect.right - rect.left, rect.top - rect.bottom);
    }

    public int onTextureCallback(int textureId, int width, int height) {
        if (this.mCapture == null || this.mCaptureType != 0) {
            return textureId;
        }
        ThunderDefaultCamera camera = ThunderEngine.getDefaluteCamera();
        if (camera == null) {
            return textureId;
        }
        if (camera.getCameraDataCallback() == null) {
            return textureId;
        }
        return camera.getCameraDataCallback().onTextureCallback(textureId, width, height);
    }

    public ThunderVideoPublishEngineImp() {
        final CountDownLatch waitSync = new CountDownLatch(1);
        Runnable runTestVideoEncoderCrash = new Runnable(){

            @Override
            public void run() {
                try {
                    YYVideoCodec.testVideoEncoderCrash();
                }
                catch (Exception e) {
                    ThunderLog.error(ThunderVideoPublishEngineImp.TAG, "testVideoEncoderCrash crash " + e.toString());
                }
                waitSync.countDown();
            }
        };
        new Thread(runTestVideoEncoderCrash).start();
        try {
            waitSync.await(500L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            ThunderLog.error(TAG, "testVideoEncoderCrash waitSync crash " + e.toString());
        }
    }

    public void onBehaviorEvent(String name, String val, String oval, int level) {
        ThunderNative.makeBehaviorEvent(name, val, oval, level);
    }

    public void onVideoLiveAbnormalStateNotification(YMFLiveExceptionType type) {
        if (ThunderLog.isInfoValid()) {
            ThunderLog.info(TAG, "onVideoLiveAbnormalStateNotification:" + type);
        }
        if (mCallBackPtr != 0L) {
            this.onVideoCaptureEncodeEvent(mCallBackPtr, type.getValue());
            if (type == YMFLiveExceptionType.AnchorStatus_CAPTURE_USED_BY_HIGHER_PRIORITY) {
                this.mCameraState = 3;
                this.onVideoCaptureStatus(mCallBackPtr, this.mCameraState);
            }
        }
    }

    public void pubInit() {
        this.mPublisher = YMFLiveAPI.getInstance();
        this.mVideoPubHiidoUtil = new ThunderVideoHiidoUtil(YYVideoLibMgr.instance().getAppContext());
        this.mPublisher.setPublishListener((IPublishListener)this);
        this.mPublisher.setCameraListener((CameraListener)this);
        YMFLiveUsrBehaviorStat.getInstance().setYMFBehaviorEventListener((IYMFBehaviorEventListener)this);
        YMFLiveExceptionStat.getInstance().setYMFExceptionListener((IYMFExceptionListener)this);
    }

    public boolean startVideoEngine() {
        return true;
    }

    public boolean stopVideoEngine() {
        return true;
    }

    public int attachVideoCapture(Object capture, int captureType) {
        if (this.mPublisher == null) {
            return -4001;
        }
        if (captureType == this.mCaptureType && (this.mCaptureType == 0 || this.mCaptureType == 1 || this.mCaptureType == 2 && this.mCapture.equals(capture))) {
            ThunderLog.error(TAG, "attachVideoCapture same captureType curType %d, newType %d", this.mCaptureType, captureType);
            return -4001;
        }
        if (this.bStartEncode) {
            if (this.mCapture == null || this.mCaptureType == 0) {
                this.mPublisher.stopEncodeVideo();
            } else if (this.mCapture != null && this.mCaptureType == 1) {
                this.mPublisher.stopEncodeScreen();
                this.mPublisher.stopScreenCapture();
            } else if (this.mCapture != null && this.mCaptureType == 2) {
                this.mPublisher.stopEncodeOrigin();
                this.mPublisher.stopOriginCapture();
                this.mCapture.stopCapture();
            }
        }
        this.mCaptureType = captureType;
        this.mCapture = (ThunderVideoCapture)capture;
        if (ThunderLog.isInfoValid()) {
            ThunderLog.info(TAG, "attach capture: %s, type %d", this.mCapture.toString(), this.mCaptureType);
        }
        if (this.bStartEncode) {
            this.mPublisher.setAbroadNetWorkStrategy(VideoConfigManager.instance().getAbroadNetWorkStrategy());
            this.mPublisher.notifyChangeVideoSourceState();
            if (this.mCapture != null && this.mCaptureType == 2) {
                if (((ExternalVideoSource)this.mCapture).getExternalVideoBuffType() == 2) {
                    this.mPublisher.startOriginCapture(true);
                } else {
                    this.mPublisher.startOriginCapture(false);
                }
                this.mCapture.startCapture(new ThunderPublisher.IVideoPublisher(){

                    @Override
                    public void pushVideoData(byte[] data, int format, int width, int height, int rotation, long timestamp) {
                        ThunderVideoPublishEngineImp.this.setOriginFrameToEncode(data, format, width, height, rotation, timestamp);
                    }

                    @Override
                    public void pushVideoData(byte[] encodedData, ThunderConstant.ThunderVideoEncodeType type, long dts, long pts) {
                    }

                    @Override
                    public void pushVideoTexture(int textureID, int textureFormat, int width, int height, int rotation, long timeStamp, float[] transform) {
                        ThunderVideoPublishEngineImp.this.setOriginTextureToEncode(textureID, textureFormat, width, height, rotation, timeStamp, transform);
                    }
                });
                this.mPublisher.startEncodeOrigin();
            } else if (this.mCapture != null && this.mCaptureType == 1) {
                this.mPublisher.startScreenCapture(((ThunderScreenCapture)this.mCapture).getMediaProjection());
                this.mPublisher.startEncodeScreen();
            } else {
                this.mPublisher.startEncodeVideo();
            }
        }
        return 0;
    }

    public int startVideoCapture() {
        this.mCameraState = this.mPublisher.startVideoCapture();
        this.bStartCameraCapture = true;
        if (mCallBackPtr != 0L) {
            this.onVideoCaptureStatus(mCallBackPtr, this.mCameraState);
        }
        return this.mCameraState;
    }

    public int stopVideoCapture() {
        this.mPublisher.stopVideoCapture();
        this.bStartCameraCapture = false;
        if (mCallBackPtr != 0L && this.mCameraState == 0) {
            this.onVideoCaptureStatus(mCallBackPtr, 5);
        }
        return 0;
    }

    public int pauseVideoCapture(boolean bPauseCapture) {
        this.mCameraState = this.mPublisher.pauseVideoCapture(bPauseCapture);
        return 0;
    }

    public int startPreview(final Object toView, int renderMode) {
        if (toView != null && toView instanceof ThunderPreviewView) {
            if (((ThunderPreviewView)((Object)toView)).checkViewType(this.mPublisher.getPreViewType())) {
                ThunderLog.warn(TAG, "startPreview: enableVideoPublishBufferProcess error!");
                CountDownLatch waitSync = new CountDownLatch(1);
                if (Thread.currentThread().getId() == this.mUiHandler.getLooper().getThread().getId()) {
                    ((ThunderPreviewView)((Object)toView)).changeViewType();
                } else {
                    this.mUiHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            ((ThunderPreviewView)((Object)toView)).changeViewType();
                        }
                    });
                    try {
                        waitSync.await();
                    }
                    catch (Exception e) {
                        ThunderLog.error(TAG, "changeViewType waitSync crash " + e.toString());
                    }
                }
            }
            this.mPublisher.startPreview(((ThunderPreviewView)((Object)toView)).getSurfaceView(), renderMode);
        } else {
            this.mPublisher.startPreview(null, renderMode);
            if (ThunderLog.isInfoValid()) {
                ThunderLog.info(TAG, "startPreview: invalid view " + toView);
            }
        }
        return 0;
    }

    public int stopPreview() {
        this.mPublisher.stopPreview();
        return 0;
    }

    public int setCaptureReplaceImage(Object bitmap) {
        return this.mPublisher.setCaptureReplaceImage((Bitmap)bitmap);
    }

    public Object captureLocalScreenShot() {
        return this.mPublisher.captureLocalScreenShot();
    }

    public int startEncodeVideo() {
        this.bUserCallEncode = true;
        this.mPublisher.setAbroadNetWorkStrategy(VideoConfigManager.instance().getAbroadNetWorkStrategy());
        if (this.mCapture != null && this.mCaptureType == 2) {
            if (((ExternalVideoSource)this.mCapture).getExternalVideoBuffType() == 2) {
                this.mPublisher.startOriginCapture(true);
            } else {
                this.mPublisher.startOriginCapture(false);
            }
            this.mCapture.startCapture(new ThunderPublisher.IVideoPublisher(){

                @Override
                public void pushVideoData(byte[] data, int format, int width, int height, int rotation, long timestamp) {
                    ThunderVideoPublishEngineImp.this.setOriginFrameToEncode(data, format, width, height, rotation, timestamp);
                }

                @Override
                public void pushVideoData(byte[] encodedData, ThunderConstant.ThunderVideoEncodeType type, long dts, long pts) {
                }

                @Override
                public void pushVideoTexture(int textureID, int textureFormat, int width, int height, int rotation, long timeStamp, float[] transform) {
                    ThunderVideoPublishEngineImp.this.setOriginTextureToEncode(textureID, textureFormat, width, height, rotation, timeStamp, transform);
                }
            });
            this.mPublisher.startEncodeOrigin();
        } else if (this.mCapture != null && this.mCaptureType == 1) {
            this.mPublisher.startScreenCapture(((ThunderScreenCapture)this.mCapture).getMediaProjection());
            this.mPublisher.startEncodeScreen();
        } else if (this.mCaptureType == 0) {
            this.mPublisher.startEncodeVideo();
        }
        this.bStartEncode = true;
        return 0;
    }

    public int stopEncodeVideo() {
        if (this.mCapture != null && this.mCaptureType == 2) {
            this.mPublisher.stopEncodeOrigin();
            this.mPublisher.stopOriginCapture();
            this.mCapture.stopCapture();
        } else if (this.mCapture != null && this.mCaptureType == 1) {
            this.mPublisher.stopEncodeScreen();
            this.mPublisher.stopScreenCapture();
        } else {
            this.mPublisher.stopEncodeVideo();
        }
        this.bStartEncode = false;
        return 0;
    }

    public void setPreviewRenderMode(int scaleMode) {
        this.mPublisher.setPreviewRenderMode(scaleMode);
    }

    public void changeScreenLiveMode(boolean bPicMode, Object bitmap) {
        if (this.mPublisher != null) {
            this.mPublisher.changeScreenLiveMode(Boolean.valueOf(bPicMode), (Bitmap)bitmap);
        }
    }

    public int updateVideoPublishConfig(VideoPublishParams params) {
        VideoPublisheParam param = new VideoPublisheParam();
        param.bLowLatency = params.bLowLatency;
        param.bWebSdkCompatibility = params.bWebSdkCompatibility;
        param.captureFrameRate = params.captureFrameRate;
        param.captureResolutionWidth = params.captureResolutionWidth;
        param.captureResolutionHeight = params.captureResolutionHeight;
        param.screenOrientation = params.screenOrientation;
        param.codecid = params.codecid;
        param.encodeFrameRate = params.encodeFrameRate;
        param.encodeBitrate = params.encodeBitrate * 1000;
        param.encodeMaxBitrate = params.encodeMaxBitrate * 1000;
        param.encodeMinBitrate = params.encodeMinBitrate * 1000;
        param.encodeResolutionWidth = params.encodeResolutionWidth;
        param.encodeResolutionHeight = params.encodeResolutionHeight;
        param.weakNetConfigsIntervalSecs = params.weakNetConfigsIntervalSecs;
        param.encodeType = this.switchVideoEncodeType(params.codecid);
        param.bEnableLocalDualStreamMode = params.bEnableLocalDualStreamMode;
        param.encoderParam = params.encoderParam;
        for (VideoPublishWeakNetParam weakNetParam : params.weakNetCfgs) {
            ResolutionModifyConfig config = new ResolutionModifyConfig(weakNetParam.resolutionWidth, weakNetParam.resolutionHeight, weakNetParam.minCodeRate * 1000, weakNetParam.maxCodeRate * 1000, weakNetParam.minFrameRate, weakNetParam.maxFrameRate, this.switchVideoEncodeType(weakNetParam.codecid), weakNetParam.encoderParam);
            param.weakNetConfigs.add(config);
        }
        for (VideoPublishLowStreamConfig LowStreamParam : params.lowStreamCfgs) {
            YMFLowStreamEncoderConfig config = new YMFLowStreamEncoderConfig();
            config.mConfigId = LowStreamParam.type;
            config.mEncoderId = LowStreamParam.codecid;
            config.mEncodeWidth = LowStreamParam.resolutionWidth;
            config.mEncodeHeight = LowStreamParam.resolutionHeight;
            config.mFrameRate = LowStreamParam.encodeFrameRate;
            config.mCodeRate = LowStreamParam.encodeCodeRate * 1000;
            config.mMaxCodeRate = LowStreamParam.maxCodeRate * 1000;
            config.mMinCodeRate = LowStreamParam.minCodeRate * 1000;
            config.mTranscoding = LowStreamParam.transcoding;
            config.mEncodeParam = LowStreamParam.encoderParam;
            param.lowStreamConfigs.add(config);
        }
        this.mPublisher.updatePublisherConfig(param);
        return 0;
    }

    public int setCameraPosition(int position) {
        ThunderDefaultCamera camera = ThunderEngine.getDefaluteCamera();
        int ret = -4001;
        if (camera != null) {
            ((ThunderPreviewConfig)camera.getCaptureConfig()).cameraPosition = position;
            ret = this.mPublisher.setCameraPosition(position);
        } else {
            ThunderLog.warn(TAG, "setCameraPosition get null camera");
        }
        return ret;
    }

    public boolean setCameraTorchOn(boolean isOn) {
        boolean ret = false;
        if (this.mPublisher != null) {
            ret = this.mPublisher.setCameraTorchOn(isOn);
        }
        return ret;
    }

    public boolean isCameraOpen() {
        boolean ret = false;
        if (this.mPublisher != null) {
            ret = this.mPublisher.isCameraOpen();
        }
        return ret;
    }

    public boolean isCameraZoomSupported() {
        boolean ret = false;
        if (this.mPublisher != null) {
            ret = this.mPublisher.isCameraZoomSupported();
        }
        return ret;
    }

    public float getCameraMaxZoomFactor() {
        if (this.mPublisher == null) {
            return -4001.0f;
        }
        return this.mPublisher.getCameraMaxZoomFactor();
    }

    public int setCameraZoomFactor(float zoomFactor) {
        if (this.mPublisher == null) {
            return -4001;
        }
        return this.mPublisher.setCameraZoomFactor(zoomFactor);
    }

    public boolean isCameraTorchSupported() {
        if (this.mPublisher == null) {
            return false;
        }
        return this.mPublisher.isCameraTorchSupported();
    }

    public boolean isCameraManualFocusPositionSupported() {
        if (this.mPublisher == null) {
            return false;
        }
        return this.mPublisher.isCameraManualFocusPositionSupported();
    }

    public int setCameraFocusPosition(float posX, float posY) {
        if (this.mPublisher == null) {
            return -4001;
        }
        return this.mPublisher.setCameraFocusPosition(posX, posY);
    }

    public boolean isCameraManualExposurePositionSupported() {
        if (this.mPublisher == null) {
            return false;
        }
        return this.mPublisher.isCameraManualExposurePositionSupported();
    }

    public int setCameraExposurePosition(float posX, float posY) {
        if (this.mPublisher == null) {
            return -4001;
        }
        return this.mPublisher.setCameraExposurePosition(posX, posY);
    }

    public boolean isCameraAutoFocusFaceModeSupported() {
        if (this.mPublisher == null) {
            return false;
        }
        return this.mPublisher.isCameraAutoFocusFaceModeSupported();
    }

    public int setCameraAutoFocusFaceModeEnabled(boolean enable) {
        if (this.mPublisher == null) {
            return -4001;
        }
        return this.mPublisher.setCameraAutoFocusFaceModeEnabled(enable);
    }

    public boolean isFrontCamera() {
        if (this.mPublisher == null) {
            return false;
        }
        return this.mPublisher.isFrontCamera();
    }

    public int getVideoCaptureOrientation() {
        if (this.mPublisher == null) {
            return -4001;
        }
        return this.mPublisher.getCameraOrientation();
    }

    public int setPubWatermark(int x, int y, int width, int height, String imageUrl) {
        int ret;
        block4: {
            ret = 0;
            Bitmap bitmap = null;
            Bitmap tmpBitmap = null;
            try {
                if (imageUrl != null && !imageUrl.isEmpty()) {
                    FileInputStream fis = new FileInputStream(imageUrl);
                    tmpBitmap = BitmapFactory.decodeStream((InputStream)fis);
                    fis.close();
                    int w = tmpBitmap.getWidth();
                    int h = tmpBitmap.getHeight();
                    Matrix matrix = new Matrix();
                    float scaleW = (float)width / (float)w;
                    float scaleH = (float)height / (float)h;
                    matrix.postScale(scaleW, scaleH);
                    bitmap = Bitmap.createBitmap((Bitmap)tmpBitmap, (int)0, (int)0, (int)w, (int)h, (Matrix)matrix, (boolean)true);
                }
                ret = this.mPublisher.setWatermark(bitmap, x, y);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (bitmap != null && !bitmap.isRecycled()) {
                    bitmap.recycle();
                }
                if (tmpBitmap == null || tmpBitmap.isRecycled()) break block4;
                tmpBitmap.recycle();
            }
        }
        return ret;
    }

    public int onDynamicBitrate(long bitrate) {
        this.mPublisher.setNetworkBitrateSuggest((int)bitrate * 1000);
        return 0;
    }

    public int setPublisherPtsAdjustVal(int adjustVal) {
        if (this.mPublisher != null) {
            this.mPublisher.setDeltaYYPtsMillions((long)adjustVal);
        }
        return 0;
    }

    public int setLocalVideoMirrorMode(int mode) {
        if (this.mPublisher == null) {
            return -4001;
        }
        return this.mPublisher.setLocalVideoMirrorMode(mode);
    }

    public float getCameraZoomFactor() {
        return this.mCurZoomFactor;
    }

    public int onRequestIFrame() {
        this.mPublisher.requestEncodeIFrame();
        return 0;
    }

    public void setVideoPublishEngineCallBack(long ptr) {
        mCallBackPtr = ptr;
    }

    public static String getVideoPubLibVersion() {
        return "200.3.1.2";
    }

    public String getAnchorHiidoStatInfo(long streamId) {
        String anchorStat = "";
        if (this.mVideoPubHiidoUtil != null) {
            ThunderVideoPublishEngineImp thunderVideoPublishEngineImp = this;
            anchorStat = thunderVideoPublishEngineImp.mVideoPubHiidoUtil.getAnchorStatInfo();
        }
        return VideoDataStat.getInstance().getAnchorVideoData(streamId) + anchorStat;
    }

    public int getPublishRuntimeInfo(int type, int typeId) {
        switch (type) {
            case 0: {
                return this.mPublisher.getVideoPublishInfo(YMFLiveAPI.VideoPublishInfoEnum.FRAME, typeId);
            }
            case 1: {
                return this.mPublisher.getVideoPublishInfo(YMFLiveAPI.VideoPublishInfoEnum.BITRATE, typeId);
            }
            case 2: {
                return this.mPublisher.getVideoPublishInfo(YMFLiveAPI.VideoPublishInfoEnum.RESOLUTION, typeId);
            }
            case 3: {
                return this.mPublisher.getVideoPublishInfo(YMFLiveAPI.VideoPublishInfoEnum.PREVIEW_FRAME_RATE, typeId);
            }
            case 4: {
                return this.mPublisher.getVideoPublishInfo(YMFLiveAPI.VideoPublishInfoEnum.DYNAMIC_ENC_FRAME_RATE, typeId);
            }
            case 5: {
                int encodedType = this.mPublisher.getVideoPublishInfo(YMFLiveAPI.VideoPublishInfoEnum.ENCODETYPE, typeId);
                if (VideoEncoderType.HARD_ENCODER_H264.ordinal() == encodedType || VideoEncoderType.HARD_ENCODER_H265.ordinal() == encodedType) {
                    return 1;
                }
                if (VideoEncoderType.SOFT_ENCODER_X264.ordinal() == encodedType || VideoEncoderType.SOFT_ENCODER_H265.ordinal() == encodedType) {
                    return 2;
                }
                return 0;
            }
        }
        return 0;
    }

    public void notifyEncodeBlackList(String blacklist) {
        if (blacklist.isEmpty()) {
            return;
        }
        String[] blockEncode = blacklist.split(",");
        for (int i = 0; i < blockEncode.length; ++i) {
            if (!blockEncode[i].equalsIgnoreCase(YYVideoCodec.getH264EncodeName()) && !blockEncode[i].equalsIgnoreCase(YYVideoCodec.getH265EncodeName()) || this.mPublisher == null) continue;
            if (ThunderLog.isInfoValid()) {
                ThunderLog.info(TAG, "notifyEncodeBlackList to videoLib, content: %s", blockEncode[i]);
            }
            this.mPublisher.setHardwareEncoderAvailable(false);
        }
    }

    public int enableVideoPublishBufferProcess(boolean bBufferMode) {
        if (ThunderLog.isInfoValid()) {
            ThunderLog.info(TAG, "enableVideoPublishBufferProcess:" + bBufferMode);
        }
        return this.mPublisher.setYuvCanvasMode(bBufferMode);
    }

    public void updateArgoConfig(HashMap<String, String> argoConfigMap) {
        if (argoConfigMap.isEmpty()) {
            return;
        }
        if (ThunderLog.isInfoValid()) {
            ThunderLog.info(TAG, "updateArgoConfig:" + argoConfigMap);
        }
        this.mPublisher.setVideoUpCommonConfig(argoConfigMap);
    }

    public void destroyPublishEngine() {
        YMFLiveUsrBehaviorStat.getInstance().setYMFBehaviorEventListener(null);
        if (this.mPublisher != null) {
            this.mPublisher.destory();
        }
        this.reset();
    }

    private void reset() {
        this.mCaptureType = 0;
        this.mCameraState = 5;
        this.bStartEncode = false;
    }

    private void setOriginFrameToEncode(byte[] data, int format, int width, int height, int rotation, long timestamp) {
        if (this.mPublisher != null) {
            this.mPublisher.setOriginFrameToEncode(data, format, width, height, rotation, timestamp);
        }
    }

    private void setOriginTextureToEncode(int textureID, int textureFormat, int width, int height, int rotation, long timeStamp, float[] transform) {
        if (this.mPublisher != null) {
            this.mPublisher.setOriginTextureToEncode(textureID, textureFormat, width, height, rotation, timeStamp, transform);
        }
    }

    private VideoEncoderType switchVideoEncodeType(int codecid) {
        VideoEncoderType ret = VideoEncoderType.DEFAULT;
        switch (codecid) {
            case 200: {
                ret = VideoEncoderType.HARD_ENCODER_H264;
                break;
            }
            case 201: {
                ret = VideoEncoderType.SOFT_ENCODER_X264;
                break;
            }
            case 220: {
                ret = VideoEncoderType.HARD_ENCODER_H265;
                break;
            }
            case 221: {
                ret = VideoEncoderType.SOFT_ENCODER_H265;
                break;
            }
            default: {
                ret = VideoEncoderType.DEFAULT;
            }
        }
        return ret;
    }

    public String getVideoEncodeBaseStatics(int sendSeq) {
        return YMFLiveStatisticManager.getInstance().getBaseUploadVideoStatistics(sendSeq);
    }

    public String getVideoEncodeStatics(boolean bKeyStat, int publishId) {
        String anchorStat = "";
        if (this.mVideoPubHiidoUtil != null) {
            ThunderVideoPublishEngineImp thunderVideoPublishEngineImp = this;
            anchorStat = thunderVideoPublishEngineImp.mVideoPubHiidoUtil.getAnchorStatInfo();
        }
        return YMFLiveStatisticManager.getInstance().getUploadVideoStatistics(bKeyStat, publishId) + anchorStat;
    }

    private native void onVideoEncodedFrame(long var1, byte[] var3, int var4, long var5, long var7, int var9, int var10, boolean var11, int var12, int var13, int var14, byte[] var15, int var16);

    private native void onVideoCaptureStatus(long var1, int var3);

    private native void onUpdateVideoSizeChanged(long var1, long var3, int var5, int var6);

    private native void onVideoAnchorStatus(long var1, int var3);

    private native void onVideoCaptureEncodeEvent(long var1, int var3);

    private native void onVideoCaptureFocusChanged(long var1, float var3, float var4, float var5, float var6);

    private native void onVideoCaptureExposureChanged(long var1, float var3, float var4, float var5, float var6);

    private native void onVideoFrameProcessTime(long var1, float var3, float var4);

    public class VideoPublishLowStreamConfig {
        public int type;
        public int resolutionWidth;
        public int resolutionHeight;
        public int encodeCodeRate;
        public int maxCodeRate;
        public int minCodeRate;
        public int encodeFrameRate;
        public int codecid;
        public int transcoding;
        public String encoderParam;
    }

    public class VideoPublishWeakNetParam {
        public int resolutionWidth;
        public int resolutionHeight;
        public int minCodeRate;
        public int maxCodeRate;
        public int minFrameRate;
        public int maxFrameRate;
        public int codecid;
        public String encoderParam;
    }

    public class VideoPublishParams {
        public boolean bLowLatency;
        public boolean bWebSdkCompatibility;
        public boolean bEnableLocalDualStreamMode;
        public int captureFrameRate;
        public int captureResolutionWidth;
        public int captureResolutionHeight;
        public int screenOrientation;
        public int codecid;
        public int encodeFrameRate;
        public int encodeBitrate;
        public int encodeMaxBitrate;
        public int encodeMinBitrate;
        public int encodeResolutionWidth;
        public int encodeResolutionHeight;
        public int weakNetConfigsIntervalSecs;
        public String encoderParam;
        public List<VideoPublishWeakNetParam> weakNetCfgs = new ArrayList<VideoPublishWeakNetParam>();
        public List<VideoPublishLowStreamConfig> lowStreamCfgs = new ArrayList<VideoPublishLowStreamConfig>();
    }
}

