/*
 * Decompiled with CFR 0.152.
 */
package com.thunder.livesdk.video;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.SurfaceView;
import android.view.View;
import com.thunder.livesdk.log.ThunderLog;
import com.thunder.livesdk.video.VideoPlayerView;
import com.yy.mediaframework.Constant;
import com.yy.mediaframework.YYVideoSDK;
import com.yy.videoplayer.YMFPlayerAPI;
import com.yy.videoplayer.view.YMFLayoutParams;
import com.yy.videoplayer.view.YMFVideoPosition;
import java.util.concurrent.CountDownLatch;

public class ThunderPlayerView
extends VideoPlayerView {
    private final String TAG = "ThunderPlayerView " + Integer.toHexString(((Object)((Object)this)).hashCode());
    private Handler mUiHandler = null;
    private YMFLayoutParams mYMFLayoutParams;
    private long mStreamId = 0L;
    private YMFPlayerAPI mYMFPlayerInstance = null;
    public final int INVALID_STREAM_ID = -1;

    public ThunderPlayerView(Context context) {
        super(context);
        this.addView((View)new SurfaceView(context));
        this.init();
    }

    public ThunderPlayerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.addView((View)new SurfaceView(context));
        this.init();
    }

    public ThunderPlayerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.addView((View)new SurfaceView(context));
        this.init();
    }

    private void init() {
        this.mUiHandler = new Handler(Looper.getMainLooper());
    }

    public boolean isViewLinkedToStream() {
        return this.mStreamId != 0L;
    }

    public boolean isViewPrepared() {
        return this.mPrepared;
    }

    public boolean createVideoView() {
        if (this.mYMFPlayerInstance == null) {
            this.mYMFPlayerInstance = YMFPlayerAPI.newInstance();
        }
        this.mUniformView = this.mYMFPlayerInstance.createView(this.getContext());
        if (this.mUniformView != null) {
            this.addView(this.mUniformView);
            if (this.mYMFLayoutParams != null) {
                this.mYMFPlayerInstance.setViewLayout(this.mUniformView, this.mYMFLayoutParams);
            }
            this.mYMFPlayerInstance.setScaleMode(this.mUniformView, this.mScaleMode, -1);
            this.mPrepared = true;
        }
        ThunderLog.release("yvideo-Java", "createUnityVideoView: size " + this.getWidth() + "x" + this.getHeight());
        return true;
    }

    @Override
    public boolean prepareView() {
        this.unPrepareView();
        ThunderLog.release("yvideo-Java", this.TAG + " prepareView");
        return this.createVideoView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unPrepareView() {
        ThunderPlayerView thunderPlayerView = this;
        synchronized (thunderPlayerView) {
            this.removeAllViews();
            if (this.mYMFPlayerInstance != null) {
                this.mYMFPlayerInstance.destroyView(this.mUniformView);
                this.mUniformView = null;
                this.mPrepared = false;
            }
        }
        ThunderLog.release("yvideo-Java", this.TAG + " unPrepareView.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkToStream(long streamId) {
        ThunderPlayerView thunderPlayerView = this;
        synchronized (thunderPlayerView) {
            if (this.mYMFPlayerInstance != null && this.mUniformView != null) {
                this.mYMFPlayerInstance.linkStream(this.mUniformView, streamId, -1);
            }
            this.mStreamId = streamId;
        }
        ThunderLog.release("yvideo-Java", this.TAG + " linkToStream " + streamId);
    }

    public int linkToStream(long streamId, int videoIndex) {
        ThunderLog.release("yvideo-Java", this.TAG + " linkToStream mUniformView " + this.mUniformView + " linkToStream " + streamId + " videoIndex " + videoIndex);
        if (streamId == 0L) {
            return -1;
        }
        if (videoIndex < 0) {
            return -1;
        }
        if (this.mUniformView == null) {
            return -1;
        }
        if (this.mYMFPlayerInstance != null) {
            return this.mYMFPlayerInstance.linkStream(this.mUniformView, streamId, videoIndex);
        }
        return 0;
    }

    public int unLinkFromStream(long streamId, int videoIndex) {
        ThunderLog.release("yvideo-Java", this.TAG + " unLinkFromStream mUniformView " + this.mUniformView + " linkToStream " + streamId + " videoIndex " + videoIndex);
        if (streamId == 0L) {
            return -1;
        }
        if (videoIndex < 0) {
            return -1;
        }
        if (this.mUniformView == null) {
            return -1;
        }
        if (this.mYMFPlayerInstance != null) {
            return this.mYMFPlayerInstance.unLinkStream(this.mUniformView, streamId, videoIndex);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unLinkFromStream(long streamId) {
        ThunderPlayerView thunderPlayerView = this;
        synchronized (thunderPlayerView) {
            if (this.mYMFPlayerInstance != null && this.mUniformView != null) {
                this.mYMFPlayerInstance.unLinkStream(this.mUniformView, streamId, -1);
            }
            this.mStreamId = 0L;
        }
        ThunderLog.release("yvideo-Java", this.TAG + " unLinkFromStream " + streamId);
    }

    public void unLinkFromStream() {
        if (this.mYMFPlayerInstance != null && this.mUniformView != null) {
            this.mYMFPlayerInstance.unLinkStream(this.mUniformView, this.mStreamId, -1);
        }
        this.mStreamId = 0L;
        ThunderLog.release("yvideo-Java", this.TAG + " unLinkFromStream() ");
    }

    public boolean setScaleMode(int scaleMode) {
        boolean result = false;
        this.mScaleMode = this.scaleModeConvert(scaleMode);
        if (this.mYMFPlayerInstance != null) {
            this.mYMFPlayerInstance.setScaleMode(this.mUniformView, this.mScaleMode, -1);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setScaleMode(int seatId, int scaleMode) {
        boolean result = false;
        ThunderPlayerView thunderPlayerView = this;
        synchronized (thunderPlayerView) {
            this.mScaleMode = this.scaleModeConvert(scaleMode);
            if (this.mYMFPlayerInstance != null) {
                this.mYMFPlayerInstance.setScaleMode(this.mUniformView, this.mScaleMode, seatId);
            }
        }
        return result;
    }

    public void setMirrorMode(int seatId, int mirrorMode) {
        this.mMirrorMode = this.mirrorModeConvert(mirrorMode);
        if (this.mYMFPlayerInstance != null) {
            this.mYMFPlayerInstance.setMirrorMode(this.mUniformView, this.mMirrorMode, seatId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap getVideoScreenshot(int seatId) {
        ThunderPlayerView thunderPlayerView = this;
        synchronized (thunderPlayerView) {
            if (this.mYMFPlayerInstance != null) {
                return this.mYMFPlayerInstance.getVideoScreenshot(this.mUniformView, seatId);
            }
        }
        return null;
    }

    public void prepareViewUI(final long streamId) {
        ThunderLog.release("yvideo-Java", this.TAG + " prepareViewUI, streamId " + streamId);
        if (this.mUiHandler != null) {
            if (Thread.currentThread().getId() == this.mUiHandler.getLooper().getThread().getId()) {
                this.unLinkFromStream();
                this.prepareView();
                if (streamId != -1L) {
                    this.linkToStream(streamId);
                }
            } else {
                final CountDownLatch barrier = new CountDownLatch(1);
                this.mUiHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ThunderPlayerView.this.unLinkFromStream();
                        ThunderPlayerView.this.prepareView();
                        if (streamId != -1L) {
                            ThunderPlayerView.this.linkToStream(streamId);
                        }
                        barrier.countDown();
                    }
                });
                try {
                    barrier.await();
                }
                catch (InterruptedException e) {
                    ThunderLog.error("ThunderVideoEngineImp", "updatePlayVideoStream .barrier.await" + e.toString());
                }
            }
        }
    }

    public void unPrepareViewUI() {
        ThunderLog.release("yvideo-Java", this.TAG + " unPrepareViewUI.");
        if (this.mUiHandler != null) {
            if (Thread.currentThread().getId() == this.mUiHandler.getLooper().getThread().getId()) {
                this.unLinkFromStream();
                this.unPrepareView();
            } else {
                final CountDownLatch barrier = new CountDownLatch(1);
                this.mUiHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ThunderPlayerView.this.unLinkFromStream();
                        ThunderPlayerView.this.unPrepareView();
                        barrier.countDown();
                    }
                });
                try {
                    barrier.await();
                }
                catch (InterruptedException e) {
                    ThunderLog.error("ThunderVideoEngineImp", "updatePlayVideoStream .barrier.await" + e.toString());
                }
            }
        }
    }

    public void drawBlackScreen(boolean black) {
        if (this.mYMFPlayerInstance != null) {
            this.mYMFPlayerInstance.setLastFrameRenderBlack(this.mUniformView, black);
        }
    }

    public void updateMultiViewLayout(YMFLayoutParams params) {
        this.mYMFLayoutParams = params;
        if (this.mYMFPlayerInstance != null) {
            this.mYMFPlayerInstance.setViewLayout(this.mUniformView, params);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enterMultiVideoViewMode(YMFLayoutParams multiVideoViewParams, Constant.MultiLianmaiMode lianmaiMode) {
        if (ThunderLog.isInfoValid()) {
            ThunderLog.info(this.TAG, "enterMultiVideoViewMode multiVideoViewParams = [" + multiVideoViewParams + "], lianmaiMode=" + lianmaiMode);
        }
        if (multiVideoViewParams == null) {
            YMFLayoutParams params = new YMFLayoutParams(1);
            YMFVideoPosition videoPosition = new YMFVideoPosition();
            videoPosition.mIndex = 0;
            videoPosition.mX = 0;
            videoPosition.mY = 0;
            videoPosition.mHeight = -2;
            videoPosition.mWidth = -2;
            params.mDrawPosition[0] = videoPosition;
            this.setUseMultiVideoView(params);
            return;
        }
        ThunderPlayerView thunderPlayerView = this;
        synchronized (thunderPlayerView) {
            YYVideoSDK.getInstance().setMultiVideoLianmaiMode(lianmaiMode);
            this.setUseMultiVideoView(multiVideoViewParams);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leaveMultiVideoViewMode() {
        if (ThunderLog.isInfoValid()) {
            ThunderLog.info(this.TAG, "leaveMultiVideoViewMode ");
        }
        ThunderPlayerView thunderPlayerView = this;
        synchronized (thunderPlayerView) {
            this.setUseMultiVideoView(null);
            YYVideoSDK.getInstance().setMultiVideoLianmaiMode(Constant.MultiLianmaiMode.NormalMode);
        }
    }

    private void setUseMultiVideoView(YMFLayoutParams multiVideoViewParams) {
        if (ThunderLog.isInfoValid()) {
            ThunderLog.info(this.TAG, "setUseMultiVideoView");
        }
        this.mYMFLayoutParams = multiVideoViewParams;
        if (this.mYMFPlayerInstance != null) {
            this.mYMFPlayerInstance.setViewLayout(this.mUniformView, this.mYMFLayoutParams);
        }
    }
}

