/*
 * Decompiled with CFR 0.152.
 */
package com.thunder.livesdk.video;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.util.SparseArray;
import com.thunder.livesdk.ThunderMultiVideoViewParam;
import com.thunder.livesdk.log.ThunderLog;
import com.thunder.livesdk.video.ThunderMultiVideoViewCoordinate;
import com.thunder.livesdk.video.ThunderPlayerMultiView;
import com.thunder.livesdk.video.ThunderPlayerView;
import com.thunder.livesdk.video.ThunderVideoPlayEngineImp;
import com.thunder.livesdk.video.VideoPlayerView;
import com.yy.mediaframework.Constant;
import com.yy.videoplayer.videoview.VideoPosition;
import com.yy.videoplayer.view.YMFLayoutParams;
import com.yy.videoplayer.view.YMFVideoPosition;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;

public class ThunderPlayerMultiViewProxy {
    private static final String TAG = "ThunderPlayerView";
    private YMFVideoPosition[] mVideoPositions;
    private YMFVideoPosition mBgVideoPosition;
    private int mVideoCount;
    private Context mContext;
    private ConcurrentHashMap<String, Seat> mStreamKeyToSeatMap;
    private Constant.MultiLianmaiMode lianMaiMode;
    private YMFLayoutParams mYMFLayoutParams;
    private ThunderPlayerView mVideoPlayerUnityView;
    private ThunderPlayerMultiView mVideoPlayerView;
    private Handler mUiHandler = null;
    private ThunderVideoPlayEngineImp engineImp;
    private Object syncLock = new Object();
    private boolean mUseUniformView = false;

    public ThunderPlayerMultiViewProxy(Context context) {
        this.mContext = context;
        this.mUiHandler = new Handler(Looper.getMainLooper());
        this.mStreamKeyToSeatMap = new ConcurrentHashMap();
    }

    public ThunderPlayerMultiViewProxy(Context context, ThunderVideoPlayEngineImp engine) {
        this.mContext = context;
        this.mUiHandler = new Handler(Looper.getMainLooper());
        this.mStreamKeyToSeatMap = new ConcurrentHashMap();
        this.engineImp = engine;
    }

    public void initMultiPlayerViewLayout(ThunderMultiVideoViewParam layoutParam) {
        if (layoutParam == null) {
            return;
        }
        if (layoutParam.mVideoPositions == null && layoutParam.mVideoViewPositions == null) {
            return;
        }
        int videoCount = 0;
        if (layoutParam.mVideoViewPositions != null) {
            int positionSize = layoutParam.mVideoViewPositions.size();
            this.mVideoPositions = new YMFVideoPosition[positionSize];
            for (int i = 0; i < positionSize; ++i) {
                if (layoutParam.mVideoViewPositions.get((int)i).mIndex >= positionSize) continue;
                this.mVideoPositions[layoutParam.mVideoViewPositions.get((int)i).mIndex] = this.convertToVideoPosition(layoutParam.mVideoViewPositions.get(i));
            }
            this.mBgVideoPosition = this.convertToVideoPosition(layoutParam.mBgViewPosition);
        } else if (layoutParam.mVideoPositions != null) {
            this.mVideoPositions = new YMFVideoPosition[layoutParam.mVideoPositions.size()];
            for (int i = 0; i < layoutParam.mVideoPositions.size(); ++i) {
                if (layoutParam.mVideoPositions.get((int)i).mIndex >= layoutParam.mVideoPositions.size()) continue;
                this.mVideoPositions[layoutParam.mVideoPositions.get((int)i).mIndex] = this.convertToVideoPosition(layoutParam.mVideoPositions.get(i));
            }
            this.mBgVideoPosition = this.convertToVideoPosition(layoutParam.mBgPosition);
        }
        videoCount = ThunderPlayerMultiViewProxy.arraySize(this.mVideoPositions);
        this.mYMFLayoutParams = new YMFLayoutParams(videoCount);
        this.mYMFLayoutParams.mDrawPosition = this.mVideoPositions;
        this.mYMFLayoutParams.backgroudPosition = this.mBgVideoPosition;
        this.mYMFLayoutParams.background = layoutParam.mBgBitmap;
        this.lianMaiMode = (Constant.MultiLianmaiMode)new SparseArray<Constant.MultiLianmaiMode>(10){
            {
                this.put(0, Constant.MultiLianmaiMode.NormalMode);
                this.put(1, Constant.MultiLianmaiMode.NormalMode);
                this.put(2, Constant.MultiLianmaiMode.TwoPersonMode);
                this.put(3, Constant.MultiLianmaiMode.ThreePersonMode);
                this.put(4, Constant.MultiLianmaiMode.FourPersonMode);
                this.put(5, Constant.MultiLianmaiMode.FivePersonMode);
                this.put(6, Constant.MultiLianmaiMode.SixPersonMode);
                this.put(7, Constant.MultiLianmaiMode.SevenPersonMode);
                this.put(8, Constant.MultiLianmaiMode.EightPersonMode);
                this.put(9, Constant.MultiLianmaiMode.NinePersonMode);
            }
        }.get(ThunderPlayerMultiViewProxy.arraySize(this.mVideoPositions));
        this.updateLayout(videoCount);
        if (ThunderLog.isInfoValid()) {
            ThunderLog.info(TAG, "initMultiPlayerViewLayout:" + this.mVideoCount);
        }
    }

    private void updateLayout(int videoCount) {
        if (this.mVideoPlayerView != null) {
            if (this.mVideoCount != 0 && this.mVideoCount != videoCount) {
                this.resetAll();
                this.mVideoPlayerView.updateMultiViewLayout(this.mYMFLayoutParams);
                ThunderLog.release(TAG, "need redraw, update MultiPlayerViewLayout:" + this.mVideoCount);
            } else if (this.mVideoCount != 0 && this.mVideoCount == videoCount || this.mVideoCount == 0 && this.mVideoCount < videoCount) {
                this.mVideoPlayerView.updateMultiViewLayout(this.mYMFLayoutParams);
                ThunderLog.release(TAG, "just update MultiPlayerViewLayout:" + this.mVideoCount);
            }
            this.mVideoPlayerView.enterMultiVideoViewMode(this.mYMFLayoutParams, this.lianMaiMode);
        } else if (this.mVideoPlayerUnityView != null) {
            if (this.mVideoCount != 0 && this.mVideoCount != videoCount) {
                this.resetAll();
                this.mVideoPlayerUnityView.updateMultiViewLayout(this.mYMFLayoutParams);
                ThunderLog.release(TAG, "need redraw, update MultiPlayerViewLayout:" + this.mVideoCount);
            } else if (this.mVideoCount != 0 && this.mVideoCount == videoCount || this.mVideoCount == 0 && this.mVideoCount < videoCount) {
                this.mVideoPlayerUnityView.updateMultiViewLayout(this.mYMFLayoutParams);
                ThunderLog.release(TAG, "just update MultiPlayerViewLayout:" + this.mVideoCount);
            }
            this.mVideoPlayerUnityView.enterMultiVideoViewMode(this.mYMFLayoutParams, this.lianMaiMode);
        }
        this.mVideoCount = videoCount;
    }

    private YMFVideoPosition convertToVideoPosition(VideoPosition viewPosition) {
        if (viewPosition == null) {
            return null;
        }
        YMFVideoPosition result = new YMFVideoPosition();
        result.mX = viewPosition.mX;
        result.mY = viewPosition.mY;
        result.mHeight = viewPosition.mHeight;
        result.mWidth = viewPosition.mWidth;
        result.mIndex = viewPosition.mIndex;
        return result;
    }

    private YMFVideoPosition convertToVideoPosition(ThunderMultiVideoViewCoordinate viewPosition) {
        if (viewPosition == null) {
            return null;
        }
        YMFVideoPosition result = new YMFVideoPosition();
        result.mX = viewPosition.mX;
        result.mY = viewPosition.mY;
        result.mHeight = viewPosition.mHeight;
        result.mWidth = viewPosition.mWidth;
        result.mIndex = viewPosition.mIndex;
        return result;
    }

    public VideoPlayerView getPlayerView() {
        return this.mVideoPlayerView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMultiPlayerView(Object view) {
        ThunderLog.release(TAG, "updateMultiPlayerView enter, mVideoPlayerView\uff1a" + (Object)((Object)this.mVideoPlayerView) + " mVideoPlayerUnityView\uff1a" + (Object)((Object)this.mVideoPlayerUnityView) + " view " + view);
        if (view == null) {
            this.unlink();
            Object object = this.syncLock;
            synchronized (object) {
                this.unPrepareView();
                if (this.mUseUniformView) {
                    this.mVideoPlayerUnityView = null;
                } else {
                    this.mVideoPlayerView = null;
                }
            }
        }
        if (view instanceof ThunderPlayerMultiView) {
            this.mUseUniformView = false;
            if (this.mVideoPlayerView == view) {
                if (ThunderLog.isInfoValid()) {
                    ThunderLog.info(TAG, "updateMultiPlayerView already exist");
                }
                return;
            }
            if (this.mVideoPlayerView != null && this.mVideoPlayerView != view) {
                this.unlink();
                this.unPrepareView();
                this.mVideoPlayerView = null;
            }
            this.mVideoPlayerView = (ThunderPlayerMultiView)((Object)view);
            if (this.mVideoPlayerView != null) {
                this.mVideoPlayerView.enterMultiVideoViewMode(this.mYMFLayoutParams, this.lianMaiMode);
            }
        } else if (view instanceof ThunderPlayerView) {
            this.mUseUniformView = true;
            if (this.mVideoPlayerUnityView == view) {
                if (ThunderLog.isInfoValid()) {
                    ThunderLog.info(TAG, "updateMultiPlayerView already exist");
                }
                return;
            }
            if (this.mVideoPlayerUnityView != null && this.mVideoPlayerUnityView != view) {
                this.unlink();
                this.unPrepareView();
                this.mVideoPlayerUnityView = null;
            }
            this.mVideoPlayerUnityView = (ThunderPlayerView)((Object)view);
            if (this.mVideoPlayerUnityView != null) {
                this.mVideoPlayerUnityView.enterMultiVideoViewMode(this.mYMFLayoutParams, this.lianMaiMode);
            }
        }
        ThunderLog.release(TAG, "updateMultiPlayerView exit");
    }

    public void destroyVideoPlayerView() {
        ThunderLog.release(TAG, "destroyVideoPlayerView");
        if (this.mStreamKeyToSeatMap != null) {
            this.unlink();
            this.mStreamKeyToSeatMap.clear();
        }
        if (!this.mUseUniformView) {
            if (this.mVideoPlayerView != null) {
                this.unPrepareView();
                this.mVideoPlayerView.leaveMultiVideoViewMode();
            }
            this.mVideoPlayerView = null;
        } else {
            if (this.mVideoPlayerUnityView != null) {
                this.unPrepareView();
                this.mVideoPlayerUnityView.leaveMultiVideoViewMode();
            }
            this.mVideoPlayerUnityView = null;
        }
        this.mYMFLayoutParams = null;
    }

    public VideoPlayerView getVideoPlayerView() {
        if (!this.mUseUniformView) {
            return this.mVideoPlayerView;
        }
        return this.mVideoPlayerUnityView;
    }

    public int updateSeat(String streamKey, int seatId) {
        if (ThunderLog.isInfoValid()) {
            ThunderLog.info(TAG, "innerUpdateSeat() called with: uid = [" + streamKey + "], seat = [" + seatId + "]");
        }
        if (seatId >= this.mVideoCount || streamKey == null) {
            ThunderLog.error(TAG, "updateSeat:" + seatId + "maxSeats:" + this.mVideoCount + "streamKey:" + streamKey);
            return -1;
        }
        return this.bindSeat(streamKey, seatId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int bindSeat(String streamKey, final int seatId) {
        ThunderLog.release(TAG, "bindSeat called with: uid = [" + streamKey + "], seatNo = [" + seatId + "]");
        ConcurrentHashMap<String, Seat> concurrentHashMap = this.mStreamKeyToSeatMap;
        synchronized (concurrentHashMap) {
            Seat seatItem = this.findSeatByStreamKey(streamKey);
            if (seatId < 0) {
                ThunderLog.error(TAG, "updateSeat invalid, seat " + seatId + " invalid!");
                return -1;
            }
            if (seatItem == null) {
                seatItem = new Seat(){
                    {
                        this.seatIdx = seatId;
                    }
                };
            } else {
                if (seatItem.seatIdx != seatId && seatItem.status == 1) {
                    if (ThunderLog.isInfoValid()) {
                        ThunderLog.info(TAG, "bindSeat updateseat had linked:" + streamKey + ", will unlink!!");
                    }
                    this.unlink(seatItem);
                }
                seatItem.seatIdx = seatId;
                if (this.processBusySeatIfExist(streamKey, seatId) > 0) {
                    ThunderLog.error(TAG, "bindSeat busy!!");
                }
            }
            if (seatItem.seatIdx >= 0 && seatItem.status == 0 && seatItem.streamId != -1L) {
                this.link(seatItem);
            }
            this.mStreamKeyToSeatMap.put(streamKey, seatItem);
            ThunderLog.release(TAG, "bindSeat updateseat streamKey:" + streamKey + ",seat:" + seatId + " >> " + seatItem + "  streamId " + seatItem.streamId);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindStreamToSeat(String streamKey, long streamId) {
        if (streamKey == null) {
            ThunderLog.error(TAG, "bindStreamToSeat streamKey null");
            return;
        }
        if (this.mStreamKeyToSeatMap == null) {
            ThunderLog.error(TAG, "bindStreamToSeat mStreamKeyToSeatMap null");
            return;
        }
        if (streamId == 0L || streamId == -1L) {
            ThunderLog.error(TAG, "bindStreamToSeat streamId," + streamId);
            return;
        }
        ConcurrentHashMap<String, Seat> concurrentHashMap = this.mStreamKeyToSeatMap;
        synchronized (concurrentHashMap) {
            Seat seatItem = this.findSeatByStreamKey(streamKey);
            if (seatItem == null) {
                seatItem = new Seat();
                seatItem.streamId = streamId;
                this.mStreamKeyToSeatMap.put(streamKey, seatItem);
                return;
            }
            if (seatItem != null && seatItem.seatIdx >= 0 && seatItem.status == 1) {
                if (ThunderLog.isInfoValid()) {
                    ThunderLog.info(TAG, "bindStreamToSeat replace and link: seatItem.streamId" + seatItem.streamId + " streamId:" + streamId);
                }
                this.unlink(seatItem);
                seatItem.streamId = streamId;
                this.link(seatItem);
            } else if (seatItem != null && seatItem.status == 0) {
                seatItem.streamId = streamId;
                this.link(seatItem);
                ThunderLog.release(TAG, "bindStreamToSeat update: seatItem.streamId:" + streamId + " seatId:" + seatItem.seatIdx);
            }
        }
    }

    private int processBusySeatIfExist(String streamKey, int seatId) {
        if (seatId >= 0) {
            Seat curSeat = this.findSeatByStreamKey(streamKey);
            ArrayList<Seat> seatItemList = this.findSeatBySeatId(seatId);
            if (seatItemList != null && seatItemList.size() > 0) {
                for (Seat seatItem : seatItemList) {
                    if (seatItem == null || seatItem == curSeat || seatItem.streamId == 0L || curSeat.streamId == 0L || seatItem.streamId >> 32 == curSeat.streamId >> 32) continue;
                    ThunderLog.error(TAG, "processBusySeat, streamKey" + streamKey + " seat " + seatId + " busy!");
                    this.unlink(seatItem);
                    seatItem.seatIdx = -1;
                    if (this.engineImp != null) {
                        this.engineImp.onMultiViewSeatInfoChangedNotify(seatItem.streamId, seatItem.seatIdx);
                    }
                    return 1;
                }
            }
        }
        return 0;
    }

    public Seat findSeatByStreamKey(String streamKey) {
        if (this.mStreamKeyToSeatMap == null) {
            ThunderLog.error(TAG, "mStreamKeyToSeatMap null");
            return null;
        }
        Seat seatItem = this.mStreamKeyToSeatMap.get(streamKey);
        if (ThunderLog.isInfoValid()) {
            ThunderLog.info(TAG, "findSeatByStreamKey:" + streamKey + ",caches:" + this.mStreamKeyToSeatMap);
        }
        return seatItem;
    }

    public Seat removeSeatByStreamKey(String streamKey) {
        return this.mStreamKeyToSeatMap.remove(streamKey);
    }

    public ArrayList<Seat> findSeatBySeatId(int seatIdx) {
        ArrayList<Seat> seatArrayList = new ArrayList<Seat>(0);
        if (this.mStreamKeyToSeatMap != null && seatIdx >= 0) {
            for (Map.Entry<String, Seat> entry : this.mStreamKeyToSeatMap.entrySet()) {
                Seat seatItem = entry.getValue();
                if (seatItem.seatIdx != seatIdx) continue;
                seatArrayList.add(seatItem);
            }
        }
        return seatArrayList;
    }

    public ArrayList<String> findStreamKeyBySeatId(int seatIdx) {
        ArrayList<String> streamKeyList = new ArrayList<String>(0);
        if (this.mStreamKeyToSeatMap != null && seatIdx >= 0) {
            for (Map.Entry<String, Seat> entry : this.mStreamKeyToSeatMap.entrySet()) {
                Seat seatItem = entry.getValue();
                if (seatItem.seatIdx != seatIdx) continue;
                streamKeyList.add(entry.getKey());
            }
        }
        return streamKeyList;
    }

    public Seat findSeatByStreamId(long streamId) {
        if (this.mStreamKeyToSeatMap != null) {
            for (Map.Entry<String, Seat> entry : this.mStreamKeyToSeatMap.entrySet()) {
                Seat seatItem = entry.getValue();
                if (seatItem.streamId != streamId) continue;
                return seatItem;
            }
        }
        return null;
    }

    private int link(Seat seatItem) {
        int result = -1;
        if (seatItem != null) {
            if (!this.mUseUniformView) {
                if (this.mVideoPlayerView != null && seatItem.seatIdx >= 0 && seatItem.streamId != 0L && seatItem.status == 0) {
                    result = this.mVideoPlayerView.linkToStream(seatItem.streamId, seatItem.seatIdx);
                }
            } else if (this.mVideoPlayerUnityView != null && seatItem.seatIdx >= 0 && seatItem.streamId != 0L && seatItem.status == 0) {
                result = this.mVideoPlayerUnityView.linkToStream(seatItem.streamId, seatItem.seatIdx);
            }
            if (result >= 0) {
                seatItem.status = 1;
            }
            ThunderLog.release(TAG, "link- Seat:" + seatItem + ",ret:" + result);
        } else {
            ThunderLog.error(TAG, "link- Seat:" + seatItem + ",ret:" + result);
        }
        return result;
    }

    private int unlink(Seat seatItem) {
        int result = -1;
        if (seatItem != null) {
            if (!this.mUseUniformView) {
                if (this.mVideoPlayerView != null && seatItem.seatIdx >= 0 && seatItem.streamId != 0L && seatItem.status == 1) {
                    result = this.mVideoPlayerView.unLinkFromStream(seatItem.streamId, seatItem.seatIdx);
                }
            } else if (this.mVideoPlayerUnityView != null && seatItem.seatIdx >= 0 && seatItem.streamId != 0L && seatItem.status == 1) {
                result = this.mVideoPlayerUnityView.unLinkFromStream(seatItem.streamId, seatItem.seatIdx);
            }
            if (result >= 0) {
                seatItem.status = 0;
            }
            ThunderLog.release(TAG, "unlink- Seat:" + seatItem + ",ret:" + result);
        }
        return result;
    }

    public int link(String streamKey) {
        Seat seatItem = this.findSeatByStreamKey(streamKey);
        return this.link(seatItem);
    }

    public int unlink(String streamKey) {
        Seat seatItem = this.findSeatByStreamKey(streamKey);
        return this.unlink(seatItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSeatByStreamKey(String streamKey) {
        ConcurrentHashMap<String, Seat> concurrentHashMap = this.mStreamKeyToSeatMap;
        synchronized (concurrentHashMap) {
            this.mStreamKeyToSeatMap.remove(streamKey);
            if (ThunderLog.isInfoValid()) {
                ThunderLog.info(TAG, "releaseSeatByStreamKey- Seat:" + streamKey);
            }
        }
    }

    public int unlink() {
        if (this.mStreamKeyToSeatMap != null) {
            for (Map.Entry<String, Seat> entry : this.mStreamKeyToSeatMap.entrySet()) {
                Seat seatItem = entry.getValue();
                if (seatItem == null) continue;
                this.unlink(seatItem);
            }
        }
        return 0;
    }

    public int link() {
        if (this.mStreamKeyToSeatMap != null) {
            for (Map.Entry<String, Seat> entry : this.mStreamKeyToSeatMap.entrySet()) {
                Seat seatItem = entry.getValue();
                if (seatItem == null) continue;
                this.link(seatItem);
            }
        }
        return 0;
    }

    public void resetAll() {
        if (this.mStreamKeyToSeatMap != null) {
            this.unlinkAndReset();
            ThunderLog.release(TAG, "resetAll");
        }
    }

    public int unlinkAndReset() {
        if (this.mStreamKeyToSeatMap != null) {
            for (Map.Entry<String, Seat> entry : this.mStreamKeyToSeatMap.entrySet()) {
                Seat seatItem = entry.getValue();
                if (seatItem == null) continue;
                this.unlink(seatItem);
                seatItem.seatIdx = -1;
                if (this.engineImp == null) continue;
                this.engineImp.onMultiViewSeatInfoChangedNotify(seatItem.streamId, seatItem.seatIdx);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareView() {
        if (!this.mUseUniformView) {
            if (this.mVideoPlayerView == null) {
                return;
            }
            if (Thread.currentThread().getId() == this.mUiHandler.getLooper().getThread().getId()) {
                Object object = this.syncLock;
                synchronized (object) {
                    if (this.mVideoPlayerView != null) {
                        this.mVideoPlayerView.prepareView();
                    }
                }
            } else {
                final CountDownLatch barrier = new CountDownLatch(1);
                this.mUiHandler.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = ThunderPlayerMultiViewProxy.this.syncLock;
                        synchronized (object) {
                            if (ThunderPlayerMultiViewProxy.this.mVideoPlayerView != null) {
                                ThunderPlayerMultiViewProxy.this.mVideoPlayerView.prepareView();
                            }
                        }
                        barrier.countDown();
                    }
                });
                try {
                    barrier.await();
                }
                catch (InterruptedException e) {
                    ThunderLog.error("ThunderVideoEngineImp", "updatePlayVideoStream .barrier.await" + e.toString());
                }
            }
        } else {
            if (this.mVideoPlayerUnityView == null) {
                return;
            }
            if (Thread.currentThread().getId() == this.mUiHandler.getLooper().getThread().getId()) {
                Object barrier = this.syncLock;
                synchronized (barrier) {
                    if (this.mVideoPlayerUnityView != null) {
                        this.mVideoPlayerUnityView.prepareView();
                    }
                }
            }
            final CountDownLatch barrier = new CountDownLatch(1);
            this.mUiHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = ThunderPlayerMultiViewProxy.this.syncLock;
                    synchronized (object) {
                        if (ThunderPlayerMultiViewProxy.this.mVideoPlayerUnityView != null) {
                            ThunderPlayerMultiViewProxy.this.mVideoPlayerUnityView.prepareView();
                        }
                    }
                    barrier.countDown();
                }
            });
            try {
                barrier.await();
            }
            catch (InterruptedException e) {
                ThunderLog.error("ThunderVideoEngineImp", "updatePlayVideoStream .barrier.await" + e.toString());
            }
        }
    }

    public void unPrepareView() {
        if (!this.mUseUniformView) {
            if (this.mVideoPlayerView == null) {
                return;
            }
            if (Thread.currentThread().getId() == this.mUiHandler.getLooper().getThread().getId()) {
                if (this.mVideoPlayerView != null) {
                    this.mVideoPlayerView.unPrepareView();
                }
            } else {
                final CountDownLatch barrier = new CountDownLatch(1);
                this.mUiHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (ThunderPlayerMultiViewProxy.this.mVideoPlayerView != null) {
                            ThunderPlayerMultiViewProxy.this.mVideoPlayerView.unPrepareView();
                        }
                        barrier.countDown();
                    }
                });
                try {
                    barrier.await();
                }
                catch (InterruptedException e) {
                    ThunderLog.error("ThunderVideoEngineImp", "updatePlayVideoStream .barrier.await" + e.toString());
                }
            }
        } else {
            if (this.mVideoPlayerUnityView == null) {
                return;
            }
            if (Thread.currentThread().getId() == this.mUiHandler.getLooper().getThread().getId()) {
                if (this.mVideoPlayerUnityView != null) {
                    this.mVideoPlayerUnityView.unPrepareView();
                }
            } else {
                final CountDownLatch barrier = new CountDownLatch(1);
                this.mUiHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (ThunderPlayerMultiViewProxy.this.mVideoPlayerUnityView != null) {
                            ThunderPlayerMultiViewProxy.this.mVideoPlayerUnityView.unPrepareView();
                        }
                        barrier.countDown();
                    }
                });
                try {
                    barrier.await();
                }
                catch (InterruptedException e) {
                    ThunderLog.error("ThunderVideoEngineImp", "updatePlayVideoStream .barrier.await" + e.toString());
                }
            }
        }
    }

    public boolean setScaleMode(int scaleMode) {
        boolean result;
        block5: {
            block4: {
                if (ThunderLog.isInfoValid()) {
                    ThunderLog.info(TAG, "setScaleMode:" + scaleMode);
                }
                result = true;
                if (this.mUseUniformView) break block4;
                if (this.mStreamKeyToSeatMap == null || this.mVideoPlayerView == null) break block5;
                for (Map.Entry<String, Seat> entry : this.mStreamKeyToSeatMap.entrySet()) {
                    Seat seatItem = entry.getValue();
                    if (seatItem == null || seatItem.seatIdx < 0) continue;
                    result &= this.mVideoPlayerView.setScaleMode(seatItem.seatIdx, scaleMode);
                }
                break block5;
            }
            if (this.mStreamKeyToSeatMap != null && this.mVideoPlayerUnityView != null) {
                for (Map.Entry<String, Seat> entry : this.mStreamKeyToSeatMap.entrySet()) {
                    Seat seatItem = entry.getValue();
                    if (seatItem == null || seatItem.seatIdx < 0) continue;
                    result &= this.mVideoPlayerUnityView.setScaleMode(seatItem.seatIdx, scaleMode);
                }
            }
        }
        return result;
    }

    public boolean setScaleMode(String streamKey, int scaleMode) {
        Seat seat;
        if (ThunderLog.isInfoValid()) {
            ThunderLog.info(TAG, "setScaleMode: " + streamKey + " " + scaleMode);
        }
        boolean result = true;
        if (!this.mUseUniformView) {
            Seat seat2;
            if (this.mStreamKeyToSeatMap != null && this.mVideoPlayerView != null && scaleMode >= 0 && (seat2 = this.findSeatByStreamKey(streamKey)) != null) {
                result = this.mVideoPlayerView.setScaleMode(seat2.seatIdx, scaleMode);
            }
        } else if (this.mStreamKeyToSeatMap != null && this.mVideoPlayerUnityView != null && scaleMode >= 0 && (seat = this.findSeatByStreamKey(streamKey)) != null) {
            result = this.mVideoPlayerUnityView.setScaleMode(seat.seatIdx, scaleMode);
        }
        return result;
    }

    public void setMirrorMode(String streamKey, int mirrorMode) {
        Seat seat;
        if (ThunderLog.isInfoValid()) {
            ThunderLog.info(TAG, "setMirrorMode: " + streamKey + " " + mirrorMode);
        }
        if (!this.mUseUniformView) {
            Seat seat2;
            if (this.mStreamKeyToSeatMap != null && this.mVideoPlayerView != null && (seat2 = this.findSeatByStreamKey(streamKey)) != null) {
                this.mVideoPlayerView.setMirrorMode(seat2.seatIdx, mirrorMode);
            }
        } else if (this.mStreamKeyToSeatMap != null && this.mVideoPlayerUnityView != null && (seat = this.findSeatByStreamKey(streamKey)) != null) {
            this.mVideoPlayerUnityView.setMirrorMode(seat.seatIdx, mirrorMode);
        }
    }

    public Bitmap getVideoScreenshot(String streamKey) {
        Seat seat;
        if (ThunderLog.isInfoValid()) {
            ThunderLog.info(TAG, "getVideoScreenshot: " + streamKey);
        }
        if (!this.mUseUniformView) {
            Seat seat2;
            if (this.mStreamKeyToSeatMap != null && this.mVideoPlayerView != null && (seat2 = this.findSeatByStreamKey(streamKey)) != null) {
                return this.mVideoPlayerView.getVideoScreenshot(seat2.seatIdx);
            }
        } else if (this.mStreamKeyToSeatMap != null && this.mVideoPlayerUnityView != null && (seat = this.findSeatByStreamKey(streamKey)) != null) {
            return this.mVideoPlayerUnityView.getVideoScreenshot(seat.seatIdx);
        }
        return null;
    }

    public static <T> int arraySize(T[] xs) {
        return xs == null ? 0 : xs.length;
    }

    public static class Seat {
        private static final int STATUS_IDEL = 0;
        private static final int STATUS_LINK = 1;
        public int seatIdx = -1;
        public long streamId = 0L;
        public int status = 0;

        public String toString() {
            return "Seat{, seatIdx=" + this.seatIdx + ", status=" + this.status + '}';
        }
    }
}

