/*
 * Decompiled with CFR 0.152.
 */
package com.thunder.livesdk.video;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.AttributeSet;
import android.view.SurfaceView;
import android.view.View;
import com.thunder.livesdk.log.ThunderLog;
import com.thunder.livesdk.video.VideoPlayerView;
import com.yy.mediaframework.Constant;
import com.yy.mediaframework.YYVideoSDK;
import com.yy.videoplayer.YMFPlayerAPI;
import com.yy.videoplayer.decoder.VideoConstant;
import com.yy.videoplayer.view.YMFLayoutParams;
import com.yy.videoplayer.view.YMFVideoPosition;

public class ThunderPlayerMultiView
extends VideoPlayerView {
    private static final String TAG = "ThunderPlayerMultiView";
    private YMFLayoutParams mYMFLayoutParams = null;
    private YMFPlayerAPI mYMFPlayerInstance = null;

    public ThunderPlayerMultiView(Context context) {
        super(context);
        this.addView((View)new SurfaceView(context));
        this.init();
    }

    public ThunderPlayerMultiView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.addView((View)new SurfaceView(context));
        this.init();
    }

    public ThunderPlayerMultiView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.addView((View)new SurfaceView(context));
        this.init();
    }

    private void init() {
        this.mYMFLayoutParams = new YMFLayoutParams(1);
        YMFVideoPosition videoPosition = new YMFVideoPosition();
        videoPosition.mIndex = 0;
        videoPosition.mX = 0;
        videoPosition.mY = 0;
        videoPosition.mHeight = -2;
        videoPosition.mWidth = -2;
        this.mYMFLayoutParams.mDrawPosition[0] = videoPosition;
    }

    private boolean createUnityVideoView() {
        if (this.mYMFPlayerInstance == null) {
            this.mYMFPlayerInstance = YMFPlayerAPI.newInstance();
        }
        this.mUniformView = this.mYMFPlayerInstance.createView(this.getContext());
        if (this.mUniformView != null) {
            this.addView(this.mUniformView);
            this.mYMFPlayerInstance.setViewLayout(this.mUniformView, this.mYMFLayoutParams);
            this.mYMFPlayerInstance.setScaleMode(this.mUniformView, this.mScaleMode, -1);
            this.mViewType = VideoConstant.ViewType.GL_VIDEO_VIEW;
            this.mPrepared = true;
        }
        ThunderLog.release("yvideo-Java", "createUnityVideoView:" + this.mViewType.name() + " size " + this.getWidth() + "x" + this.getHeight());
        return true;
    }

    @Override
    public boolean prepareView() {
        this.unPrepareView();
        return this.createUnityVideoView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unPrepareView() {
        ThunderPlayerMultiView thunderPlayerMultiView = this;
        synchronized (thunderPlayerMultiView) {
            this.removeAllViews();
            if (this.mYMFPlayerInstance != null) {
                this.mYMFPlayerInstance.destroyView(this.mUniformView);
                this.mUniformView = null;
                this.mPrepared = false;
            }
        }
        ThunderLog.release("yvideo-Java", "unPrepareView.");
    }

    public int linkToStream(long streamId, int videoIndex) {
        if (streamId == 0L) {
            return -1;
        }
        if (videoIndex < 0) {
            return -1;
        }
        if (this.mUniformView == null) {
            return -1;
        }
        if (this.mYMFPlayerInstance != null && this.mUniformView != null) {
            return this.mYMFPlayerInstance.linkStream(this.mUniformView, streamId, videoIndex);
        }
        return 0;
    }

    public int unLinkFromStream(long streamId, int videoIndex) {
        if (streamId == 0L) {
            return -1;
        }
        if (videoIndex < 0) {
            return -1;
        }
        if (this.mUniformView == null) {
            return -1;
        }
        if (this.mYMFPlayerInstance != null) {
            return this.mYMFPlayerInstance.unLinkStream(this.mUniformView, streamId, videoIndex);
        }
        return 0;
    }

    private void setUseMultiVideoView(YMFLayoutParams multiVideoViewParams) {
        if (ThunderLog.isInfoValid()) {
            ThunderLog.info(TAG, "setUseMultiVideoView");
        }
        this.mYMFLayoutParams = multiVideoViewParams;
        if (this.mYMFPlayerInstance != null) {
            this.mYMFPlayerInstance.setViewLayout(this.mUniformView, this.mYMFLayoutParams);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enterMultiVideoViewMode(YMFLayoutParams multiVideoViewParams, Constant.MultiLianmaiMode lianmaiMode) {
        if (ThunderLog.isInfoValid()) {
            ThunderLog.info(TAG, "enterMultiVideoViewMode multiVideoViewParams = [" + multiVideoViewParams + "], lianmaiMode=" + lianmaiMode);
        }
        if (multiVideoViewParams == null) {
            multiVideoViewParams = new YMFLayoutParams(1);
            YMFVideoPosition videoPosition = new YMFVideoPosition();
            videoPosition.mIndex = 0;
            videoPosition.mX = 0;
            videoPosition.mY = 0;
            videoPosition.mHeight = -2;
            videoPosition.mWidth = -2;
            multiVideoViewParams.mDrawPosition[0] = videoPosition;
            this.setUseMultiVideoView(multiVideoViewParams);
            return;
        }
        ThunderPlayerMultiView thunderPlayerMultiView = this;
        synchronized (thunderPlayerMultiView) {
            YYVideoSDK.getInstance().setMultiVideoLianmaiMode(lianmaiMode);
            this.setUseMultiVideoView(multiVideoViewParams);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leaveMultiVideoViewMode() {
        if (ThunderLog.isInfoValid()) {
            ThunderLog.info(TAG, "leaveMultiVideoViewMode ");
        }
        ThunderPlayerMultiView thunderPlayerMultiView = this;
        synchronized (thunderPlayerMultiView) {
            this.setUseMultiVideoView(null);
            YYVideoSDK.getInstance().setMultiVideoLianmaiMode(Constant.MultiLianmaiMode.NormalMode);
        }
    }

    public boolean setScaleMode(int seatId, int scaleMode) {
        boolean result = false;
        this.mScaleMode = this.scaleModeConvert(scaleMode);
        if (this.mYMFPlayerInstance != null) {
            this.mYMFPlayerInstance.setScaleMode(this.mUniformView, this.mScaleMode, seatId);
        }
        return result;
    }

    public void setMirrorMode(int seatId, int mirrorMode) {
        this.mMirrorMode = this.mirrorModeConvert(mirrorMode);
        if (this.mYMFPlayerInstance != null) {
            this.mYMFPlayerInstance.setMirrorMode(this.mUniformView, this.mMirrorMode, seatId);
        }
    }

    public Bitmap getVideoScreenshot(int seatId) {
        if (this.mYMFPlayerInstance != null) {
            return this.mYMFPlayerInstance.getVideoScreenshot(this.mUniformView, seatId);
        }
        return null;
    }

    public void updateMultiViewLayout(YMFLayoutParams params) {
        this.mYMFLayoutParams = params;
        if (this.mYMFPlayerInstance != null && this.mUniformView != null) {
            this.mYMFPlayerInstance.setViewLayout(this.mUniformView, params);
        }
    }
}

