/*
 * Decompiled with CFR 0.152.
 */
package com.thunder.livesdk;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.thunder.livesdk.ExternalVideoSource;
import com.thunder.livesdk.IThunderLogCallback;
import com.thunder.livesdk.IThunderMediaExtraInfoCallback;
import com.thunder.livesdk.LiveTranscoding;
import com.thunder.livesdk.ScreenRecordSource;
import com.thunder.livesdk.ThunderAudioFilePlayer;
import com.thunder.livesdk.ThunderBoltImage;
import com.thunder.livesdk.ThunderBridgeLib;
import com.thunder.livesdk.ThunderCustomVideoSource;
import com.thunder.livesdk.ThunderDefaultCamera;
import com.thunder.livesdk.ThunderDeviceInfo;
import com.thunder.livesdk.ThunderEngineConfig;
import com.thunder.livesdk.ThunderEventHandler;
import com.thunder.livesdk.ThunderExternalVideoSource;
import com.thunder.livesdk.ThunderMultiVideoViewParam;
import com.thunder.livesdk.ThunderNotification;
import com.thunder.livesdk.ThunderPreviewConfig;
import com.thunder.livesdk.ThunderPublishVideoConfig;
import com.thunder.livesdk.ThunderPublisher;
import com.thunder.livesdk.ThunderRtcConstant;
import com.thunder.livesdk.ThunderVideoCanvas;
import com.thunder.livesdk.ThunderVideoEncodeParam;
import com.thunder.livesdk.ThunderVideoEncoderConfiguration;
import com.thunder.livesdk.audio.IAudioFrameObserver;
import com.thunder.livesdk.helper.ThunderHttpsRequestHandler;
import com.thunder.livesdk.helper.ThunderNative;
import com.thunder.livesdk.log.ThunderLog;
import com.thunder.livesdk.system.ThunderForeBackgroundListener;
import com.thunder.livesdk.system.ThunderNetStateService;
import com.thunder.livesdk.video.IVideoCaptureObserver;
import com.thunder.livesdk.video.IVideoDecodeObserver;
import com.thunder.livesdk.video.ThunderPublishLowStreamVideoConfig;
import com.thunder.livesdk.video.ThunderVideoLogCallback;
import com.thunder.livesdk.video.VideoFrameYuvCapture;
import com.yy.mediaframework.VideoLibAPI;
import com.yy.mediaframework.gpuimage.custom.IGPUProcess;
import com.yy.mediaframework.model.Rect;
import com.yy.videoplayer.decoder.YYVideoLibMgr;
import com.yy.videoplayer.utils.YMFLog;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import org.json.JSONArray;
import org.json.JSONObject;

public class ThunderEngine {
    private static boolean mIsInited = false;
    private static NotificationHandler mHandler = null;
    private static ThunderNetStateService mNetStateService = null;
    private static ThunderForeBackgroundListener mForeBackgroundListener = null;
    private static ThunderNative.NotificationDispatcher mNotificationDispatcher = null;
    private static ThunderEventHandler mRtcEventHandler;
    private static ThunderHttpsRequestHandler mHttpsRequestHandler;
    private static IThunderMediaExtraInfoCallback mThunderMediaExtraInfoCallback;
    private static int s_captureVolumeNotifyCount;
    private static int s_playVolumeNotifyCount;
    private static int s_playDataNotifyCount;
    private static int s_audioPlaySpectrumCount;
    private Set<ThunderAudioFilePlayer> mAudioFilePlayerSet = new TreeSet<ThunderAudioFilePlayer>();
    private static ThunderPublisher mPublisher;
    private ExternalVideoSource mExternalVideoSource = null;

    private ThunderEngine() {
        mPublisher = new ThunderPublisher();
    }

    private static synchronized ThunderEngine createRtcEngine(Context context, String appId, long sceneId, int areaType, int serverDomain, ThunderEventHandler handler, Looper loop) {
        long tempAppId = 0L;
        try {
            tempAppId = Long.parseLong(appId);
        }
        catch (NumberFormatException e) {
            Log.e((String)"yrtc", (String)"init failed, appid is not number");
            return null;
        }
        if (SingleonHolder.INSTANCE == null) {
            SingleonHolder.INSTANCE = new ThunderEngine();
        }
        if (mHandler == null) {
            mHandler = loop != null ? new NotificationHandler(SingleonHolder.INSTANCE, loop) : new NotificationHandler(SingleonHolder.INSTANCE);
        }
        if (!mIsInited) {
            mRtcEventHandler = handler;
            mHttpsRequestHandler = new ThunderHttpsRequestHandler();
            YMFLog.registerLogger((Object)ThunderVideoLogCallback.sharedInstance());
            if (mNetStateService != null) {
                mNetStateService.fini();
            }
            if (mForeBackgroundListener != null) {
                mForeBackgroundListener.fini();
            }
            mNotificationDispatcher = new ThunderNative.NotificationDispatcher(){
                private final HashSet<Handler> mNotificationHandlers = new HashSet();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void registerNotificationHandler(Handler handler) {
                    HashSet<Handler> hashSet = this.mNotificationHandlers;
                    synchronized (hashSet) {
                        this.mNotificationHandlers.add(handler);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void unregisterNotificationHandler(Handler handler) {
                    HashSet<Handler> hashSet = this.mNotificationHandlers;
                    synchronized (hashSet) {
                        this.mNotificationHandlers.remove(handler);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object[] collectNotificationHandlers() {
                    Object[] handlers = null;
                    HashSet<Handler> hashSet = this.mNotificationHandlers;
                    synchronized (hashSet) {
                        if (this.mNotificationHandlers.size() > 0) {
                            handlers = this.mNotificationHandlers.toArray();
                        }
                    }
                    return handlers;
                }
            };
            mNotificationDispatcher.registerNotificationHandler(mHandler);
            ThunderDeviceInfo info = new ThunderDeviceInfo(context);
            YYVideoLibMgr.instance().init(context, "1.0", "Thunder", Build.VERSION.RELEASE, Build.MODEL, null);
            VideoLibAPI.instance().initVideoLib(tempAppId, sceneId, context);
            int ret = ThunderNative.init(tempAppId, sceneId, areaType, serverDomain, context, info, mNotificationDispatcher);
            if (ret < 0) {
                ThunderLog.error("yrtc", "init failed");
                return null;
            }
            mNetStateService = new ThunderNetStateService(context);
            mNetStateService.init();
            mForeBackgroundListener = new ThunderForeBackgroundListener(context);
            mForeBackgroundListener.init();
            mIsInited = true;
        }
        return SingleonHolder.INSTANCE;
    }

    public static synchronized ThunderEngine createEngine(Context context, String appId, long sceneId, ThunderEventHandler handler) {
        ThunderEngine rtcEngine = ThunderEngine.createRtcEngine(context, appId, sceneId, -1, -1, handler, null);
        return rtcEngine;
    }

    public static synchronized ThunderEngine createEngine(ThunderEngineConfig config) {
        ThunderEngine rtcEngine = ThunderEngine.createRtcEngine(config.context, config.appId, config.sceneId, config.areaType, config.serverDomain, config.handler, null);
        return rtcEngine;
    }

    public static synchronized ThunderEngine createWithLoop(Context context, String appId, long sceneId, ThunderEventHandler handler, Looper loop) {
        ThunderEngine rtcEngine = ThunderEngine.createRtcEngine(context, appId, sceneId, -1, -1, handler, loop);
        return rtcEngine;
    }

    public static synchronized ThunderEngine createWithLoop(ThunderEngineConfig config, Looper loop) {
        ThunderEngine rtcEngine = ThunderEngine.createRtcEngine(config.context, config.appId, config.sceneId, config.areaType, config.serverDomain, config.handler, loop);
        return rtcEngine;
    }

    public static synchronized void destroyEngine() {
        if (mIsInited) {
            SingleonHolder.INSTANCE.setVideoWatermark(null);
            SingleonHolder.INSTANCE.setLocalVideoMirrorMode(0);
            SingleonHolder.INSTANCE.cleanAllAudioFilePlayer();
            ThunderNative.fini();
            YYVideoLibMgr.instance().deInit("Thunder");
            mIsInited = false;
            SingleonHolder.INSTANCE.resetRtcEngine();
            SingleonHolder.INSTANCE = null;
        }
    }

    public static String getVersion() {
        return ThunderNative.getVersion();
    }

    public static int setLogFilePath(String filePath) {
        return ThunderNative.setLogFilePath(filePath);
    }

    public static int setLogCallback(IThunderLogCallback callback) {
        return ThunderNative.setLogCallback(callback);
    }

    public static int setLogLevel(int filter) {
        ThunderLog.setLogLevel(filter);
        return ThunderNative.setLogLevel(filter);
    }

    public int setParameters(String options) {
        ThunderLog.release("yrtc", "setParameters options:%s", options);
        int ret = -13;
        boolean bSucc = true;
        try {
            boolean bSubGroup;
            JSONArray jsonArray;
            int subscribeGroupAppid;
            int pubAppid;
            JSONObject obj = new JSONObject(options);
            if (obj.has("enableVideoPublishBufferProcess")) {
                boolean bBufferMode = obj.getBoolean("enableVideoPublishBufferProcess");
                ret = ThunderNative.enableVideoPublishBufferProcess(bBufferMode);
                ThunderLog.release("yrtc", String.format("[tbg] setParameters enableVideoPublishBufferProcess=%b, ret=%d", bBufferMode, ret));
                if (ret != 0) {
                    return ret;
                }
            }
            if (obj.has("enableHardwareDecode")) {
                int mHardwareDecodeStatus = obj.getInt("enableHardwareDecode");
                if (mHardwareDecodeStatus == 1 && Build.VERSION.SDK_INT < 17) {
                    mHardwareDecodeStatus = 0;
                }
                ret = ThunderNative.setHardwareDecodeStatus(mHardwareDecodeStatus);
                ThunderLog.release("yrtc", String.format("[tbg] setParameters mHardwareDecodeStatus=%d, ret=%d", mHardwareDecodeStatus, ret));
                if (ret != 0) {
                    return ret;
                }
            }
            if (obj.has("CustomPublishAppid") && (ret = ThunderNative.setCustomPublishAppid(pubAppid = obj.getInt("CustomPublishAppid"))) != 0) {
                return ret;
            }
            if (obj.has("CustomSubscribeGroupAppid") && (ret = ThunderNative.setCustomSubscribeGroupAppid(subscribeGroupAppid = obj.getInt("CustomSubscribeGroupAppid"))) != 0) {
                return ret;
            }
            if (obj.has("CustomStreamName") && (jsonArray = obj.getJSONArray("CustomStreamName")) != null && jsonArray.length() > 0) {
                for (int i = 0; i < jsonArray.length(); ++i) {
                    String streamName;
                    int streamType;
                    JSONObject streamItem = jsonArray.getJSONObject(i);
                    if (!streamItem.has("streamType") || !streamItem.has("streamName") || (ret = ThunderNative.setCustomStreamName(streamType = streamItem.getInt("streamType"), streamName = streamItem.getString("streamName"))) == 0) continue;
                    return ret;
                }
            }
            if (obj.has("SubscribeGroupInThunder") && (ret = ThunderNative.setSubscribeGroupInThunder(bSubGroup = obj.getBoolean("SubscribeGroupInThunder"))) != 0) {
                return ret;
            }
            if (obj.has("JoinWithSubscribeGroup")) {
                boolean tbSubscribeGroup = obj.getBoolean("JoinWithSubscribeGroup");
                ret = ThunderNative.setThunderboltSubscribeGroup(tbSubscribeGroup);
                ThunderLog.release("yrtc", String.format("[tbg] setParameters JoinWithSubscribeGroup=%b, ret=%d", tbSubscribeGroup, ret));
                if (ret != 0) {
                    return ret;
                }
            }
            if (obj.has("PublishAudioToGroup")) {
                boolean tbPublishGroup = obj.getBoolean("PublishAudioToGroup");
                ret = ThunderNative.setThunderboltPublishGroup(tbPublishGroup);
                ThunderLog.release("yrtc", String.format("[tbg] setParameters PublishAudioToGroup=%b, ret = %d", tbPublishGroup, ret));
                if (ret != 0) {
                    return ret;
                }
            }
            if (obj.has("setSid") && obj.has("setSubsid")) {
                int sid = obj.getInt("setSid");
                int subsid = obj.getInt("setSubsid");
                ret = ThunderNative.setSidAndSubsid(sid, subsid);
                ThunderLog.release("yrtc", String.format("[tbg] setParameters setSidAndSubsid sid %d, subSid %d, ret %d", sid, subsid, ret));
                if (ret != 0) {
                    return ret;
                }
            }
            if (obj.has("CacheRooms")) {
                String value = obj.getString("CacheRooms");
                JSONObject uid_rooms = new JSONObject(value);
                String uid = uid_rooms.getString("uid");
                JSONArray rooms = uid_rooms.getJSONArray("rooms");
                LinkedList<String> roomIds = new LinkedList<String>();
                if (rooms != null) {
                    for (int i = 0; i < rooms.length(); ++i) {
                        String room = (String)rooms.get(i);
                        roomIds.add(room);
                    }
                    ret = ThunderNative.prefetchStreams(uid, roomIds);
                    ThunderLog.release("yrtc", "setParameters CacheRooms:%s ret:%d", rooms.toString(), ret);
                }
                if (ret != 0) {
                    return ret;
                }
            }
            if (obj.has("QueryStreams")) {
                LinkedList<String> rooms;
                JSONArray roomsArray = obj.getJSONArray("QueryStreams");
                if (roomsArray != null && roomsArray.length() > 0 && (rooms = new LinkedList<String>()) != null) {
                    for (int i = 0; i < roomsArray.length(); ++i) {
                        String room = (String)roomsArray.get(i);
                        rooms.add(room);
                    }
                    ret = ThunderNative.queryStreams(rooms);
                    ThunderLog.release("yrtc", "setParameters queryStreams:%s ret:%d", rooms.toString(), ret);
                }
                if (ret != 0) {
                    return ret;
                }
            }
            if (obj.has("VideoPublisherConfig")) {
                JSONArray publishCfgArray = obj.getJSONArray("VideoPublisherConfig");
                if (publishCfgArray != null && publishCfgArray.length() > 0) {
                    for (int i = 0; i < publishCfgArray.length(); ++i) {
                        JSONObject publishCfgItem = publishCfgArray.getJSONObject(i);
                        if (!publishCfgItem.has("playType") || !publishCfgItem.has("configList")) continue;
                        int playType = publishCfgItem.getInt("playType");
                        if (playType < 0 || playType > 3) {
                            bSucc = false;
                            ThunderLog.error("yrtc", "setParameters VideoPublisherConfig playType:%d invalid", playType);
                            continue;
                        }
                        JSONArray vcfgArray = publishCfgItem.getJSONArray("configList");
                        if (null == vcfgArray || 0 == vcfgArray.length()) continue;
                        for (int idx = 0; idx < vcfgArray.length(); ++idx) {
                            JSONArray vLowCfgArry;
                            JSONObject vcfgItem = vcfgArray.getJSONObject(idx);
                            if (!vcfgItem.has("mode") || !vcfgItem.has("width") || !vcfgItem.has("height") || !vcfgItem.has("bitrate") || !vcfgItem.has("fps")) continue;
                            int mode = vcfgItem.getInt("mode");
                            int width = vcfgItem.getInt("width");
                            int height = vcfgItem.getInt("height");
                            int bitrate = vcfgItem.getInt("bitrate");
                            int fps = vcfgItem.getInt("fps");
                            if (mode < 0 || width < 0 || height < 0 || bitrate < 0 || fps < 0) {
                                bSucc = false;
                                ThunderLog.error("yrtc", "setParameters VideoPublisherConfig param error(<0):%d, %d, %d*%d/%d/%d", playType, mode, width, height, bitrate, fps);
                                continue;
                            }
                            LinkedList<ThunderPublishLowStreamVideoConfig> lowStreamCfgs = new LinkedList<ThunderPublishLowStreamVideoConfig>();
                            if (vcfgItem.has("lowStream") && null != (vLowCfgArry = vcfgItem.getJSONArray("lowStream")) && vLowCfgArry.length() > 0) {
                                for (int index = 0; index < vLowCfgArry.length(); ++index) {
                                    JSONObject vLowcfgItem = vLowCfgArry.getJSONObject(index);
                                    if (!vLowcfgItem.has("width") || !vLowcfgItem.has("height") || !vLowcfgItem.has("bitrate") || !vLowcfgItem.has("fps")) continue;
                                    int lowWidth = vLowcfgItem.getInt("width");
                                    int lowHeight = vLowcfgItem.getInt("height");
                                    int lowBitrate = vLowcfgItem.getInt("bitrate");
                                    int lowFps = vLowcfgItem.getInt("fps");
                                    if (lowWidth <= 0 || lowHeight <= 0 || lowBitrate <= 0 || lowFps <= 0) {
                                        bSucc = false;
                                        ThunderLog.error("yrtc", "setParameters VideoPublisherConfig lowStream param error:%d, %d, %d*%d/%d/%d", playType, mode, lowWidth, lowHeight, lowBitrate, lowFps);
                                        break;
                                    }
                                    ThunderPublishLowStreamVideoConfig lowCfg = new ThunderPublishLowStreamVideoConfig();
                                    lowCfg.type = 1;
                                    lowCfg.encodeResolutionWidth = lowWidth;
                                    lowCfg.encodeResolutionHeight = lowHeight;
                                    lowCfg.encodeBitrate = lowBitrate;
                                    lowCfg.encodeFrameRate = lowBitrate;
                                    lowStreamCfgs.add(lowCfg);
                                }
                                if (!bSucc) continue;
                            }
                            ThunderPublishVideoConfig publishInfo = new ThunderPublishVideoConfig();
                            publishInfo.playType = playType;
                            publishInfo.mode = mode;
                            publishInfo.encodeResolutionWidth = width;
                            publishInfo.encodeResolutionHeight = height;
                            publishInfo.encodeBitrate = bitrate;
                            publishInfo.encodeFrameRate = fps;
                            if (!lowStreamCfgs.isEmpty()) {
                                publishInfo.lowStreamCfgs.addAll(lowStreamCfgs);
                            }
                            if ((ret = ThunderNative.setCustomVideoPublishConfig(publishInfo)) == 0) continue;
                            bSucc = false;
                            ThunderLog.error("yrtc", "setParameters VideoPublisherConfig param error:%d, %d, %d*%d/%d/%d", playType, mode, width, height, bitrate, fps);
                        }
                    }
                } else {
                    ThunderLog.warn("yrtc", "publishCfgArray invalid");
                }
            }
            if (obj.has("SetRemotePlayType")) {
                int param = obj.getInt("SetRemotePlayType");
                ret = ThunderNative.setVideoPlayType(param, false);
                ThunderLog.release("yrtc", "setParameters setRemotePlayType:%d ret:%d", param, ret);
            }
            if (obj.has("onCrashEvent")) {
                ret = ThunderNative.onCrashEvent();
                ThunderLog.release("yrtc", "onCrashEvent ret:%d", ret);
                if (ret != 0) {
                    return ret;
                }
            }
        }
        catch (Exception exc) {
            ThunderLog.release("yrtc", String.format("setParameters err=%s", exc.toString()));
        }
        return bSucc ? ret : -13;
    }

    public void setSceneId(long sceneId) {
        ThunderLog.release("yrtc", "setSceneId %d", sceneId);
        ThunderNative.setSceneId(sceneId);
    }

    @Deprecated
    public int setRoomConfig(int config, int roomConfig) {
        ThunderLog.release("yrtc", "setRoomConfig: config=%d roomConfig:%d", config, roomConfig);
        ThunderNative.setMediaMode(config);
        ThunderNative.setRoomMode(roomConfig);
        return 0;
    }

    public int setMediaMode(int mode) {
        ThunderLog.release("yrtc", "setMediaMode: mode=%d ", mode);
        return ThunderNative.setMediaMode(mode);
    }

    public int setRoomMode(int mode) {
        ThunderLog.release("yrtc", "setRoomMode: mode=%d ", mode);
        return ThunderNative.setRoomMode(mode);
    }

    public int setArea(int area) {
        ThunderLog.release("yrtc", "setArea: area=%d", area);
        return ThunderNative.setAreaType(area);
    }

    public int getConnectionStatus() {
        return ThunderNative.getConnectionStatus();
    }

    public int enableWebSdkCompatibility(boolean enabled) {
        ThunderLog.release("yrtc", "enableWebSdkCompatibility %b", enabled);
        return ThunderNative.enableWebSdkCompatibility(enabled);
    }

    public int setUse64bitUid(boolean is64bitUid) {
        ThunderLog.release("yrtc", "setUse64bitUid %b", is64bitUid);
        return ThunderNative.setUse64bitUid(is64bitUid);
    }

    public int joinRoom(byte[] token, String roomName, String uid) {
        ThunderLog.release("yrtc", "joinRoom: roomName=%s, uid=%s, token=%s", roomName, uid, this.getPrintString(token));
        return ThunderNative.joinRoom(token, roomName, uid);
    }

    public int leaveRoom() {
        ThunderLog.release("yrtc", "leaveRoom");
        return ThunderNative.leaveRoom();
    }

    public int updateToken(byte[] token) {
        ThunderLog.release("yrtc", "updateToken: %s ", this.getPrintString(token));
        return ThunderNative.updateToken(token);
    }

    @Deprecated
    public int enableAudioEngine() {
        ThunderLog.release("yrtc", "enableAudioEngine ");
        return ThunderNative.startPublishAudio(true);
    }

    @Deprecated
    public int disableAudioEngine() {
        ThunderLog.release("yrtc", "disableAudioEngine");
        return ThunderNative.startPublishAudio(false);
    }

    public int setAudioConfig(int profile, int commutMode, int scenarioMode) {
        ThunderLog.release("yrtc", "setAudioConfig: profile=%d, commutMode=%d, scenarioMode=%d", profile, commutMode, scenarioMode);
        return ThunderNative.setAudioConfig(profile, commutMode, scenarioMode);
    }

    public int enableVoicePosition(boolean enable) {
        ThunderLog.release("yrtc", "enableVoicePosition: enable=%b", enable);
        return ThunderNative.enableVoicePosition(enable);
    }

    public int enableLoudspeaker(boolean enabled) {
        ThunderLog.release("yrtc", "enableLoudspeaker: %b", enabled);
        return ThunderNative.enableLoudSpeaker(enabled);
    }

    public boolean isLoudspeakerEnabled() {
        ThunderLog.release("yrtc", "isLoudspeakerEnabled");
        return ThunderNative.getLoudSpeakerEnabled();
    }

    public int setAudioVolumeIndication(int interval, int moreThanThd, int lessThanThd, int smooth) {
        ThunderLog.release("yrtc", "setAudioVolumeIndication: interval=%d,moreThanThd=%d, lessThanThd=%d, smooth=%d", interval, moreThanThd, lessThanThd, smooth);
        return ThunderNative.setPlayVolumeInterval(interval, moreThanThd, lessThanThd);
    }

    public int enableCaptureVolumeIndication(int interval, int moreThanThd, int lessThanThd, int smooth) {
        ThunderLog.release("yrtc", "enableCaptureVolumeIndication: interval=%d,moreThanThd=%d, lessThanThd=%d, smooth=%d", interval, moreThanThd, lessThanThd, smooth);
        return ThunderNative.setCaptureVolumeInterval(interval, moreThanThd, lessThanThd);
    }

    public boolean startAudioSaver(String fileName, int saverMode, int fileMode) {
        ThunderLog.release("yrtc", "startAudioSaver: fileName=%s, saverMode=%d, fileMode=%d", this.getPrintString(fileName), saverMode, fileMode);
        if (fileName.isEmpty()) {
            return false;
        }
        return ThunderNative.startAudioSaver(fileName, saverMode, fileMode);
    }

    public boolean stopAudioSaver() {
        ThunderLog.release("yrtc", "stopAudioSaver");
        return ThunderNative.stopAudioSaver();
    }

    public int startAudioRecord(String fileName, int saverMode, int sampleRate, int quality) {
        ThunderLog.release("yrtc", "startAudioRecord: fileName=%s, saverMode=%d, sampleRate=%d, quality=%d", this.getPrintString(fileName), saverMode, sampleRate, quality);
        if (fileName.isEmpty()) {
            return -13;
        }
        return ThunderNative.startAudioRecord(fileName, saverMode, sampleRate, quality);
    }

    public int stopAudioRecord() {
        ThunderLog.release("yrtc", "stopAudioRecord");
        return ThunderNative.stopAudioRecord();
    }

    public void setSoundEffect(int mode) {
        ThunderLog.release("yrtc", "ThunderEngine::setSoundEffect %d", mode);
        ThunderNative.setSoundEffect(mode);
    }

    public void setVoiceChanger(int mode) {
        ThunderLog.release("yrtc", "ThunderEngine::setVoiceChanger %d", mode);
        ThunderNative.setVoiceChanger(mode);
    }

    public int stopLocalAudioStream(boolean stop) {
        ThunderLog.release("yrtc", "stopLocalAudioStream: %b", stop);
        return ThunderNative.startPublishAudio(!stop);
    }

    public int enableLocalAudioCapture(boolean enable) {
        ThunderLog.release("yrtc", "enableLocalAudioCapture: %b", enable);
        return ThunderNative.startAudioCapture(enable);
    }

    public int enableLocalAudioEncoder(boolean enable) {
        ThunderLog.release("yrtc", "enableLocalAudioEncoder: %b", enable);
        return ThunderNative.startAudioEncode(enable);
    }

    public int enableLocalAudioPublisher(boolean enable) {
        ThunderLog.release("yrtc", "enableLocalAudioPublisher: %b", enable);
        return ThunderNative.startPushAudioStream(enable);
    }

    public boolean isAudioCaptureEnabled() {
        ThunderLog.release("yrtc", "isAudioCaptureEnabled");
        int iRet = ThunderNative.isAudioCaptureEnabled();
        return iRet == 1;
    }

    public int stopAllRemoteAudioStreams(boolean stop) {
        ThunderLog.release("yrtc", "stopAllRemoteAudioStreams: %b", stop);
        return ThunderNative.stopAllRemoteStreams(false, stop);
    }

    public int stopRemoteAudioStream(String uid, boolean stop) {
        ThunderLog.release("yrtc", "stopRemoteAudioStream: uid=%s, %b", uid, stop);
        return ThunderNative.stopRemoteAudioStream(uid, stop);
    }

    public int setLoudSpeakerVolume(int volume) {
        ThunderLog.release("yrtc", "setSpeakerphoneVolume: %d", volume);
        return ThunderNative.setSpeakerVolume(volume);
    }

    public int setMicVolume(int volume) {
        ThunderLog.release("yrtc", "setMicVolume: %d", volume);
        return ThunderNative.setMicVolume(volume);
    }

    public int setRemoteAudioStreamsVolume(String uid, int volume) {
        ThunderLog.release("yrtc", "setRemoteAudioStreamsVolume: uid=%s, volume=%d", this.getPrintString(uid), volume);
        return ThunderNative.setRemoteAudioStreamVolume(uid, volume);
    }

    public int setRemoteUidVoicePosition(String uid, int azimuth, int gain) {
        ThunderLog.release("yrtc", "setRemoteUidVoicePosition: uid=%s, azimuth=%d, gain=%d", this.getPrintString(uid), azimuth, gain);
        return ThunderNative.setRemoteUidVoicePosition(uid, azimuth, gain);
    }

    public ThunderAudioFilePlayer createAudioFilePlayer() {
        ThunderLog.release("yrtc", "createAudioFilePlayer");
        ThunderAudioFilePlayer audioFilePlayer = new ThunderAudioFilePlayer();
        this.mAudioFilePlayerSet.add(audioFilePlayer);
        return audioFilePlayer;
    }

    public void destroyAudioFilePlayer(ThunderAudioFilePlayer audioFilePlayer) {
        ThunderLog.release("yrtc", "destroyAudioFilePlayer: %s", this.getPrintString(audioFilePlayer));
        if (audioFilePlayer == null) {
            ThunderLog.release("yrtc", "destroyAudioFilePlayer null");
            return;
        }
        audioFilePlayer.destroyAudioFilePlayer();
        this.mAudioFilePlayerSet.remove(audioFilePlayer);
    }

    public int setEnableEqualizer(boolean enabled) {
        ThunderLog.release("yrtc", "setEnableEqualizer %b", enabled);
        return ThunderNative.enableEqualizer(enabled);
    }

    public int setEqGains(int[] gains) {
        ThunderLog.release("yrtc", "setEqGains");
        if (gains == null) {
            return -13;
        }
        return ThunderNative.setGqGains(gains);
    }

    public int setEnableReverb(boolean enabled) {
        ThunderLog.release("yrtc", "setEnableReverb %b", enabled);
        return ThunderNative.enableReverb(enabled);
    }

    public int setReverbExParameter(ThunderRtcConstant.ReverbExParameter param) {
        ThunderLog.release("yrtc", "setReverbExParameter");
        if (param == null) {
            return -13;
        }
        return ThunderNative.setReverbExParameter(param.mRoomSize, param.mPreDelay, param.mReverberance, param.mHfDamping, param.mToneLow, param.mToneHigh, param.mWetGain, param.mDryGain, param.mStereoWidth);
    }

    public int setEnableCompressor(boolean enabled) {
        ThunderLog.release("yrtc", "setEnableCompressor %b", enabled);
        return ThunderNative.enableCompressor(enabled);
    }

    public int setCompressorParam(ThunderRtcConstant.CompressorParam param) {
        ThunderLog.release("yrtc", "setCompressorParam");
        if (param == null) {
            return -13;
        }
        return ThunderNative.setCompressorParam(param.mThreshold, param.mMakeupGain, param.mRatio, param.mKnee, param.mReleaseTime, param.mAttackTime);
    }

    public int setEnableLimiter(boolean enabled) {
        ThunderLog.release("yrtc", "setEnableLimiter %b", enabled);
        return ThunderNative.enableLimiter(enabled);
    }

    public int setLimiterParam(ThunderRtcConstant.LimterParam param) {
        ThunderLog.release("yrtc", "setLimiterParam");
        if (param == null) {
            return -13;
        }
        return ThunderNative.setLimiterParameter(param.fCeiling, param.fThreshold, param.fPreGain, param.fRelease, param.fAttack, param.fLookahead, param.fLookaheadRatio, param.fRMS, param.fStLink);
    }

    public int setVoicePitch(float pitch) {
        ThunderLog.release("yrtc", "setVoicePitch %f", Float.valueOf(pitch));
        return ThunderNative.setVoicePitch(pitch);
    }

    public void setExternalAudioProcessor(long eap) {
        ThunderLog.release("yrtc", "setExternalAudioProcessor");
        ThunderNative.setExternalAudioProcessor(eap);
    }

    public void enableAudioPlaySpectrum(boolean enable) {
        ThunderLog.release("yrtc", "enableAudioPlaySpectrum %b", enable);
        ThunderNative.enableAudioPlaySpectrum(enable);
    }

    public void setAudioPlaySpectrumInfo(int spectrumLen, int notifyIntervalMS) {
        ThunderLog.release("yrtc", "setAudioPlaySpectrumInfo %d, %d", spectrumLen, notifyIntervalMS);
        ThunderNative.setAudioPlaySpectrumInfo(spectrumLen, notifyIntervalMS);
    }

    public int sendUserAppMsgData(byte[] msgData) {
        ThunderLog.release("yrtc", "sendUserAppMsgData %s", new String(msgData));
        return ThunderNative.sendUserAppMsgData(msgData);
    }

    public int sendMediaExtraInfo(ByteBuffer data, int dataLen) {
        ThunderLog.release("yrtc", "sendMediaExtraInfo %d", dataLen);
        if (data == null) {
            ThunderLog.release("yrtc", "sendMediaExtraInfo: data is null");
            return -13;
        }
        if (data.remaining() < dataLen) {
            ThunderLog.release("yrtc", "sendMediaExtraInfo: dataLen large than data.remaining()");
            return -13;
        }
        byte[] extraInfo = new byte[dataLen];
        data.get(extraInfo, 0, extraInfo.length);
        return ThunderNative.sendMediaExtraInfo(extraInfo);
    }

    public int setMediaExtraInfoCallback(IThunderMediaExtraInfoCallback callback) {
        ThunderLog.release("yrtc", "setMediaExtraInfoCallback");
        mThunderMediaExtraInfoCallback = callback;
        ThunderNative.makeBehaviorEvent("sdk_api", "setMediaExtraInfoCallback", callback == null ? "null" : "not null", 2);
        return 0;
    }

    public int enableMixVideoExtraInfo(boolean enable) {
        ThunderLog.release("yrtc", "enableMixVideoExtraInfo %b", enable);
        return ThunderNative.enableMixVideoExtraInfo(enable);
    }

    public int syncMediaPlayingProgress(int currentMs) {
        ThunderLog.release("yrtc", "syncMediaPlayingProgress %d", currentMs);
        return (int)ThunderNative.sendAudioFilePlayerInfo(0, currentMs, 0);
    }

    public void enableAudioDataIndication(boolean enablePlay) {
        ThunderLog.release("yrtc", "enableAudioDataIndication %b", enablePlay);
        ThunderNative.enableAudioDataIndication(enablePlay);
    }

    public void enableCapturePcmDataCallBack(boolean enable, int sampleRate, int channel) {
        ThunderLog.release("yrtc", "enableCapturePcmDataCallBack %b , %d, %d", enable, sampleRate, channel);
        ThunderNative.enableCapturePcmDataCallBack(enable, sampleRate, channel);
    }

    public boolean enableRenderPcmDataCallBack(boolean enable, int sampleRate, int channel) {
        ThunderLog.release("yrtc", "enableRenderPcmDataCallBack %b , %d, %d", enable, sampleRate, channel);
        return ThunderNative.enableRenderPcmDataCallBack(enable, sampleRate, channel);
    }

    public void setAudioSourceType(int sourceType) {
        ThunderLog.release("yrtc", "setAudioSourceType: mode %d", sourceType);
        ThunderNative.setAudioPublishMode(sourceType);
    }

    public int adaptToSystemKaraoke(boolean enable) {
        ThunderLog.release("yrtc", "adaptToSystemKaraoke: %b", enable);
        return ThunderNative.adaptToSystemKaraoke(enable);
    }

    public int setEnableInEarMonitor(boolean enable) {
        ThunderLog.release("yrtc", "setEnableInEarMonitor: %b", enable);
        return ThunderNative.enableInEarMonitor(enable);
    }

    public int setEarMonitoringVolume(int volume) {
        ThunderLog.release("yrtc", "setEarMonitoringVolume: %d", volume);
        return ThunderNative.setEarMonitoringVolume(volume);
    }

    @Deprecated
    public int enableVideoEngine() {
        ThunderLog.release("yrtc", "enableVideoEngine ");
        return 0;
    }

    @Deprecated
    public int disableVideoEngine() {
        ThunderLog.release("yrtc", "disableVideoEngine ");
        return 0;
    }

    public int setVideoEncoderConfig(ThunderVideoEncoderConfiguration yyVideoConfig) {
        if (yyVideoConfig == null) {
            ThunderLog.release("yrtc", "setVideoEncoderConfig null params");
            return -13;
        }
        ThunderLog.release("yrtc", "setVideoEncoderConfig, playType %d, publishMode %d", yyVideoConfig.playType, yyVideoConfig.publishMode);
        return ThunderNative.setVideoEncoderConfig(yyVideoConfig);
    }

    public int setLocalVideoCanvas(ThunderVideoCanvas local) {
        if (local == null) {
            ThunderLog.release("yrtc", "setLocalVideoCanvas null canvas");
            return -13;
        }
        ThunderLog.release("yrtc", "setLocalVideoCanvas view:%s, renderMode:%d, uid:%s, seatIndex:%d", this.getPrintString(local.mView), local.mRenderMode, local.mUid, local.mSeatIndex);
        return ThunderNative.setLocalVideoCanvas(local.mView, local.mRenderMode);
    }

    public int setRemotePlayType(int remotePlayType) {
        ThunderLog.release("yrtc", "setRemotePlayType %d", remotePlayType);
        return ThunderNative.setVideoPlayType(remotePlayType, true);
    }

    public int setRemoteVideoCanvas(ThunderVideoCanvas remote) {
        if (remote == null) {
            ThunderLog.release("yrtc", "setRemoteVideoCanvas null canvas");
            return -13;
        }
        ThunderLog.release("yrtc", "setRemoteVideoCanvas view:%s, renderMode:%d, uid:%s, mSeatIndex:%d", this.getPrintString(remote.mView), remote.mRenderMode, remote.mUid, remote.mSeatIndex);
        return ThunderNative.setRemoteVideoCanvas(remote.mView, remote.mRenderMode, remote.mUid, remote.mSeatIndex);
    }

    public int setLocalCanvasScaleMode(int mode) {
        ThunderLog.release("yrtc", "setLocalCanvasScaleMode mode: %d", mode);
        return ThunderNative.setLocalVideoCanvasMode(mode);
    }

    public int setRemoteCanvasScaleMode(String uid, int mode) {
        ThunderLog.release("yrtc", "setRemoteCanvasScaleMode uid: %s, mode: %d", uid, mode);
        return ThunderNative.setRemoteVideoCanvasMode(uid, mode, 0);
    }

    public int setRemoteCanvasMode(String uid, int renderMode, int mirrorMode) {
        ThunderLog.release("yrtc", "setRemoteCanvasMode uid: %s, renderMode: %d, mirrorMode: %d", uid, renderMode, mirrorMode);
        return ThunderNative.setRemoteVideoCanvasMode(uid, renderMode, mirrorMode);
    }

    public int startVideoPreview() {
        ThunderLog.release("yrtc", "startVideoPreview");
        return ThunderNative.startPreview(true);
    }

    public int stopVideoPreview() {
        ThunderLog.release("yrtc", "stopVideoPreview");
        return ThunderNative.startPreview(false);
    }

    public int enableLocalVideoCapture(boolean enable) {
        ThunderLog.release("yrtc", "enableLocalVideoCapture %b", enable);
        return ThunderNative.startVideoCapture(enable);
    }

    public int stopLocalVideoStream(boolean stop) {
        ThunderLog.release("yrtc", "stopLocalVideoStream: %b", stop);
        int ret = 0;
        if (stop) {
            ret = ThunderNative.startVideoEncode(false);
            return ret |= ThunderNative.startPushVideoStream(false);
        }
        ret = ThunderNative.startVideoEncode(true);
        if (ret != 0) {
            return ret;
        }
        ret = ThunderNative.startPushVideoStream(true);
        if (ret != 0) {
            ThunderNative.startVideoEncode(false);
        }
        return ret;
    }

    public int stopRemoteVideoStream(String uid, boolean stop) {
        ThunderLog.release("yrtc", "stopRemoteVideoStream Uid: %s, stop: %b", uid, stop);
        return ThunderNative.stopRemoteVideoStream(uid, stop);
    }

    public int stopAllRemoteVideoStreams(boolean stop) {
        ThunderLog.release("yrtc", "stopAllRemoteVideoStreams  stop: %b", stop);
        return ThunderNative.stopAllRemoteStreams(true, stop);
    }

    public int enableLocalDualStreamMode(boolean enabled) {
        ThunderLog.release("yrtc", "enableLocalDualStreamMode  enbaled:%b", enabled);
        return ThunderNative.enableLocalDualStreamMode(enabled);
    }

    public int setDefaultRemoteVideoStreamType(int type) {
        ThunderLog.release("yrtc", "setDefaultRemoteVideoStreamType  type:" + type);
        return ThunderNative.setDefaultRemoteVideoStreamType(type);
    }

    public int changeRemoteVideoStreamType(String uid, int type) {
        ThunderLog.release("yrtc", "changeRemoteVideoStreamType: UID:" + uid + " type:" + type);
        return ThunderNative.changeRemoteVideoStreamType(uid, type);
    }

    public int registerVideoCaptureTextureObserver(IGPUProcess observer) {
        ThunderLog.release("yrtc", "registerVideoCaptureTextureObserver");
        ThunderBridgeLib.getInstance().setGPUImageProcessFilter(observer);
        return 0;
    }

    public int registerVideoCaptureFrameObserver(IVideoCaptureObserver observer) {
        ThunderLog.release("yrtc", "registerVideoCaptureFrameObserver");
        VideoFrameYuvCapture.getInstance().enableVideoCapture(observer);
        return 0;
    }

    public int registerVideoDecodeFrameObserver(String uid, IVideoDecodeObserver observer) {
        ThunderLog.release("yrtc", "registerVideoDecodeFrameObserver uid %s", uid);
        return ThunderNative.setVideoFrameObserver(uid, observer);
    }

    public int registerAudioFrameObserver(IAudioFrameObserver observer) {
        ThunderLog.release("yrtc", "registerAudioFrameObserver");
        ThunderNative.registerAudioFrameObserver(observer);
        return 0;
    }

    public int setRecordingAudioFrameParameters(int sampleRate, int room, int mode, int samplesPerCall) {
        ThunderLog.release("yrtc", "setRecordingAudioFrameParameters sampleRate %d, room %d, mode %d, samplesPerCall %d", sampleRate, room, mode, samplesPerCall);
        return ThunderNative.setRecordingAudioFrameParameters(sampleRate, room, mode, samplesPerCall);
    }

    public int setPlaybackAudioFrameParameters(int sampleRate, int channel, int mode, int samplesPerCall) {
        ThunderLog.release("yrtc", "setPlaybackAudioFrameParameters sampleRate %d, channel %d, mode %d, samplesPerCall %d", sampleRate, channel, mode, samplesPerCall);
        return ThunderNative.setPlaybackAudioFrameParameters(sampleRate, channel, mode, samplesPerCall);
    }

    public int setMixedAudioFrameParameters(int sampleRate, int channel, int samplesPerCall) {
        ThunderLog.release("yrtc", "setMixedAudioFrameParameters sampleRate %d, channel %d, samplesPerCall %d", sampleRate, channel, samplesPerCall);
        return ThunderNative.setMixedAudioFrameParameters(sampleRate, channel, samplesPerCall);
    }

    public int setVideoWatermark(ThunderBoltImage watermark) {
        if (watermark != null && (watermark.height <= 0 || watermark.width <= 0 || watermark.width > 1920 || watermark.height > 1920 || watermark.x < 0 || watermark.y < 0)) {
            ThunderLog.release("yrtc", "setVideoWatermark invalid params, x %d, y %d, w %d, h %d ", watermark.x, watermark.y, watermark.width, watermark.height);
            return -13;
        }
        ThunderLog.release("yrtc", "setVideoWatermark");
        return ThunderNative.setPubWatermark(watermark);
    }

    public int setCustomAudioSource(boolean enabled, int sampleRate, int channel) {
        ThunderLog.release("yrtc", "setCustomAudioSource enable %b, sampleRate %d, channel %d", enabled, sampleRate, channel);
        return ThunderNative.setCustomAudioSource(enabled, sampleRate, channel);
    }

    public int pushCustomAudioFrame(byte[] data, long timeStamp) {
        if (data == null || data.length == 0) {
            return -13;
        }
        return ThunderNative.pushCustomAudioFrame(data, timeStamp);
    }

    public int setCustomVideoSource(ThunderCustomVideoSource videoSource) {
        ThunderLog.release("yrtc", "setCustomVideoSource");
        if (videoSource == null || videoSource instanceof ThunderDefaultCamera) {
            if (videoSource != null) {
                return ThunderNative.attachVideoCapture(videoSource, 0);
            }
            return ThunderNative.attachVideoCapture(mPublisher.getDefaluteCamera(), 0);
        }
        if (videoSource instanceof ScreenRecordSource) {
            return ThunderNative.attachVideoCapture(((ScreenRecordSource)videoSource).mScreenCapture, 1);
        }
        if (this.mExternalVideoSource == null || !this.mExternalVideoSource.equals(videoSource)) {
            this.mExternalVideoSource = new ExternalVideoSource(videoSource);
            if (videoSource instanceof ThunderExternalVideoSource) {
                this.mExternalVideoSource.setVideoBufferType(((ThunderExternalVideoSource)videoSource).getThunderVideoBufferType());
            }
        }
        return ThunderNative.attachVideoCapture(this.mExternalVideoSource, 2);
    }

    public int addPublishOriginStreamUrl(String url) {
        ThunderLog.release("yrtc", "addPublishOriginStreamUrl %s", url);
        return ThunderNative.updatePublishOriginStreamUrl(true, url);
    }

    public int removePublishOriginStreamUrl(String url) {
        ThunderLog.release("yrtc", "removePublishOriginStreamUrl %s", url);
        return ThunderNative.updatePublishOriginStreamUrl(false, url);
    }

    public int addPublishTranscodingStreamUrl(String taskId, String url) {
        ThunderLog.release("yrtc", "addPublishTranscodingStreamUrl taskId %s, url %s", taskId, url);
        return ThunderNative.updatePublishTranscodingStreamUrl(taskId, true, url);
    }

    public int removePublishTranscodingStreamUrl(String taskId, String url) {
        ThunderLog.release("yrtc", "removePublishTranscodingStreamUrl taskId %s, url %s", taskId, url);
        return ThunderNative.updatePublishTranscodingStreamUrl(taskId, false, url);
    }

    public int setLiveTranscodingTask(String taskId, LiveTranscoding transcoding) {
        ThunderLog.release("yrtc", "setLiveTranscodingTask taskId %s", taskId);
        return ThunderNative.setLiveTranscodingTask(taskId, transcoding);
    }

    public int removeLiveTranscodingTask(String taskId) {
        ThunderLog.release("yrtc", "removeLiveTranscodingTask taskId %s", taskId);
        return ThunderNative.removeLiveTranscodingTask(taskId);
    }

    public int addSubscribe(String roomId, String uid) {
        ThunderLog.release("yrtc", "addSubscribe roomId %s, uid %s", roomId, uid);
        return ThunderNative.subscribeUser(true, roomId, uid);
    }

    public int removeSubscribe(String roomId, String uid) {
        ThunderLog.release("yrtc", "removeSubscribe roomId %s, uid %s", roomId, uid);
        return ThunderNative.subscribeUser(false, roomId, uid);
    }

    public int switchFrontCamera(boolean bFront) {
        ThunderLog.release("yrtc", "switchFrontCamera %b", bFront);
        return ThunderNative.switchFrontCamera(bFront);
    }

    public boolean isCameraOpen() {
        ThunderLog.release("yrtc", "isCameraOpen");
        return ThunderNative.isCameraOpen();
    }

    public boolean isFrontCamera() {
        ThunderLog.release("yrtc", "isFrontCamera");
        return ThunderNative.isFrontCamera();
    }

    public boolean isCameraFocusSupported() {
        ThunderLog.release("yrtc", "isCameraFocusSupported");
        return ThunderNative.isCameraManualFocusPositionSupported();
    }

    public boolean isCameraExposurePositionSupported() {
        ThunderLog.release("yrtc", "isCameraExposurePositionSupported");
        return ThunderNative.isCameraManualExposurePositionSupported();
    }

    public boolean isCameraZoomSupported() {
        ThunderLog.release("yrtc", "isCameraZoomSupported");
        return ThunderNative.isCameraZoomSupported();
    }

    public float getCameraMaxZoomFactor() {
        ThunderLog.release("yrtc", "getCameraMaxZoomFactor");
        return ThunderNative.getCameraMaxZoomFactor();
    }

    public int setCameraZoomFactor(float zoomFactor) {
        return ThunderNative.setCameraZoomFactor(zoomFactor);
    }

    public boolean isCameraTorchSupported() {
        ThunderLog.release("yrtc", "isCameraTorchSupported");
        return ThunderNative.isCameraTorchSupported();
    }

    public int setCameraTorchOn(boolean isOn) {
        ThunderLog.release("yrtc", "setCameraTorchOn %b", isOn);
        return ThunderNative.setCameraTorchOn(isOn);
    }

    public int setCameraFocusPositionInPreview(float posX, float posY) {
        ThunderLog.release("yrtc", "setCameraFocusPositionInPreview");
        return ThunderNative.setCameraFocusPosition(posX, posY);
    }

    public int setCameraExposurePosition(float posX, float posY) {
        ThunderLog.release("yrtc", "setCameraExposurePosition");
        return ThunderNative.setCameraExposurePosition(posX, posY);
    }

    public boolean isCameraAutoFocusFaceModeSupported() {
        ThunderLog.release("yrtc", "isCameraAutoFocusFaceModeSupported");
        return ThunderNative.isCameraAutoFocusFaceModeSupported();
    }

    public int setCameraAutoFocusFaceModeEnabled(boolean enable) {
        ThunderLog.release("yrtc", "setCameraAutoFocusFaceModeEnabled %b", enable);
        return ThunderNative.setCameraAutoFocusFaceModeEnabled(enable);
    }

    public int getVideoCaptureOrientation() {
        return ThunderNative.getOrientation();
    }

    public int setVideoCaptureOrientation(int orientation) {
        ThunderLog.release("yrtc", "setVideoCaptureOrientation orientation %d", orientation);
        return ThunderNative.setOrientation(orientation);
    }

    public int setLocalVideoMirrorMode(int mode) {
        if (ThunderLog.isInfoValid()) {
            ThunderLog.info("yrtc", "setLocalVideoMirrorMode %d", mode);
        }
        return ThunderNative.setLocalVideoMirrorMode(mode);
    }

    public int enableHowlingDetector(Boolean enabled) {
        ThunderLog.release("yrtc", "enableHowlingDetector %b", enabled);
        return ThunderNative.enableHowlingDetector(enabled);
    }

    public int enableEchoDetector(Boolean enabled) {
        ThunderLog.release("yrtc", "enableEchoDetector %b", enabled);
        return ThunderNative.enableEchoDetector(enabled);
    }

    public int enableLocalSpeakingDetector(Boolean enabled) {
        ThunderLog.release("yrtc", "enableLocalSpeakingDetector %b", enabled);
        return ThunderNative.enableLocalSpeakingDetector(enabled);
    }

    public int startInputDeviceTest() {
        ThunderLog.release("yrtc", "startInputDeviceTest");
        return ThunderNative.startInputDeviceTest();
    }

    public int stopInputDeviceTest() {
        ThunderLog.release("yrtc", "stopInputDeviceTest");
        return ThunderNative.stopInputDeviceTest();
    }

    public int startOutputDeviceTest(String filePath) {
        ThunderLog.release("yrtc", "startOutputDeviceTest");
        return ThunderNative.startOutputDeviceTest(filePath);
    }

    public int stopOutputDeviceTest() {
        ThunderLog.release("yrtc", "stopOutputDeviceTest");
        return ThunderNative.stopOutputDeviceTest();
    }

    public int enableMicDenoise(boolean enabled) {
        ThunderLog.release("yrtc", "enableMicDenoise %b", enabled);
        return ThunderNative.enableMicDenoise(enabled);
    }

    public boolean isMicDenoiseEnabled() {
        boolean ret = ThunderNative.micDenoiseEnabled();
        ThunderLog.release("yrtc", "isMicDenoiseEnabled %b", ret);
        return ret;
    }

    public int enableAGC(boolean enabled) {
        ThunderLog.release("yrtc", "enableAGC %b", enabled);
        return ThunderNative.enableAGC(enabled);
    }

    public int setMultiVideoViewLayout(ThunderMultiVideoViewParam params) {
        if (params != null) {
            ThunderLog.release("yrtc", "setMultiVideoViewLayout mViewId:%d, view:%s, BitMap:%s, coordinate:%s", params.mViewId, this.getPrintString(params.mView), this.getPrintString(params.mBgBitmap), this.getPrintString(params.mBgViewPosition));
            return ThunderNative.initMultiPlayerViewLayout(params, params.mViewId, params.mView);
        }
        ThunderLog.release("yrtc", "setMultiVideoViewLayout null");
        return -13;
    }

    public Bitmap captureRemoteScreenShot(String uid) {
        ThunderLog.release("yrtc", "captureRemoteScreenShot uid: %b", uid);
        return ThunderNative.captureRemoteScreenShot(uid);
    }

    public int setCaptureReplaceImage(Bitmap bitmap) {
        ThunderLog.release("yrtc", "setCaptureReplaceImage");
        return ThunderNative.setCaptureReplaceImage(bitmap);
    }

    public Bitmap captureLocalScreenShot() {
        ThunderLog.release("yrtc", "captureLocalScreenShot");
        return ThunderNative.captureLocalScreenShot();
    }

    public ThunderVideoEncodeParam getVideoEncoderParam(ThunderVideoEncoderConfiguration videoConfig) {
        if (videoConfig == null) {
            ThunderLog.release("yrtc", "getVideoEncoderParam null params");
            return null;
        }
        ThunderVideoEncodeParam param = ThunderNative.getVideoEncoderParamByGear(videoConfig.playType, videoConfig.publishMode);
        ThunderLog.release("yrtc", "getVideoEncoderParam playType %d, publishMode %d", videoConfig.playType, videoConfig.publishMode);
        return param;
    }

    public static ThunderDefaultCamera getDefaluteCamera() {
        if (mPublisher != null) {
            return mPublisher.getDefaluteCamera();
        }
        return null;
    }

    private void resetRtcEngine() {
        mHandler = null;
        mRtcEventHandler = null;
        mHttpsRequestHandler = null;
        s_captureVolumeNotifyCount = 0;
        s_playVolumeNotifyCount = 0;
        s_playDataNotifyCount = 0;
        s_audioPlaySpectrumCount = 0;
        if (mPublisher.getDefaluteCamera() != null) {
            ThunderPreviewConfig config = (ThunderPreviewConfig)mPublisher.getDefaluteCamera().getCaptureConfig();
            config.cameraPosition = 0;
            config.captureOrientation = 0;
        }
        mPublisher = null;
        mThunderMediaExtraInfoCallback = null;
        if (mNetStateService != null) {
            mNetStateService.fini();
        }
        if (mForeBackgroundListener != null) {
            mForeBackgroundListener.fini();
        }
        mNetStateService = null;
        mForeBackgroundListener = null;
    }

    private void cleanAllAudioFilePlayer() {
        for (ThunderAudioFilePlayer audioFilePlayer : this.mAudioFilePlayerSet) {
            audioFilePlayer.destroyAudioFilePlayer();
        }
        this.mAudioFilePlayerSet.clear();
    }

    private String getPrintString(String str) {
        String result = "";
        if (str != null) {
            result = str;
        }
        return result;
    }

    private String getPrintString(byte[] data) {
        String result = "";
        if (data != null) {
            result = data.toString();
        }
        return result;
    }

    private String getPrintString(Object obj) {
        String result = "";
        if (obj != null) {
            result = obj.toString();
        }
        return result;
    }

    static {
        mThunderMediaExtraInfoCallback = null;
        s_captureVolumeNotifyCount = 0;
        s_playVolumeNotifyCount = 0;
        s_playDataNotifyCount = 0;
        s_audioPlaySpectrumCount = 0;
        mPublisher = null;
        if ("fullvideo".equalsIgnoreCase("fullvideo")) {
            try {
                System.loadLibrary("c++_shared");
            }
            catch (Throwable e) {
                e.printStackTrace();
                Log.e((String)"yrtc", (String)"fullvideo flavor load c++_shared failed!");
            }
        }
        try {
            System.loadLibrary("ffmpeg-neon");
            System.loadLibrary("yydec265");
        }
        catch (Throwable e) {
            e.printStackTrace();
            Log.e((String)"yrtc", (String)"load ffmpeg-neon & Ittiamhevcdec failed!");
        }
        try {
            System.loadLibrary("thunder");
        }
        catch (Throwable e) {
            e.printStackTrace();
            Log.e((String)"yrtc", (String)"load thunder failed!");
        }
    }

    private static class SingleonHolder {
        private static ThunderEngine INSTANCE = new ThunderEngine();

        private SingleonHolder() {
        }
    }

    private static class NotificationHandler
    extends Handler {
        private final WeakReference<ThunderEngine> mThunderEngine;

        public NotificationHandler(ThunderEngine rtc) {
            this.mThunderEngine = new WeakReference<ThunderEngine>(rtc);
        }

        public NotificationHandler(ThunderEngine rtc, Looper loop) {
            super(loop);
            this.mThunderEngine = new WeakReference<ThunderEngine>(rtc);
        }

        public void handleMessage(Message msg) {
            ThunderEngine thunderEngine = (ThunderEngine)this.mThunderEngine.get();
            if (thunderEngine == null || mRtcEventHandler == null) {
                return;
            }
            try {
                switch (msg.what) {
                    case 0: {
                        ThunderNotification.ThunderFirstVideoFrameSend notify = (ThunderNotification.ThunderFirstVideoFrameSend)msg.obj;
                        mRtcEventHandler.onFirstLocalVideoFrameSent(notify.getElapsedTime());
                        ThunderLog.release("yrtc", "ThunderNotification.ThunderFirstVideoFrameSend elapsedTime %d", notify.getElapsedTime());
                        break;
                    }
                    case 1: {
                        ThunderNotification.ThunderFirstAudioFrameSend notify = (ThunderNotification.ThunderFirstAudioFrameSend)msg.obj;
                        mRtcEventHandler.onFirstLocalAudioFrameSent(notify.getElapsedTime());
                        ThunderLog.release("yrtc", "ThunderNotification.ThunderFirstAudioFrameSend elapsedTime %d", notify.getElapsedTime());
                        break;
                    }
                    case 2: {
                        ThunderNotification.ThunderJoinRoomSuccess notify = (ThunderNotification.ThunderJoinRoomSuccess)msg.obj;
                        mRtcEventHandler.onJoinRoomSuccess(notify.getmRoomName(), notify.getmUid(), notify.getmElapsedTime());
                        ThunderLog.release("yrtc", "ThunderNotification.ThunderJoinRoomSucces room %s, uid %s, elapsedTime %d", notify.getmRoomName(), notify.getmUid(), notify.getmElapsedTime());
                        break;
                    }
                    case 3: {
                        ThunderNotification.ThunderLeaveRoom notify = (ThunderNotification.ThunderLeaveRoom)msg.obj;
                        ThunderEventHandler.RoomStats roomStats = new ThunderEventHandler.RoomStats();
                        ThunderLog.release("yrtc", "ThunderNotification.kThunderNotification_LeaveRoom");
                        mRtcEventHandler.onLeaveRoom(roomStats);
                        break;
                    }
                    case 4: {
                        ThunderNotification.ThunderRemoteVideoPlay notify = (ThunderNotification.ThunderRemoteVideoPlay)msg.obj;
                        mRtcEventHandler.onRemoteVideoPlay(notify.getmUid(), notify.getmWith(), notify.getmHeigh(), notify.getmElapsedTime());
                        ThunderLog.release("yrtc", "ThunderNotification.kThunderNotification_RemoteVideoPlay uid %s, with %d, heigh %d, elapsedTime %d", notify.getmUid(), notify.getmWith(), notify.getmHeigh(), notify.getmElapsedTime());
                        break;
                    }
                    case 5: {
                        ThunderNotification.ThunderBizAuthStreamRes notify = (ThunderNotification.ThunderBizAuthStreamRes)msg.obj;
                        mRtcEventHandler.onBizAuthResult(notify.isbPublish(), notify.getmResult());
                        ThunderLog.release("yrtc", "ThunderNotification.ThunderBizAuthRes bPublish %b, result %d", notify.isbPublish(), notify.getmResult());
                        mRtcEventHandler.onBizAuthStreamResult(notify.isbPublish(), notify.getmStreamType(), notify.getmResult());
                        ThunderLog.release("yrtc", "ThunderNotification.ThunderBizAuthStreamRes bPublish %b, type %d, result %d", notify.isbPublish(), notify.getmStreamType(), notify.getmResult());
                        break;
                    }
                    case 6: {
                        ThunderNotification.ThunderSdkAuthRes notify = (ThunderNotification.ThunderSdkAuthRes)msg.obj;
                        mRtcEventHandler.onSdkAuthResult(notify.getmResult());
                        ThunderLog.release("yrtc", "ThunderNotification.ThunderSdkAuthRes result %d", notify.getmResult());
                        break;
                    }
                    case 7: {
                        ThunderNotification.ThunderUserBanned notify = (ThunderNotification.ThunderUserBanned)msg.obj;
                        mRtcEventHandler.onUserBanned(notify.isbBanned());
                        ThunderLog.release("yrtc", "ThunderNotification.ThunderUserBanned bBanned %b", notify.isbBanned());
                        break;
                    }
                    case 8: {
                        ThunderNotification.ThunderTokenRequest notify = (ThunderNotification.ThunderTokenRequest)msg.obj;
                        mRtcEventHandler.onTokenRequested();
                        ThunderLog.release("yrtc", "ThunderNotification.ThunderTokenRequest");
                        break;
                    }
                    case 9: {
                        ThunderNotification.ThunderTokenWillExpire notify = (ThunderNotification.ThunderTokenWillExpire)msg.obj;
                        mRtcEventHandler.onTokenWillExpire(notify.getToken().getBytes());
                        ThunderLog.release("yrtc", "ThunderNotification.ThunderTokenWillExpire %s", notify.getToken());
                        break;
                    }
                    case 10: {
                        ThunderNotification.ThunderAudioCaptureVolume notify = (ThunderNotification.ThunderAudioCaptureVolume)msg.obj;
                        mRtcEventHandler.onCaptureVolumeIndication(notify.getmVolume(), notify.getmCpt(), notify.getmMicVolume());
                        if (s_captureVolumeNotifyCount % 200 == 0) {
                            ThunderLog.release("yrtc", "ThunderNotification.ThunderAudioCaptureVolume totalVolume %d, cpt %d, micVolume %d", notify.getmVolume(), notify.getmCpt(), notify.getmMicVolume());
                        }
                        ++s_captureVolumeNotifyCount;
                        break;
                    }
                    case 11: {
                        ThunderNotification.ThunderAudioPlayVolume notify = (ThunderNotification.ThunderAudioPlayVolume)msg.obj;
                        HashSet<ThunderEventHandler.AudioVolumeInfo> audioPlayVolumes = notify.getVolumes();
                        if (audioPlayVolumes != null && !audioPlayVolumes.isEmpty()) {
                            ThunderEventHandler.AudioVolumeInfo[] volumeInfos = audioPlayVolumes.toArray(new ThunderEventHandler.AudioVolumeInfo[audioPlayVolumes.size()]);
                            mRtcEventHandler.onPlayVolumeIndication(volumeInfos, notify.getTotalVolume());
                            if (s_playVolumeNotifyCount % 200 == 0) {
                                ThunderLog.release("yrtc", "ThunderNotification.ThunderAudioPlayVolume size %d totalVolume %d", notify.getVolumes().size(), notify.getTotalVolume());
                            }
                            ++s_playVolumeNotifyCount;
                            break;
                        }
                        ThunderLog.error("yrtc", "ThunderNotification.ThunderAudioPlayVolume size %d totalVolume %d", 0, notify.getTotalVolume());
                        break;
                    }
                    case 12: {
                        ThunderNotification.ThunderAudioPlayData notify = (ThunderNotification.ThunderAudioPlayData)msg.obj;
                        mRtcEventHandler.onAudioPlayData(notify.getData(), notify.getCpt(), notify.getPts(), notify.getUid(), notify.getDuration());
                        if (s_playDataNotifyCount % 500 == 0) {
                            ThunderLog.release("yrtc", "ThunderNotification.ThunderAudioPlayData cpt %d, pts %d, uid %s, duration %d", notify.getCpt(), notify.getPts(), notify.getUid(), notify.getDuration());
                        }
                        ++s_playDataNotifyCount;
                        break;
                    }
                    case 13: {
                        ThunderNotification.ThunderAudioPlaySpectrumData notify = (ThunderNotification.ThunderAudioPlaySpectrumData)msg.obj;
                        mRtcEventHandler.onAudioPlaySpectrumData(notify.getData());
                        if (s_audioPlaySpectrumCount % 500 == 0) {
                            ThunderLog.release("yrtc", "ThunderNotification.kThunderNotification_AudioPlaySpectrumData");
                        }
                        ++s_audioPlaySpectrumCount;
                        break;
                    }
                    case 14: {
                        ThunderNotification.ThunderAudioCapturePcmData notify = (ThunderNotification.ThunderAudioCapturePcmData)msg.obj;
                        mRtcEventHandler.onAudioCapturePcmData(notify.getData(), notify.getLen(), notify.getSampleRate(), notify.getChannel());
                        break;
                    }
                    case 15: {
                        ThunderNotification.ThunderUserAppMsgData notify = (ThunderNotification.ThunderUserAppMsgData)msg.obj;
                        mRtcEventHandler.onRecvUserAppMsgData(notify.getMsgData().getBytes(), notify.getUid());
                        break;
                    }
                    case 16: {
                        ThunderNotification.ThunderAppMsgDataFailStatus notify = (ThunderNotification.ThunderAppMsgDataFailStatus)msg.obj;
                        mRtcEventHandler.onSendAppMsgDataFailedStatus(notify.getStatus());
                        ThunderLog.release("yrtc", "ThunderNotification.kThunderNotification_AppMsgDataFailStatus status %d", notify.getStatus());
                        break;
                    }
                    case 17: {
                        ThunderNotification.ThunderAudioRenderPcmData notify = (ThunderNotification.ThunderAudioRenderPcmData)msg.obj;
                        mRtcEventHandler.onAudioRenderPcmData(notify.getData(), notify.getLen(), notify.getDuration(), notify.getSampleRate(), notify.getChannel());
                        break;
                    }
                    case 18: {
                        ThunderNotification.ThunderHttpsRequest notify = (ThunderNotification.ThunderHttpsRequest)msg.obj;
                        if (mHttpsRequestHandler != null) {
                            mHttpsRequestHandler.send(notify.getUrl(), notify.getTarget());
                        }
                        ThunderLog.release("yrtc", "ThunderNotification.kThunderNotification_HttpsRequest, url %s, target %d", notify.getUrl(), notify.getTarget());
                        break;
                    }
                    case 19: {
                        ThunderNotification.ThunderRemoteVideoStopped notify = (ThunderNotification.ThunderRemoteVideoStopped)msg.obj;
                        mRtcEventHandler.onRemoteVideoStopped(notify.getUid(), notify.isbStop());
                        ThunderLog.release("yrtc", "ThunderNotification.kThunderNotification_RemoteVideoStopped uid %s, isStop %b", notify.getUid(), notify.isbStop());
                        break;
                    }
                    case 20: {
                        ThunderNotification.ThunderRemoteAudioStopped notify = (ThunderNotification.ThunderRemoteAudioStopped)msg.obj;
                        mRtcEventHandler.onRemoteAudioStopped(notify.getUid(), notify.isbStop());
                        ThunderLog.release("yrtc", "ThunderNotification.kThunderNotification_RemoteAudioStopped uid %s, isStop %b", notify.getUid(), notify.isbStop());
                        break;
                    }
                    case 21: {
                        ThunderNotification.ThunderVideoSizeChange notify = (ThunderNotification.ThunderVideoSizeChange)msg.obj;
                        mRtcEventHandler.onVideoSizeChanged(notify.getUid(), notify.getWidth(), notify.getHeight(), 0);
                        ThunderLog.release("yrtc", "ThunderNotification.kThunderNotification_VideoSizeChange uid %s, w %d, h %d", notify.getUid(), notify.getWidth(), notify.getHeight());
                        break;
                    }
                    case 22: {
                        ThunderNotification.ThunderConnectionStatus notify = (ThunderNotification.ThunderConnectionStatus)msg.obj;
                        mRtcEventHandler.onConnectionStatus(notify.getStatus());
                        break;
                    }
                    case 23: {
                        ThunderNotification.ThunderConnectionLost notify = (ThunderNotification.ThunderConnectionLost)msg.obj;
                        mRtcEventHandler.onConnectionLost();
                        break;
                    }
                    case 24: {
                        ThunderNotification.RoomStats notify = (ThunderNotification.RoomStats)msg.obj;
                        mRtcEventHandler.onRoomStats(notify);
                        break;
                    }
                    case 25: {
                        ThunderNotification.ThunderNetworkStateChange notify = (ThunderNotification.ThunderNetworkStateChange)msg.obj;
                        mRtcEventHandler.onNetworkTypeChanged(notify.getStatus());
                        ThunderLog.release("yrtc", "ThunderNotification.kThunderNotification_NetworkStateChange status %d", notify.getStatus());
                        break;
                    }
                    case 26: {
                        ThunderNotification.ThunderPublishStreamToCdnStatus notify = (ThunderNotification.ThunderPublishStreamToCdnStatus)msg.obj;
                        mRtcEventHandler.onPublishStreamToCDNStatus(notify.getUrl(), notify.getErrorCode());
                        ThunderLog.release("yrtc", "ThunderNotification.kThunderNotification_PublishStreamToCdnStatus url %s, errorCode %d", notify.getUrl(), notify.getErrorCode());
                        break;
                    }
                    case 27: {
                        ThunderNotification.ThunderUserJoined notify = (ThunderNotification.ThunderUserJoined)msg.obj;
                        mRtcEventHandler.onUserJoined(notify.getUid(), notify.getElapsedTime());
                        ThunderLog.release("yrtc", "ThunderNotification.kThunderNotification_UserJoined uid %s", notify.getUid());
                        break;
                    }
                    case 28: {
                        ThunderNotification.ThunderUserOffline notify = (ThunderNotification.ThunderUserOffline)msg.obj;
                        mRtcEventHandler.onUserOffline(notify.getUid(), notify.getReason());
                        ThunderLog.release("yrtc", "ThunderNotification.kThunderNotification_UserOffline uid %s reason %d", notify.getUid(), notify.getReason());
                        break;
                    }
                    case 29: {
                        ThunderNotification.ThunderNetworkQuality notify = (ThunderNotification.ThunderNetworkQuality)msg.obj;
                        mRtcEventHandler.onNetworkQuality(notify.getUid(), notify.getTxQuality(), notify.getRxQuality());
                        break;
                    }
                    case 30: {
                        ThunderNotification.ThunderAudioExtraInfo notify = (ThunderNotification.ThunderAudioExtraInfo)msg.obj;
                        if (mThunderMediaExtraInfoCallback == null) break;
                        ByteBuffer extraInfo = ByteBuffer.wrap(notify.getExtraInfo().getBytes());
                        mThunderMediaExtraInfoCallback.onRecvMediaExtraInfo(notify.getUid(), extraInfo, extraInfo.remaining());
                        break;
                    }
                    case 31: {
                        ThunderNotification.ThunderAudioExtraFailStatus notify = (ThunderNotification.ThunderAudioExtraFailStatus)msg.obj;
                        if (mThunderMediaExtraInfoCallback != null) {
                            mThunderMediaExtraInfoCallback.onSendMediaExtraInfoFailedStatus(notify.getStatus());
                        }
                        ThunderLog.release("yrtc", "kThunderNotification_AudioExtraFailStatus status %d", notify.getStatus());
                        break;
                    }
                    case 32: {
                        if (mThunderMediaExtraInfoCallback == null) break;
                        ThunderNotification.ThunderVideoExtraInfo notify = (ThunderNotification.ThunderVideoExtraInfo)msg.obj;
                        ByteBuffer extraInfo = ByteBuffer.wrap(notify.getExtraInfo().getBytes());
                        mThunderMediaExtraInfoCallback.onRecvMediaExtraInfo(notify.getUid(), extraInfo, extraInfo.remaining());
                        break;
                    }
                    case 33: {
                        if (mThunderMediaExtraInfoCallback == null) break;
                        ThunderNotification.ThunderMixVideoExtraInfo notify = (ThunderNotification.ThunderMixVideoExtraInfo)msg.obj;
                        mThunderMediaExtraInfoCallback.onRecvMixVideoInfo(notify.getmUid(), notify.getMixExtraInfos());
                        break;
                    }
                    case 34: {
                        if (mThunderMediaExtraInfoCallback == null) break;
                        ThunderNotification.ThunderMixAudioExtraInfo notify = (ThunderNotification.ThunderMixAudioExtraInfo)msg.obj;
                        mThunderMediaExtraInfoCallback.onRecvMixAudioInfo(notify.getmUid(), notify.getMixAudioExtraInfos());
                        break;
                    }
                    case 35: {
                        ThunderNotification.ThunderAudioCaptureStatus notify = (ThunderNotification.ThunderAudioCaptureStatus)msg.obj;
                        mRtcEventHandler.onAudioCaptureStatus(notify.getStatus());
                        break;
                    }
                    case 36: {
                        ThunderNotification.ThunderVideoCaptureStatus notify = (ThunderNotification.ThunderVideoCaptureStatus)msg.obj;
                        mRtcEventHandler.onVideoCaptureStatus(notify.getStatus());
                        break;
                    }
                    case 37: {
                        ThunderNotification.ThunderLocalVideoStats info = (ThunderNotification.ThunderLocalVideoStats)msg.obj;
                        if (mRtcEventHandler == null) break;
                        ThunderEventHandler.LocalVideoStats stats = new ThunderEventHandler.LocalVideoStats();
                        stats.sentBitrate = info.getSendBitrate();
                        stats.sentFrameRate = info.getSendFrameRate();
                        stats.renderOutputFrameRate = info.getRenderOutputFrameRate();
                        stats.targetBitRate = info.getTargetBitrate();
                        stats.targetFrameRate = info.getTargetFrameRate();
                        stats.qualityAdaptIndication = info.getQualityAdaptIndicat();
                        stats.encoderOutputFrameRate = info.getEncodeFrameRate();
                        stats.encodedBitrate = info.getBitrate();
                        stats.encodedFrameWidth = info.getWidth();
                        stats.encodedFrameHeight = info.getHeight();
                        stats.encodedFrameCount = info.getEncodedFrameCount();
                        stats.encodedType = info.getEncodedType();
                        stats.codecType = info.getCodec();
                        stats.configBitRate = info.getConfigBitRate();
                        stats.configFrameRate = info.getConfigFrameRate();
                        stats.configWidth = info.getConfigWidth();
                        stats.configHeight = info.getConfigHeight();
                        mRtcEventHandler.onLocalVideoStats(stats);
                        break;
                    }
                    case 39: {
                        ThunderNotification.ThunderLocalAudioStats info = (ThunderNotification.ThunderLocalAudioStats)msg.obj;
                        if (ThunderLog.isInfoValid()) {
                            ThunderLog.info("yrtc", String.format("ThunderNotification.ThunderLocalAudioStats encodedBitrate=%d channels=%d sendSampleRate=%d sendBitRate=%d enableVad=%d", info.getEncodedBitrate(), info.getNumChannels(), info.getSampleRate(), info.getSendBitRate(), info.getEnableVad()));
                        }
                        if (mRtcEventHandler == null) break;
                        ThunderEventHandler.LocalAudioStats stats = new ThunderEventHandler.LocalAudioStats();
                        stats.encodedBitrate = info.getEncodedBitrate();
                        stats.numChannels = info.getNumChannels();
                        stats.sendSampleRate = info.getSampleRate();
                        stats.sendBitrate = info.getSendBitRate();
                        stats.enableVad = info.getEnableVad();
                        mRtcEventHandler.onLocalAudioStats(stats);
                        break;
                    }
                    case 38: {
                        ThunderNotification.RemoteVideoStats info = (ThunderNotification.RemoteVideoStats)msg.obj;
                        if (mRtcEventHandler == null) break;
                        ThunderEventHandler.RemoteVideoStats stats = new ThunderEventHandler.RemoteVideoStats();
                        stats.delay = info.getDelay();
                        stats.width = info.getWidth();
                        stats.height = info.getHeight();
                        stats.receivedBitrate = info.getReceivedBitrate();
                        stats.decoderOutputFrameRate = info.getDecoderFrameRate();
                        stats.rendererOutputFrameRate = info.getRenderFrameRate();
                        stats.packetLossRate = info.getPacketLossRate();
                        stats.rxStreamType = info.getRxStreamType();
                        stats.totalFrozenTime = info.getFrozenTime();
                        stats.frozenRate = info.getFrozenRate();
                        stats.codecType = info.getCodecType();
                        stats.decodedType = info.getDecodedType();
                        mRtcEventHandler.onRemoteVideoStatsOfUid(info.getUid(), stats);
                        break;
                    }
                    case 40: {
                        ThunderNotification.RemoteAudioStats info = (ThunderNotification.RemoteAudioStats)msg.obj;
                        if (mRtcEventHandler == null) break;
                        ThunderEventHandler.RemoteAudioStats stats = new ThunderEventHandler.RemoteAudioStats();
                        stats.quality = info.getQuality();
                        stats.networkTransportDelay = info.getNetworkTransportDelay();
                        stats.jitterBufferDelay = info.getJitterBufferDelay();
                        stats.totalDelay = info.getTotalDelay();
                        stats.frameLossRate = info.getFrameLossRate();
                        stats.numChannels = info.getNumChannels();
                        stats.receivedSampleRate = info.getReceivedSampleRate();
                        stats.receivedBitrate = info.getReceivedBitrate();
                        stats.totalFrozenTime = info.getFrozenTime();
                        stats.frozenRate = info.getFrozenRate();
                        mRtcEventHandler.onRemoteAudioStatsOfUid(info.getUid(), stats);
                        break;
                    }
                    case 41: {
                        ThunderNotification.ThunderRemoteAudioStateChanged info = (ThunderNotification.ThunderRemoteAudioStateChanged)msg.obj;
                        if (mRtcEventHandler != null && info != null) {
                            mRtcEventHandler.onRemoteAudioStateChangedOfUid(info.getUid(), info.getState(), info.getReason(), info.getElapsedTime());
                            ThunderLog.release("yrtc", "ThunderNotification.kThunderNotification_RemoteAudioStateChanged uid %s, state %d, reason %d, elapsedTime %d", info.getUid(), info.getState(), info.getReason(), info.getElapsedTime());
                        }
                        break;
                    }
                    case 43: {
                        ThunderNotification.ThunderRemoteVideoStateChanged info = (ThunderNotification.ThunderRemoteVideoStateChanged)msg.obj;
                        if (mRtcEventHandler != null && info != null) {
                            mRtcEventHandler.onRemoteVideoStateChangedOfUid(info.getUid(), info.getState(), info.getReason(), info.getElapsedTime());
                            ThunderLog.release("yrtc", "ThunderNotification.kThunderNotification_RemoteVideoStateChanged uid %s, state %d, reason %d, elapsedTime %d", info.getUid(), info.getState(), info.getReason(), info.getElapsedTime());
                        }
                        break;
                    }
                    case 42: {
                        ThunderNotification.ThunderRemoteAudioPlay info = (ThunderNotification.ThunderRemoteAudioPlay)msg.obj;
                        if (mRtcEventHandler != null && info != null) {
                            mRtcEventHandler.onRemoteAudioPlay(info.getUid(), info.getElapsedTime());
                            ThunderLog.release("yrtc", "ThunderNotification.kThunderNotification_RemoteAudioStateChanged uid %s, elapsedTime %d", info.getUid(), info.getElapsedTime());
                        }
                        break;
                    }
                    case 44: {
                        ThunderNotification.LocalAudioStatusChanged info = (ThunderNotification.LocalAudioStatusChanged)msg.obj;
                        if (ThunderLog.isInfoValid()) {
                            ThunderLog.info("yrtc", "ThunderNotification.LocalAudioStatusChanged status=%d errorReason=%d", info.getLocalAudioStreamStatus(), info.getLocalAudioStreamErrorReason());
                        }
                        if (mRtcEventHandler == null) break;
                        ThunderEventHandler.LocalAudioStatusChanged stats = new ThunderEventHandler.LocalAudioStatusChanged();
                        stats.status = info.getLocalAudioStreamStatus();
                        stats.errorReason = info.getLocalAudioStreamErrorReason();
                        mRtcEventHandler.onLocalAudioStatusChanged(stats.status, stats.errorReason);
                        break;
                    }
                    case 46: {
                        ThunderNotification.LocalVideoStatusChanged info = (ThunderNotification.LocalVideoStatusChanged)msg.obj;
                        if (ThunderLog.isInfoValid()) {
                            ThunderLog.info("yrtc", "ThunderNotification.LocalVideoStatusChanged status=%d errorReason=%d", info.getLocalVideoStreamStatus(), info.getLocalVideoStreamError());
                        }
                        if (mRtcEventHandler == null) break;
                        mRtcEventHandler.onLocalVideoStatusChanged(info.getLocalVideoStreamStatus(), info.getLocalVideoStreamError());
                        break;
                    }
                    case 45: {
                        ThunderNotification.ThunderDeviceStats info = (ThunderNotification.ThunderDeviceStats)msg.obj;
                        if (mRtcEventHandler == null) break;
                        ThunderEventHandler.DeviceStats stats = new ThunderEventHandler.DeviceStats();
                        stats.cpuTotalUsage = info.getCpuTotalUsage();
                        stats.cpuAppUsage = info.getCpuAppUsage();
                        stats.memoryAppUsage = info.getMemoryAppUsage();
                        stats.memoryTotalUsage = info.getMemoryTotalUsage();
                        ThunderLog.release("yrtc", "ThunderNotification.ThunderDeviceStats cpuTotalUsage=%f cpuAppUsage=%f memoryAppUsage=%f memoryTotalUsage=%f", stats.cpuTotalUsage, stats.cpuAppUsage, stats.memoryAppUsage, stats.memoryTotalUsage);
                        mRtcEventHandler.onDeviceStats(stats);
                        break;
                    }
                    case 47: {
                        ThunderNotification.ThunderAudioRouteChanged info = (ThunderNotification.ThunderAudioRouteChanged)msg.obj;
                        if (mRtcEventHandler == null) break;
                        ThunderLog.release("yrtc", "ThunderNotification.ThunderAudioRouteChanged Routing = %d", info.getRouting());
                        mRtcEventHandler.onAudioRouteChanged(info.getRouting());
                        break;
                    }
                    case 48: {
                        ThunderNotification.ThunderHowlingDetectResult info = (ThunderNotification.ThunderHowlingDetectResult)msg.obj;
                        if (mRtcEventHandler == null) break;
                        ThunderLog.release("yrtc", "ThunderNotification.ThunderHowlingDetectResult value = %b", info.getValue());
                        mRtcEventHandler.onHowlingDetectResult(info.getValue());
                        break;
                    }
                    case 49: {
                        ThunderNotification.ThunderEchoDetectResult info = (ThunderNotification.ThunderEchoDetectResult)msg.obj;
                        if (mRtcEventHandler == null) break;
                        ThunderLog.release("yrtc", "ThunderNotification.ThunderEchoDetectResult value = %b", info.getValue());
                        mRtcEventHandler.onEchoDetectResult(info.getValue());
                        break;
                    }
                    case 50: {
                        ThunderNotification.ThunderAudioInputDeviceTestVolume info = (ThunderNotification.ThunderAudioInputDeviceTestVolume)msg.obj;
                        if (mRtcEventHandler == null) break;
                        mRtcEventHandler.onAudioInputDeviceTestVolume(info.getVolume());
                        break;
                    }
                    case 51: {
                        ThunderNotification.ThunderAudioOutputDeviceTestVolume info = (ThunderNotification.ThunderAudioOutputDeviceTestVolume)msg.obj;
                        if (mRtcEventHandler == null) break;
                        mRtcEventHandler.onAudioOutputDeviceTestVolume(info.getVolume());
                        break;
                    }
                    case 53: {
                        ThunderNotification.ThunderVideoCaptureExposureChanged info = (ThunderNotification.ThunderVideoCaptureExposureChanged)msg.obj;
                        if (mRtcEventHandler == null) break;
                        ThunderLog.release("yrtc", "ThunderNotification.ThunderVideoCaptureExposureChanged posX = %d, poxY = %d, w = %d, h = %d", info.getPosX(), info.getPosY(), info.getWidth(), info.getHeight());
                        Rect rect = new Rect((float)info.getPosX(), (float)info.getPosY(), (float)(info.getPosX() + info.getWidth()), (float)(info.getPosY() - info.getHeight()));
                        mRtcEventHandler.onCameraExposureAreaChanged(rect);
                        break;
                    }
                    case 52: {
                        ThunderNotification.ThunderVideoCaptureFocusChanged info = (ThunderNotification.ThunderVideoCaptureFocusChanged)msg.obj;
                        if (mRtcEventHandler == null) break;
                        ThunderLog.release("yrtc", "ThunderNotification.ThunderVideoCaptureFocusChanged posX = %d, poxY = %d, w = %d, h = %d", info.getPosX(), info.getPosY(), info.getWidth(), info.getHeight());
                        Rect rect = new Rect((float)info.getPosX(), (float)info.getPosY(), (float)(info.getPosX() + info.getWidth()), (float)(info.getPosY() - info.getHeight()));
                        mRtcEventHandler.onCameraFocusAreaChanged(rect);
                        break;
                    }
                    case 54: {
                        ThunderNotification.ThunderPrivateCallBack info = (ThunderNotification.ThunderPrivateCallBack)msg.obj;
                        if (mRtcEventHandler == null) break;
                        if (ThunderLog.isInfoValid()) {
                            ThunderLog.info("yrtc", "ThunderNotification.PrivateCallBack key:%d jsonStr:%s", info.getmKey(), info.getmJsonStr());
                        }
                        mRtcEventHandler.onParamsCallback(info.getmKey(), info.getmJsonStr());
                        break;
                    }
                    case 55: {
                        ThunderNotification.ThunderAudioRecordState info = (ThunderNotification.ThunderAudioRecordState)msg.obj;
                        if (mRtcEventHandler == null) break;
                        mRtcEventHandler.onAudioRecordState(info.getErrorCode(), info.getDuration());
                        break;
                    }
                    case 56: {
                        ThunderNotification.ThunderLocalSpeakingState info = (ThunderNotification.ThunderLocalSpeakingState)msg.obj;
                        if (mRtcEventHandler == null) break;
                        mRtcEventHandler.onLocalSpeakingState(info.getState());
                        break;
                    }
                }
            }
            catch (Exception exc) {
                StringWriter errors = new StringWriter();
                exc.printStackTrace(new PrintWriter(errors));
                ThunderLog.error("yrtc", String.format("handleMessage err=%s", errors.toString()));
            }
        }
    }
}

