/*
 * Decompiled with CFR 0.152.
 */
package com.thunder.livesdk;

import com.thunder.livesdk.CustomTranscodingOptions;
import com.thunder.livesdk.TranscodingImage;
import com.thunder.livesdk.TranscodingText;
import com.thunder.livesdk.TranscodingTimestamp;
import java.util.ArrayList;
import java.util.Iterator;

public class LiveTranscoding {
    private int mTransCodingMode;
    private String mAudioUrl = "";
    private String mLyricUrl = "";
    private String mMediaUrl = "";
    private MediaStreamLayout mMediaStreamLayout;
    private ArrayList<TranscodingUser> mUserList = new ArrayList();
    private int mBackgroundColor = 0;
    private TranscodingImage mBackgroundImage;
    private TranscodingTimestamp mTimestamp;
    private CustomTranscodingOptions mTranscodingModeOptions;
    private ArrayList<TranscodingText> mTextList = new ArrayList();
    private ArrayList<TranscodingImage> mImageList = new ArrayList();

    public String getAudioUrl() {
        return this.mAudioUrl;
    }

    public String getLyricUrl() {
        return this.mLyricUrl;
    }

    public String getMediaUrl() {
        return this.mMediaUrl;
    }

    public MediaStreamLayout getMediaStreamLayout() {
        return this.mMediaStreamLayout;
    }

    public void setCustomTranscodingOptions(CustomTranscodingOptions options) {
        this.mTranscodingModeOptions = options;
    }

    public CustomTranscodingOptions getCustomTranscodingOptions() {
        return this.mTranscodingModeOptions;
    }

    public void setBackgroundColor(int color) {
        this.mBackgroundColor = color;
    }

    public int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public void setBackgroundImage(TranscodingImage image) {
        this.mBackgroundImage = image;
    }

    public TranscodingImage getBackgroundImage() {
        return this.mBackgroundImage;
    }

    public void setTimestamp(TranscodingTimestamp mTimestamp) {
        this.mTimestamp = mTimestamp;
    }

    public TranscodingTimestamp getTimestamp() {
        return this.mTimestamp;
    }

    public void addTexts(ArrayList<TranscodingText> texts) {
        this.mTextList.clear();
        if (texts.size() > 3) {
            this.mTextList.addAll(texts.subList(0, 2));
        } else {
            this.mTextList.addAll(texts);
        }
    }

    public int getTextCount() {
        return this.mTextList.size();
    }

    public final ArrayList<TranscodingText> getTexts() {
        return this.mTextList;
    }

    public void addImages(ArrayList<TranscodingImage> images) {
        this.mImageList.clear();
        if (images.size() > 4) {
            this.mImageList.addAll(images.subList(0, 3));
        } else {
            this.mImageList.addAll(images);
        }
    }

    public int getImageCount() {
        return this.mImageList.size();
    }

    public final ArrayList<TranscodingImage> getImages() {
        return this.mImageList;
    }

    public int addUser(TranscodingUser user) {
        if (this.mUserList != null) {
            this.mUserList.add(user);
        }
        return 0;
    }

    public void setUsers(ArrayList<TranscodingUser> users) {
        this.mUserList.clear();
        if (users != null) {
            this.mUserList.addAll(users);
        }
    }

    public final ArrayList<TranscodingUser> getUsers() {
        return this.mUserList;
    }

    public int removeUser(String uid) {
        Iterator<TranscodingUser> itor = this.mUserList.iterator();
        while (itor.hasNext()) {
            TranscodingUser tmp = itor.next();
            if (!uid.equals(tmp.uid)) continue;
            itor.remove();
        }
        return 0;
    }

    public int removeAllUser() {
        this.mUserList.clear();
        return 0;
    }

    public int getUserCount() {
        if (this.mUserList == null || this.mUserList.isEmpty()) {
            return 0;
        }
        return this.mUserList.size();
    }

    public void setTransCodingMode(int transCodingMode) {
        this.mTransCodingMode = transCodingMode;
    }

    public int getTransCodingMode() {
        return this.mTransCodingMode;
    }

    public final int setAudioOnlyStandardSreamUrl(String audioUrl, String lyricUrl) {
        this.mAudioUrl = audioUrl;
        this.mLyricUrl = lyricUrl;
        this.mMediaUrl = "";
        this.mMediaStreamLayout = null;
        return 0;
    }

    public final int setMediaStandardSream(String mediaUrl, MediaStreamLayout layout) {
        this.mMediaUrl = mediaUrl;
        this.mMediaStreamLayout = layout;
        this.mAudioUrl = "";
        this.mLyricUrl = "";
        return 0;
    }

    public static class MediaStreamLayout {
        public int layoutX = 0;
        public int layoutY = 0;
        public int layoutW = 0;
        public int layoutH = 0;
        public int zOrder = 0;
        public boolean bCrop = true;
        public int cropX = 0;
        public int cropY = 0;
        public int cropW = 0;
        public int cropH = 0;
        public float alpha = 0.0f;

        public boolean equals(Object obj) {
            if (!(obj instanceof MediaStreamLayout)) {
                return false;
            }
            MediaStreamLayout p = (MediaStreamLayout)obj;
            return this.layoutX == p.layoutX && this.layoutY == p.layoutY;
        }

        public int hashCode() {
            String hash = String.valueOf(this.layoutX + this.layoutY + this.layoutW + this.layoutH);
            return hash.hashCode();
        }
    }

    public static class TranscodingUser {
        public String uid = "";
        public String roomId = "";
        public boolean bStandard = false;
        public int layoutX = 0;
        public int layoutY = 0;
        public int layoutW = 0;
        public int layoutH = 0;
        public int zOrder = 0;
        public boolean bCrop = false;
        public int cropX = 0;
        public int cropY = 0;
        public int cropW = 0;
        public int cropH = 0;
        public float alpha = 1.0f;
        public int audioRoom = 0;

        public boolean equals(Object obj) {
            if (!(obj instanceof TranscodingUser)) {
                return false;
            }
            TranscodingUser p = (TranscodingUser)obj;
            return this.uid.equals(p.uid) && this.roomId.equals(p.roomId);
        }

        public int hashCode() {
            String hash = this.uid + this.roomId;
            return hash.hashCode();
        }

        public String toString() {
            return "{TranscodingUser: uid " + this.uid + ", roomId " + this.roomId + ", bStandard " + this.bStandard + ", x " + this.layoutX + ", y " + this.layoutY + ", w " + this.layoutW + ", h " + this.layoutH + ", zOrder " + this.zOrder + ", bCrop " + this.bCrop + ", cropX " + this.cropX + ", cropY " + this.cropY + ", cropW " + this.cropW + ", cropH " + this.cropH + ", alpha " + this.alpha + ", audioRoom " + this.audioRoom + "}";
        }
    }
}

