/*
 * Decompiled with CFR 0.152.
 */
package com.jobase;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.jobase.TlsOnlySocketFactory;
import com.jobase.TlsSniSocketFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class JobaseNative {
    private static final String TAG = "JobaseNative";
    private static final int eHttpGet = 0;
    private static final int eHttpPost = 1;
    private static final String ARGO_HOST = "argoapi.jocloud.com";
    private static final String ARGO_HOST_IPV6 = "argoapi-ipv6.jocloud.com";
    private static final String HTTPDNS_SERVER_HOST = "httpdns.gslb.yy.com";
    private static final TrustManager[] TRUSTALLCERTS = new TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        @SuppressLint(value={"TrustAllX509TrustManager"})
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        @SuppressLint(value={"TrustAllX509TrustManager"})
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }
    }};
    private static final HostnameVerifier DO_NOT_VERIFY = new HostnameVerifier(){

        @Override
        @SuppressLint(value={"BadHostnameVerifier"})
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };
    private static final int ATOMICINTEGER = 1;
    private static final int THREADSIZE = 5;
    private static ExecutorService cachedThreadPool;

    public static void executeHttp(Context context, final int method, final String traceId, final String urlString, final Map<String, String> headers, final String content) {
        JobaseNative.getCachedThreadPool().execute(new Runnable(){

            @Override
            public void run() {
                boolean useHttps = urlString.startsWith("https");
                String strUrl = urlString;
                if (useHttps && Build.VERSION.SDK_INT < 17) {
                    strUrl = urlString.replaceFirst("https", "http");
                    useHttps = false;
                }
                InnerHttpResponse resp = new InnerHttpResponse();
                if (useHttps) {
                    JobaseNative.openTlsHttpsConnection(method, traceId, strUrl, headers, content, resp);
                } else {
                    JobaseNative.openHttpConnection(method, traceId, strUrl, headers, content, resp);
                }
                Log.i((String)JobaseNative.TAG, (String)("url " + strUrl + ", resp code " + resp.code + ", size " + resp.content.length()));
                final int responseCode = resp.code;
                final String respContent = resp.content;
                Handler mainHandler = new Handler(Looper.getMainLooper());
                mainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        JobaseNative.httpCallback(traceId, responseCode, respContent);
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void openHttpConnection(int method, String traceId, String urlString, Map<String, String> headers, String content, InnerHttpResponse resp) {
        HttpURLConnection conn = null;
        try {
            URL url = new URL(urlString);
            conn = (HttpURLConnection)url.openConnection();
            if (0 == method) {
                conn.setRequestMethod("GET");
            } else if (1 == method) {
                conn.setRequestMethod("POST");
            } else {
                Log.i((String)TAG, (String)("executeHttp method " + method + " not supported"));
                return;
            }
            conn.setReadTimeout(6000);
            conn.setConnectTimeout(10000);
            conn.setDoOutput(true);
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                String mapKey = entry.getKey();
                String mapValue = entry.getValue();
                conn.setRequestProperty(mapKey, mapValue);
            }
            OutputStream out = conn.getOutputStream();
            out.write(content.getBytes());
            out.flush();
            out.close();
            resp.code = conn.getResponseCode();
            resp.content = JobaseNative.getStringFromInputStream(conn.getInputStream());
            Log.i((String)TAG, (String)("openHttpConnection code " + resp.code + " response " + resp.content));
        }
        catch (Throwable t) {
            String message = t.getMessage();
            if (message == null) {
                message = "Unknown HTTP exception";
            }
            resp.code = -1000;
            resp.content = message;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void openTlsHttpsConnectionNotVerify(int method, String traceId, String urlString, Map<String, String> headers, String content, InnerHttpResponse resp) {
        HttpURLConnection conn = null;
        try {
            URL url = new URL(urlString);
            conn = (HttpURLConnection)url.openConnection();
            HttpsURLConnection https = (HttpsURLConnection)conn;
            JobaseNative.trustAllHosts(https);
            https.setHostnameVerifier(DO_NOT_VERIFY);
            if (0 == method) {
                conn.setRequestMethod("GET");
            } else if (1 == method) {
                conn.setRequestMethod("POST");
            } else {
                Log.i((String)TAG, (String)("executeHttp method " + method + " not supported"));
                return;
            }
            conn.setReadTimeout(6000);
            conn.setConnectTimeout(10000);
            conn.setDoOutput(true);
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                String mapKey = entry.getKey();
                String mapValue = entry.getValue();
                conn.setRequestProperty(mapKey, mapValue);
            }
            OutputStream out = conn.getOutputStream();
            out.write(content.getBytes());
            out.flush();
            out.close();
            resp.code = conn.getResponseCode();
            resp.content = JobaseNative.getStringFromInputStream(conn.getInputStream());
        }
        catch (Throwable t) {
            String message = t.getMessage();
            if (message == null) {
                message = "Unknown HTTP exception";
            }
            resp.code = -1000;
            resp.content = message;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void openTlsHttpsConnection(int method, String traceId, String urlString, Map<String, String> headers, String content, InnerHttpResponse resp) {
        HttpURLConnection conn = null;
        try {
            URL url = new URL(urlString);
            conn = (HttpsURLConnection)url.openConnection();
            if (0 == method) {
                conn.setRequestMethod("GET");
            } else if (1 == method) {
                conn.setRequestMethod("POST");
            } else {
                Log.i((String)TAG, (String)("executeHttp method " + method + " not supported"));
                return;
            }
            conn.setReadTimeout(6000);
            conn.setConnectTimeout(10000);
            conn.setDoOutput(true);
            String hostAttr = "";
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                String mapKey = entry.getKey();
                String mapValue = entry.getValue();
                conn.setRequestProperty(mapKey, mapValue);
                if (!mapKey.equals("Host")) continue;
                hostAttr = mapValue;
            }
            conn.setRequestProperty("Host", hostAttr);
            ((HttpsURLConnection)conn).setSSLSocketFactory(new TlsOnlySocketFactory());
            conn.setRequestProperty("Connection", "Close");
            ((HttpsURLConnection)conn).setHostnameVerifier(new TlsSniSocketFactory.HostnameVerifierEx((HttpsURLConnection)conn){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    String hostVerify = this.mConn.getRequestProperty("Host");
                    if (null == hostVerify) {
                        hostVerify = this.mConn.getURL().getHost();
                    }
                    if (!hostVerify.isEmpty() && (hostVerify.equals(JobaseNative.ARGO_HOST) || hostVerify.equals(JobaseNative.ARGO_HOST_IPV6) || hostVerify.equals(JobaseNative.HTTPDNS_SERVER_HOST))) {
                        return true;
                    }
                    Log.i((String)JobaseNative.TAG, (String)("host " + (hostVerify.isEmpty() ? "null" : hostVerify) + " not in verify list"));
                    return false;
                }
            });
            conn.setDoInput(true);
            OutputStream out = conn.getOutputStream();
            out.write(content.getBytes("UTF-8"));
            out.flush();
            out.close();
            resp.code = conn.getResponseCode();
            resp.content = JobaseNative.getStringFromInputStream(conn.getInputStream());
        }
        catch (Throwable t) {
            String message = t.getMessage();
            if (message == null) {
                message = "Unknown HTTP exception";
            }
            resp.code = -1000;
            resp.content = message;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private static void trustAllHosts(HttpsURLConnection connection) {
        SSLSocketFactory oldFactory = connection.getSSLSocketFactory();
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, TRUSTALLCERTS, new SecureRandom());
            SSLSocketFactory newFactory = sc.getSocketFactory();
            connection.setSSLSocketFactory(newFactory);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getStringFromInputStream(InputStream is) throws IOException {
        int len;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = is.read(buffer)) != -1) {
            os.write(buffer, 0, len);
        }
        is.close();
        String state = os.toString();
        os.close();
        return state;
    }

    private static ExecutorService getCachedThreadPool() {
        if (cachedThreadPool == null) {
            DefaultThreadFactory namedThreadFactory = new DefaultThreadFactory(5, "jobase-pool-d-");
            cachedThreadPool = new ThreadPoolExecutor(5, 5, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), namedThreadFactory);
        }
        return cachedThreadPool;
    }

    private static native void httpCallback(String var0, int var1, String var2);

    private static class DefaultThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger POOLNUMBER = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;
        private final int threadPriority;

        DefaultThreadFactory(int threadPriority, String threadNamePrefix) {
            this.threadPriority = threadPriority;
            this.group = Thread.currentThread().getThreadGroup();
            this.namePrefix = threadNamePrefix + POOLNUMBER.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            t.setPriority(this.threadPriority);
            return t;
        }
    }

    private static class InnerHttpResponse {
        public int code = 0;
        public String content = "";

        public String toString() {
            return "{InnerHttpResponse code " + this.code + ", resp " + this.content + "}";
        }
    }
}

