package com.thunder.livesdk.video;

import android.content.Context;
import android.util.AttributeSet;
import android.view.SurfaceView;
import android.view.View;
import android.widget.FrameLayout;

import com.thunder.livesdk.ThunderRtcConstant;
import com.thunder.livesdk.log.ThunderLog;
import com.yy.videoplayer.decoder.VideoConstant;

import static com.yy.videoplayer.decoder.VideoConstant.ViewType.SURFACE_VIDEO_VIEW;

public abstract class VideoPlayerView extends FrameLayout {

    protected VideoConstant.ViewType mViewType;
    protected View mUniformView = null;
    protected long mStreamId = 0;
    protected int mViewWidth = 0;
    protected int mViewHeight = 0;
    public boolean mPrepared = false;
    protected VideoConstant.ScaleMode mScaleMode = VideoConstant.ScaleMode.AspectFit;
    protected VideoConstant.MirrorMode mMirrorMode = VideoConstant.MirrorMode.Disabled;

    public VideoPlayerView(Context context) {
        super(context);
        addView(new SurfaceView(context));           //防止一开始进入频道的闪烁
    }

    public VideoPlayerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        addView(new SurfaceView(context));           //防止一开始进入频道的闪烁
    }

    public VideoPlayerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        addView(new SurfaceView(context));           //防止一开始进入频道的闪烁
    }

    public int getViewType() {
        if (mViewType == SURFACE_VIDEO_VIEW) {
            return 1;
        } else {
            return 0;
        }
    }

    public View getView() {
        return mUniformView;
    }

    public View getYspVideoView() {
        return mUniformView;
    }

    public boolean isPrepared() {
        return mPrepared;
    }

    protected VideoConstant.ScaleMode scaleModeConvert(int scaleMode) {
        switch (scaleMode) {
            case ThunderRtcConstant.ThunderVideoRenderMode.THUNDER_RENDER_MODE_FILL:
                return VideoConstant.ScaleMode.FillParent;
            case ThunderRtcConstant.ThunderVideoRenderMode.THUNDER_RENDER_MODE_ASPECT_FIT:
                return VideoConstant.ScaleMode.AspectFit;
            case ThunderRtcConstant.ThunderVideoRenderMode.THUNDER_RENDER_MODE_CLIP_TO_BOUNDS:
                return VideoConstant.ScaleMode.ClipToBounds;
            case ThunderRtcConstant.ThunderVideoRenderMode.THUNDER_RENDER_MODE_ORIGINAL:
                return VideoConstant.ScaleMode.Original;
            default:
                ThunderLog.warn(ThunderLog.kLogTagVideo, "invalid scale mode %d", scaleMode);
        }
        return VideoConstant.ScaleMode.AspectFit;
    }

    protected VideoConstant.MirrorMode mirrorModeConvert(int mirrorMode) {
        switch (mirrorMode) {
            case ThunderRtcConstant.ThunderRemoteMirrorMode.THUNDER_REMOTE_MIRROR_MODE_DISABLED:
                return VideoConstant.MirrorMode.Disabled;
            case ThunderRtcConstant.ThunderRemoteMirrorMode.THUNDER_REMOTE_MIRROR_MODE_ENABLED:
                return VideoConstant.MirrorMode.Enabled;
            default:
                ThunderLog.warn(ThunderLog.kLogTagVideo, "invalid mirror mode %d", mirrorMode);
        }
        return VideoConstant.MirrorMode.Disabled;
    }



    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        mViewWidth = w;
        mViewHeight = h;

    }

    abstract boolean prepareView();
    abstract void unPrepareView();
}
