package com.thunder.livesdk.video;

import android.hardware.Camera;

import com.yy.mediaframework.facedetection.PreviewFrameCallback;
import com.thunder.livesdk.ThunderBridgeLib;

/*
 * camera yuv（NV21）数据回调给业务
 */

public class VideoFrameYuvCapture implements PreviewFrameCallback {

    private IVideoCaptureObserver mVideoCaptureFrameObserver = null;
    private static volatile VideoFrameYuvCapture instance;
    private static Object syncLock = new Object();

    public static VideoFrameYuvCapture getInstance() {
        if (instance == null) {
            synchronized (syncLock) {
                if (instance == null) {
                    instance = new VideoFrameYuvCapture();
                }
            }
        }
        return instance;
    }

    private VideoFrameYuvCapture() {
    }


    public void enableVideoCapture(IVideoCaptureObserver observer) {
        if (observer != null) {
            mVideoCaptureFrameObserver = observer;
            ThunderBridgeLib.getInstance().addPreviewFrameCallback(this);
        } else {
            ThunderBridgeLib.getInstance().removePreviewFrameCallback(this);
            mVideoCaptureFrameObserver = null;
        }
    }


    @Override
    public void onPreviewFrameAvailable(int imageFormat, byte[] data, int width, int height, Camera camera) {

        if (mVideoCaptureFrameObserver == null) {
            return;
        }
        mVideoCaptureFrameObserver.onCaptureVideoFrame(width, height, data, data.length, imageFormat);
    }
}
