package com.thunder.livesdk.video;

import android.content.Context;

import com.yy.videoplayer.IVideoLibInfoExt;
import com.yy.videoplayer.VideoDecodeEventNotify;
import com.yy.videoplayer.VideoRenderNotify;
import com.yy.videoplayer.IVideoInfoCallback;

import java.util.ArrayList;
import java.util.Map;

/**
 * Created by xiaojun on 2018/1/5.
 * Copyright (c) 2017 YY Inc. All rights reserved.
 */

public class ThunderVideoPlayListener implements IVideoLibInfoExt, IVideoInfoCallback {
    private Context mAppContext = null;
    private IThunderVideoPlay mVideoPlayEngine = null;

    public ThunderVideoPlayListener(Context appContext, IThunderVideoPlay videoEngine) {
        mAppContext = appContext;
        mVideoPlayEngine = videoEngine;
    }
    @Override
    public void onViewStateNotify(long streamId, int viewState) {
        mVideoPlayEngine.onViewStateNotify(streamId, viewState);
    }

    @Override
    public long getUid() {
        return 0;
    }

    @Override
    public long getTopSid() {
        return 0;
    }

    @Override
    public long getSubSid() {
        return 0;
    }

    @Override
    public String getPackageName() {
        return mAppContext.getPackageName();
    }

    @Override
    public boolean isLibraryLoaded() {
        return true;
    }

    @Override
    public int getConfig(int configKey) {
        return 0;
    }

    @Override
    public void setConfigs(int appId, Map<Integer, Integer> configs) {
    }

    @Override
    public void notifyHardwareCodecConfigured(boolean h264DecodeOn,
                                              boolean h264EncodeOn,
                                              boolean h265DecodeOn,
                                              boolean h265EncodeOn) {
    }

    @Override
    public void onCoefficientOfVariationOfRenderInterval(long userGroupId,
                                                         long streamId,
                                                         long intervalMilliTs,
                                                         double coef) {
    }

    @Override
    public void onViewPlayEventNotify(long userGroupId,
                                      long streamId,
                                      int eventType,
                                      long happenTime) {
    }

    @Override
    public void onVideoRenderNotify(final ArrayList<VideoRenderNotify> notifys) {

        mVideoPlayEngine.onVideoRenderNotify(notifys);

    }

    @Override
    public void onFirstFrameDecodeNotify(final long streamId,final long pts,final long happenTime) {
        mVideoPlayEngine.onFirstFrameDecodeNotify(streamId, pts, happenTime);
    }

    @Override
    public void onFirstFrameRenderNotify(long userGroupId,
                                         long streamId,
                                         long currentSystemMilliSecond,
                                         long firstFrameToRenderInMilliSec,
                                         int eatenFrames) {

    }

    @Override
    public void onUpdatePts(long streamId, long pts) {

    }

    @Override
    public void onUpdateVideoSizeChanged(long streamId, int width, int height) {
        // 观看端在创建解码器的时候回调一次，在渲染第一帧的时候不需要回调，不然会触发2次
        // mVideoPlayEngine.onUpdateVideoSizeChanged(streamId, width, height);
    }



    @Override
    public Context HWCodecConfigGetmCtx() {
        return mAppContext;
    }

    @Override
    public void HWCodecConfigSetRunTimeStamp(String key, long ts) {
    }

    @Override
    public boolean HWCodecConfigGetIsRooted() {
        return ThunderVideoConfig.isRooted();
    }

    @Override
    public void onFirstFrameSeeNotify(long streamId, long pts, int w, int h) {
        mVideoPlayEngine.onFirstFrameRenderNotify(streamId, w, h, pts);
    }

    @Override
    public void onHardwareDecodeErrorNotify(long userGroupId, long streamId, int errorType) {
        mVideoPlayEngine.onHardwareDecodeErrorNotify(userGroupId, streamId, errorType);
    }

    @Override
    public void onHardwareDecodeWrongFrameNotify(long streamId, String name, byte[] header, byte[] data) {

    }

    @Override
    public void onDecodedFrameData(long streamId, int w, int h, byte[] data, int dateLen, long renderTimeMs) {
        mVideoPlayEngine.onDecodedFrameData(streamId, w, h, data, dateLen, renderTimeMs);
    }
    @Override
    public void onDecodeEventNotify(VideoDecodeEventNotify notify) {
        mVideoPlayEngine.onVideoDecodeNotify(notify);
    }
}