package com.thunder.livesdk.video;

/* Multiplayer set up layout
 * As follows, ThunderMultiVideoViewCoordinate indicates that the outline is the overall video layout, and Video is the single video layout area
 *
 * |---------------------------------------------|
 * | (0,0)                                       |
 * |                                             |
 * |                             (x,y)         |
 * |                               |---width---| |
 * |                               |           | |
 * |                        height |           | |
 * |                               | Video     | |
 * |                               |           | |
 * |                               |-----------| |
 * |---------------------------------------------|
 */

public class ThunderMultiVideoViewCoordinate {

    public int mIndex = 0; // Seat No. of the single video/view layout, starting from 0
    public int mX = 0; // X coordinate at upper left corner of the single video/view layout
    public int mY = 0; // Y coordinate at upper left corner of the single video/view layout
    public int mWidth = 0; // Width of the single video/view layout
    public int mHeight = 0; // Height of the single video/view layout
}
