package com.thunder.livesdk.video;

import com.thunder.livesdk.log.ThunderLog;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by Administrator on 2017/7/19.
 */

public class CpuTool {
    private final static String kCpuInfoMaxFreqFilePath = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq";
    private final static String TAG = "CPUTool";
    public final static String OS_VERSION = android.os.Build.VERSION.RELEASE;
    public static final String[] TOP = {"/system/bin/top", "-d", "1", "-m", "6"};
    public static int mTopPeriod = 9; // 1次20s
    public static final int HZ = 100;
    public static int count = 0;
    public static int mRefDeviceJiffies = 0;
    public static int mAppCpuRate = 0;
    public static int mDeviceCpuRate = 0;

    public static int selfProcessPid = android.os.Process.myPid();
    public static int maxCpuFreq = 0;
    public static int minCpuFreq = 0;
    private static int mHiidoAppCpuRate = -1;
    private static List<Integer> mHiidoAppCpuRateList = new ArrayList<>();

    public static class CpuUpTimeInfo {
        public double lastActiveTime = 0;
        public double curActiveTime = 0;
        public double deltaActiveTime = 0;

        public double lastIdleTime = 0;
        public double curIdleTime = 0;
        public double deltaIdleTime = 0;

        public long lastTimeCount = 0;
        public long curTimeCount = 0;
        public long deltaTimeCount = 0;

        public CpuUpTimeInfo() {
            reset();
        }

        public void reset() {
            lastActiveTime = 0;
            curActiveTime = 0;
            deltaActiveTime = 0;

            lastIdleTime = 0;
            curIdleTime = 0;
            deltaIdleTime = 0;

            mHiidoAppCpuRate = -1;
            mHiidoAppCpuRateList.clear();
        }

        public boolean isInit() {
            return lastActiveTime != 0;
        }
    }

    public static class JiffiesCount {
        public long lastJiffies = 0;
        public long curJiffies = 0;
        public long deltaJiffies = 0;

        public long lastTimeCount = 0;
        public long curTimeCount = 0;
        public long deltaTimeCount = 0;

        public JiffiesCount() {
            reset();
        }

        public void reset() {
            lastJiffies = 0;
            curJiffies = 0;
            deltaJiffies = 0;
        }

        public boolean isInit() {
            return lastJiffies == 0;
        }
    }

    private static CpuUpTimeInfo mCpuUpTimeInfo = new CpuUpTimeInfo();
    private static JiffiesCount mJiffiesCount = new JiffiesCount();
    private static JiffiesCount mJiffiesTopCount = new JiffiesCount();
    public static int mCpuCores = getCpuCores();

    public static String getKernelVersion() {
        return System.getProperty("os.version");
    }

    public static int getCpuCores() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static synchronized int getHiidoAppCpuRate() {
        return mHiidoAppCpuRate;
    }

    public static synchronized double getAppCpuRateAverage() {
        double AppCpuRateAverage = 0;
        //没有读到cpu占比时,getAppCpuRate()返回app使用cpu的时间取负值，区分cpu利用率
        int rate = getAppCpuRate(15);
        if (rate <= 0) {
            mHiidoAppCpuRateList.add(rate);
            if (mHiidoAppCpuRateList.size() > 10) {
                int sum = 0;
                for (int value : mHiidoAppCpuRateList) {
                    sum += value;
                }
                mHiidoAppCpuRate = sum / mHiidoAppCpuRateList.size();
                mHiidoAppCpuRateList.clear();
            }
        } else {
            mHiidoAppCpuRate = rate > 100 ? 100 : rate;
        }

        if (rate < 0) {
            AppCpuRateAverage = 0;
        } else {
            AppCpuRateAverage = (double) rate / mCpuCores;
        }
        return AppCpuRateAverage;
    }

    public static synchronized int getAppCpuRate(int topPeriod) {
        if (topPeriod > 0 && topPeriod != mTopPeriod) {
            mTopPeriod = topPeriod;
        }
        long deltaJiffiesPerSecond = 0;
        if (mJiffiesCount.isInit()) {
            mJiffiesCount.lastJiffies = getCurrentCpuJiffies();
            mJiffiesCount.lastTimeCount = System.currentTimeMillis();
            return 0;
        }
        mJiffiesCount.curJiffies = getCurrentCpuJiffies();
        mJiffiesCount.deltaJiffies = mJiffiesCount.curJiffies - mJiffiesCount.lastJiffies;
        mJiffiesCount.lastJiffies = mJiffiesCount.curJiffies;

        if (mJiffiesCount.deltaJiffies == 0) {
if (ThunderLog.isInfoValid()) {
            ThunderLog.info(TAG, "appCpu deltaJiffiesPerSecond: " + deltaJiffiesPerSecond +
                    " mJiffiesCount.curJiffies: " + mJiffiesCount.curJiffies +
                    " lastJiffies: " + mJiffiesCount.lastJiffies);
}
        }
        mJiffiesCount.curTimeCount = System.currentTimeMillis();
        mJiffiesCount.deltaTimeCount = mJiffiesCount.curTimeCount - mJiffiesCount.lastTimeCount;
        mJiffiesCount.lastTimeCount = mJiffiesCount.curTimeCount;
        if (mJiffiesCount.deltaTimeCount != 0) {
            deltaJiffiesPerSecond = mJiffiesCount.deltaJiffies * 1000 / mJiffiesCount.deltaTimeCount;
if (ThunderLog.isInfoValid()) {
            ThunderLog.info(TAG, "appCpu deltaJiffiesPerSecond: " + deltaJiffiesPerSecond);
}

            long referJiffies = getReferDeviceJiffies();
            if (referJiffies != 0) {
                int cpuRate =
                        (int) (((deltaJiffiesPerSecond * 100 * mJiffiesTopCount.deltaTimeCount) / referJiffies) / 1000);
if (ThunderLog.isInfoValid()) {
                ThunderLog.info(TAG,
                        "refJiffies by top:" + referJiffies + " cpuRate " + cpuRate);
}
                return cpuRate;
            }
            return (int) -deltaJiffiesPerSecond; // 没有读到cpu占比时返回app使用cpu的时间取负值，区分cpu利用率
        }

        return 0;
    }

    public static int getDeviceCpuRate() {
        return mDeviceCpuRate;
    }

    public static int getDeviceCpuRateByUptime() {
        double deltaCpuUptimeRate = 0;
        if (!mCpuUpTimeInfo.isInit()) {
            float[] cpuUptime = getCpuUpTimeInfo();
            if (cpuUptime != null) {
                mCpuUpTimeInfo.lastActiveTime = cpuUptime[0];
                mCpuUpTimeInfo.lastIdleTime = cpuUptime[1];
                mCpuUpTimeInfo.lastTimeCount = System.currentTimeMillis();
            }
            return 0;
        }
        float[] cpuUptime = getCpuUpTimeInfo();
        if (cpuUptime != null && cpuUptime.length == 2) {
            mCpuUpTimeInfo.curActiveTime = cpuUptime[0];
            mCpuUpTimeInfo.deltaActiveTime = mCpuUpTimeInfo.curActiveTime - mCpuUpTimeInfo.lastActiveTime;
            mCpuUpTimeInfo.lastActiveTime = mCpuUpTimeInfo.curActiveTime;

            mCpuUpTimeInfo.curIdleTime = cpuUptime[1];
            mCpuUpTimeInfo.deltaIdleTime = mCpuUpTimeInfo.curIdleTime - mCpuUpTimeInfo.lastIdleTime;
            mCpuUpTimeInfo.lastIdleTime = mCpuUpTimeInfo.curIdleTime;
        }
        if (cpuUptime != null && mCpuUpTimeInfo.deltaActiveTime != 0 && mCpuCores != 0) {
if (ThunderLog.isInfoValid()) {
            ThunderLog.info(TAG,
                    "deltaIdleTime:" + mCpuUpTimeInfo.deltaIdleTime + " deltaActiveTime " +
                            mCpuUpTimeInfo.deltaActiveTime + " mCpuCores " + mCpuCores);
}
            deltaCpuUptimeRate = 1 - mCpuUpTimeInfo.deltaIdleTime / (mCpuUpTimeInfo.deltaActiveTime * mCpuCores);
            ThunderLog.release(TAG, "deviceCpuRate:" + (100 * deltaCpuUptimeRate));
            return (int) (100 * deltaCpuUptimeRate);
        }
        return 0;
    }

    private static long getReferDeviceJiffies() {
        mJiffiesTopCount.lastJiffies = getCurrentCpuJiffies();
        mJiffiesTopCount.lastTimeCount = System.currentTimeMillis();
        int[] cpuRate = getCpuRateByTop();
        if (cpuRate != null && cpuRate[0] != 0) {
            mJiffiesTopCount.curJiffies = getCurrentCpuJiffies();
            mJiffiesTopCount.curTimeCount = System.currentTimeMillis();
            mJiffiesTopCount.deltaJiffies = mJiffiesTopCount.curJiffies - mJiffiesTopCount.lastJiffies;
            mJiffiesTopCount.deltaTimeCount = mJiffiesTopCount.curTimeCount - mJiffiesTopCount.lastTimeCount;
            mRefDeviceJiffies = (int) (100 * mJiffiesTopCount.deltaJiffies / cpuRate[0]);
if (ThunderLog.isInfoValid()) {
            ThunderLog.info(TAG,
                    "top cpu device jiffies:" + mRefDeviceJiffies + " mJiffiesTopCount.deltaJiffies:"
                            + mJiffiesTopCount.deltaJiffies + " top:" + cpuRate);
}
            return mRefDeviceJiffies;
        }
        return mRefDeviceJiffies;
    }

    public static int[] getCpuRateByTop() {
        //仅android8.0以上才需要
        String cpuRate[] = null;
        int[] cpuRateData = new int[2];
        int deviceCpu = 0;
        if (OS_VERSION.compareTo("8.0") >= 0) {
            if (count == 0) {
                cpuRate = getCpuRateByRunTop(selfProcessPid);
if (ThunderLog.isInfoValid()) {
                ThunderLog.info(TAG, "appCpuRate:" + cpuRate[0] + "deviceCpuRate" + cpuRate[1]);
}
                if (cpuRate != null) {
                    try {
                        cpuRateData[0] = (int) Float.parseFloat(cpuRate[0]);
                        mAppCpuRate = cpuRateData[0];
                        cpuRateData[1] = (int) Float.parseFloat(cpuRate[1]);
                        mDeviceCpuRate = cpuRateData[1];
                    } catch (Exception e) {
                        ThunderLog.error(TAG, "Exception " + e);
                    }

                    ThunderLog.error(TAG,
                            "getAppRateByTop appCpuRate:" + mAppCpuRate + " deviceCpuRate " + mDeviceCpuRate);
                }
            }
            if (count == mTopPeriod - 1) {
                count = 0;
            } else {
                count++;
            }
        }
        return cpuRateData;
    }

    public static long getCurrentCpuJiffies() {
        FileReader fr = null;
        BufferedReader localBufferReader = null;
        File file = null;
        int pid = android.os.Process.myPid();
        String cpuPath = "/proc/" + pid + "/stat";
        String cpuProcessInfo = "";
        String[] result = new String[3];
        long curJiffies = 0;

        file = new File(cpuPath);
        if (!file.exists() || !file.canRead()) {// || !file.canRead()
            ThunderLog.error(TAG, "file not exist or have not permission:" + cpuPath);
            return 0;
        }

        try {
            fr = new FileReader(file);
            localBufferReader = new BufferedReader(fr);
            cpuProcessInfo = localBufferReader.readLine();
            if (cpuProcessInfo != null) {
                String[] cpuSpilt = cpuProcessInfo.split(" ");
                if (cpuSpilt != null) {
                    result[0] = cpuSpilt[1];
                    result[1] = cpuSpilt[13];
                    result[2] = cpuSpilt[14];
                    long userSpaceTime = Long.parseLong(result[1]);
                    long kernelSpaceTime = Long.parseLong(result[2]);
                    curJiffies = userSpaceTime + kernelSpaceTime;
                }
            }
        } catch (IOException e) {
            ThunderLog.error(TAG, "exception: " + e);
        }
        if (localBufferReader != null) {
            try {
                localBufferReader.close();
            } catch (IOException e) {
                ThunderLog.error(TAG, "exception: " + e);
            }
        }
        return curJiffies;
    }


    public static float[] getCpuUpTimeInfo() {
        FileReader fr = null;
        BufferedReader localBufferReader = null;
        File file = null;
        String cpuPath = "/proc/uptime";
        String cpuProcessInfo = "";
        float[] result = new float[2];
        long curJiffies = 0;

        file = new File(cpuPath);
        if (!file.exists() || !file.canRead()) {
            return null;
        }

        try {
            fr = new FileReader(file);
            localBufferReader = new BufferedReader(fr);
            cpuProcessInfo = localBufferReader.readLine();
            if (cpuProcessInfo != null) {
                String[] cpuSpilt = cpuProcessInfo.split(" ");
                if (cpuSpilt != null) {
                    result[0] = Float.parseFloat(cpuSpilt[0]);
                    result[1] = Float.parseFloat(cpuSpilt[1]);
                }
            }
        } catch (IOException e) {
            ThunderLog.error(TAG, "exception: " + e);
        }
        if (localBufferReader != null) {
            try {
                localBufferReader.close();
            } catch (IOException e) {
                ThunderLog.error(TAG, "exception: " + e);
            }
        }
        return result;
    }

    public static int getMaxCpuFreqInfo() {
        int result = 0;
        File file = null;
        FileReader fr = null;
        BufferedReader br = null;
        try {
            file = new File(kCpuInfoMaxFreqFilePath);
            if (file != null && file.exists()) {
                fr = new FileReader(kCpuInfoMaxFreqFilePath);
                br = new BufferedReader(fr);
                String text = br.readLine();
                if (text != null && !text.isEmpty()) {
                    result = Integer.parseInt(text.trim());
                }
            }
        } catch (FileNotFoundException e) {
            ThunderLog.error(TAG, "Exception: " + e.toString());
        } catch (IOException e) {
            ThunderLog.error(TAG, "Exception: " + e.toString());
        } finally {
            if (fr != null) {
                try {
                    fr.close();
                } catch (IOException e) {
                    // TODO Auto-generated catch block
                    ThunderLog.error(TAG, "Exception: " + e.toString());
                }
            }
            if (br != null) {
                try {
                    br.close();
                } catch (IOException e) {
                    // TODO Auto-generated catch block
                    ThunderLog.error(TAG, "Exception: " + e.toString());
                }
            }
        }

        return result;
    }

    public static String getCurrentProcessCpuAffinity() {
        FileReader fr = null;
        BufferedReader localBufferReader = null;
        File file = null;
        int pid = android.os.Process.myPid();
        String cpuPath = "/proc/" + pid + "/stat";
        String cpuProcessInfo = "";
        String result = null;

        file = new File(cpuPath);
        if (!file.exists() || !file.canRead()) {
            ThunderLog.error(TAG, "file not exist or have not permission");
            return result;
        }

        try {
            fr = new FileReader(file);
            localBufferReader = new BufferedReader(fr);
            cpuProcessInfo = localBufferReader.readLine();
            if (cpuProcessInfo != null) {
                String[] cpuSpilt = cpuProcessInfo.split(" ");
                //ThunderLog.release(TAG, "getKernelVersion:"+getKernelVersion() + "cpuProcessInfo:"+cpuProcessInfo);
                if (getKernelVersion().compareTo("2.8.8") <= 0) {
                    if (cpuSpilt.length < 3) {
                        return result;
                    }
                    result = cpuSpilt[cpuSpilt.length - 3];
                } else {
                    if (cpuSpilt.length < 14) {
                        return result;
                    }
                    result = cpuSpilt[cpuSpilt.length - 15];
                    //ThunderLog.release(TAG, "getKernelVersion:"+getKernelVersion() + "result:"+result);
                }
            }
        } catch (IOException e) {
            ThunderLog.error(TAG, "exception: " + e);
        }
        if (localBufferReader != null) {
            try {
                localBufferReader.close();
            } catch (IOException e) {
                ThunderLog.error(TAG, "exception: " + e);
            }
        }
        return result;
    }

    private final static String kCpuInfoMinFreqFilePath = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_min_freq";

    public static int getMinCpuFreq() {
        if (minCpuFreq == 0) {
            minCpuFreq = getMinCpuFreqInfo();
        }
        return minCpuFreq;
    }

    public static int getMaxCpuFreq() {
        if (maxCpuFreq == 0) {
            maxCpuFreq = getMaxCpuFreqInfo();
        }
        return maxCpuFreq;
    }

    /* 获取CPU最小频率（单位KHZ） */
    public static int getMinCpuFreqInfo() {
        int result = 0;
        File file = null;
        FileReader fr = null;
        BufferedReader br = null;
        try {
            file = new File(kCpuInfoMaxFreqFilePath);
            if (file != null && file.exists()) {
                fr = new FileReader(kCpuInfoMinFreqFilePath);
                br = new BufferedReader(fr);
                String text = br.readLine();
                if (text != null && !text.isEmpty()) {
                    result = Integer.parseInt(text.trim());
                }
            }
        } catch (FileNotFoundException e) {
            ThunderLog.error(TAG, "Exception: " + e.toString());
        } catch (IOException e) {
            ThunderLog.error(TAG, "Exception: " + e.toString());
        } finally {
            if (fr != null) {
                try {
                    fr.close();
                } catch (IOException e) {
                    // TODO Auto-generated catch block
                    ThunderLog.error(TAG, "Exception: " + e.toString());
                }
            }
            if (br != null) {
                try {
                    br.close();
                } catch (IOException e) {
                    // TODO Auto-generated catch block
                    ThunderLog.error(TAG, "Exception: " + e.toString());
                }
            }
        }
        return result;
    }

    private final static String kCpuInfoCurFreqFilePath = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_cur_freq";

    /**
     * 获取CPU型号
     *
     * @return
     */

    public static String getCpuInfo() {
        String cpuName;
        cpuName = getCpuInfoBySystemProperties();
        if (cpuName != null) {
            return cpuName;
        }
        cpuName = getCpuInfoByProcNode();
        if (cpuName != null) {
            return cpuName;
        }
        return null;
    }

    public static String getCpuInfoByProcNode() {
        String strInfo = "/proc/cpuinfo";
        String cpuName = "unknown";
        String tmpName = "";
        BufferedReader localBufferedReader = null;
        FileReader fr = null;
        try {
            fr = new FileReader(strInfo);
            localBufferedReader = new BufferedReader(fr);
            while ((cpuName = localBufferedReader.readLine()) != null) {
                if (cpuName.contains("Hardware")) {
                    String[] array = cpuName.split(":");
                    if (array.length == 2) {
                        tmpName = array[1];
                    } else if (array.length == 1) {
                        tmpName = array[0];
                    }
                    if (tmpName != null) {
                        String[] arrayCpuName = tmpName.split(" ");
                        if (arrayCpuName.length > 1) {
                            return arrayCpuName[arrayCpuName.length - 1];
                        } else {
                            return arrayCpuName[0];
                        }
                    }
                }
            }
            localBufferedReader.close();
            fr.close();
        } catch (IOException e) {
            ThunderLog.error(TAG, "Exception: " + e.toString());
        } finally {
            try {
                if (localBufferedReader != null) {
                    localBufferedReader.close();
                }
                if (fr != null) {
                    fr.close();
                }
            } catch (IOException e) {
                ThunderLog.error(TAG, "Exception: " + e.toString());
            }
        }
        return cpuName;
    }

    public static String getCpuInfoBySystemProperties() {
        ThunderLog.release(TAG, "getCpuInfo 11");
        try {
            Class<?> classtype = Class.forName("android.os.SystemProperties");
            Method method = classtype.getDeclaredMethod("get", new Class<?>[]{String.class});
            String value = (String) method.invoke(classtype, "ro.board.platform");
            return value;
        } catch (ClassNotFoundException e) {
            ThunderLog.release(TAG, "getCpuInfo exception:" + e);
        } catch (NoSuchMethodException e) {
            ThunderLog.release(TAG, "getCpuInfo exception:" + e);
        } catch (InvocationTargetException e) {
            ThunderLog.release(TAG, "getCpuInfo exception:" + e);
        } catch (IllegalAccessException e) {
            ThunderLog.release(TAG, "getCpuInfo exception:" + e);
        }
        return null;
    }

    public static String[] getCpuRateByRunTop(int process) {
        String parseResult[] = new String[2];
        parseResult[0] = "0";
        parseResult[1] = "0";
        long start = System.currentTimeMillis();
        String topResult = run(TOP, process);
        long exhaustTime = System.currentTimeMillis() - start;
        if (topResult != null) {
            parseTopCpuInfo(topResult, parseResult);
            return parseResult;
        }
        return null;
    }

    private static String run(String[] cmd, int pid) {
        String line = null;
        String result = null;
        StringBuilder resultBuilder = new StringBuilder();
        InputStream inputStream = null;
        int limit = 10;
        BufferedReader bufReader = null;
        try {
            Runtime runtime = Runtime.getRuntime();
            Process proc = runtime.exec(cmd);
            inputStream = proc.getInputStream();
            bufReader = new BufferedReader(new InputStreamReader(inputStream));
            do {
                line = bufReader.readLine();
                if (null == line) {
                    ThunderLog.error(TAG, "return null");
                    break;
                }
                if (line != null && pid != 0 && line.contains(String.valueOf(pid))) {
                    //ThunderLog.info(TAG, "top cpu " + line + " pid " + pid);
                    resultBuilder.append(line);
                    break;
                }
                limit--;
            } while (limit > 0);
            if (inputStream != null) {
                inputStream.close();
            }
            if (bufReader != null) {
                bufReader.close();
            }
        } catch (IOException e) {
            ThunderLog.error(TAG, "top Exception:" + e);
        }
        result = resultBuilder.toString();
        // ThunderLog.warn(TAG, "top result:" + result);
        return result;
    }

    public static int parseTopCpuInfo(String line, String[] parseResult) {

        String cpuAppRate = null;
        String deviceRate = null;
        int index = 0;
        String cpuInfo[] = line.split(" ");
        if (parseResult != null && parseResult.length == 2 && cpuInfo != null) {
            for (int i = 0; i < cpuInfo.length; i++) {
                // ThunderLog.debug(TAG, "top cpu length:" + cpuInfo.length + "top cpu:" + cpuInfo[i]);
                if (cpuInfo[i].toUpperCase().equals("R") || cpuInfo[i].toUpperCase().equals("S")) {
                    cpuAppRate = cpuInfo[i + 1];
                    if (cpuAppRate == " ") {
                        cpuAppRate = cpuInfo[i + 2];
                    }
                    parseResult[0] = cpuAppRate;
                }

                if (cpuInfo[i].toLowerCase().contains("%idle")) {
                    if (i > 0) {
                        String cpuData[] = cpuInfo[i].split("%");
                        if (cpuData != null && cpuData.length > 0) {
                            float cpuIdle = Float.parseFloat(cpuData[0]);
                            float cpuDeviceRate = mCpuCores * 100 - cpuIdle;
                            deviceRate = String.valueOf(cpuDeviceRate);
                            parseResult[1] = deviceRate;
                        }
                    }
                }
            }
            return 0;
        }
        return -1;
    }
}
