package com.thunder.livesdk.helper;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashSet;

public class MshByteBufferPool implements IByteBufferPool {
    final static int kSize4K = 4 * 1024;
    final static int kSize8K = 8 * 1024;
    final static int kSize16K = 16 * 1024;
    final static int kSize32K = 32 * 1024;
    private ByteBufferChunk mBuffer4K = null;
    private ByteBufferChunk mBuffer8K = null;
    private ByteBufferChunk mBuffer16K = null;
    private ByteBufferChunk mBuffer32K = null;
    private HashSet<ByteBuffer> mBigBuffers = null;

    public MshByteBufferPool() {
        mBuffer4K = new ByteBufferChunk(kSize4K, 8);
        mBuffer8K = new ByteBufferChunk(kSize8K, 6);
        mBuffer16K = new ByteBufferChunk(kSize16K, 4);
        mBuffer32K = new ByteBufferChunk(kSize32K, 2);
        mBigBuffers = new HashSet<ByteBuffer>();
    }

    private ByteBufferChunk getBuffers(int size) {
        ;
        if (size < 0) {
            return null;
        } else if (size <= kSize4K) {
            return mBuffer4K;
        } else if (size <= kSize8K) {
            return mBuffer8K;
        } else if (size <= kSize16K) {
            return mBuffer16K;
        } else if (size <= kSize32K) {
            return mBuffer32K;
        } else {
            return null;
        }
    }

    @Override
    public ByteBuffer newBuffer(int size) {
        // TODO Auto-generated method stub
        synchronized (this) {
            ByteBufferChunk buffers = getBuffers(size);
            if (buffers != null && buffers.mFreeCnt > 0) {
                //Log.i("YYSDK", "ByteBufferPool::get block, size="+size);
                return buffers.newBuffer();
            } else {
                //Log.i("YYSDK", "ByteBufferPool::get, block size is not enghout, size="+size);
                ByteBuffer buffer = ByteBuffer.allocate(size).order(ByteOrder.LITTLE_ENDIAN);
                //Log.i("YYSDK", "ByteBufferPool::get, big buffer success, size="+buffer.capacity());
                mBigBuffers.add(buffer);
                return buffer;
            }
        }
    }

    @Override
    public void freeBuffer(ByteBuffer buf) {
        // TODO Auto-generated method stub
        synchronized (this) {
            //Log.i("YYSDK", "ByteBufferPool::put block, size="+buf.capacity());
            ByteBufferChunk buffers = getBuffers(buf.capacity());
            if (buffers == null || !buffers.freeBuffer(buf)) {
                //Log.i("YYSDK", "ByteBufferPool::put block to big buffers begin,  size="+buf.capacity() + " bigBuffers.size="+mBigBuffers.size());
                mBigBuffers.remove(buf);
                //Log.i("YYSDK", "ByteBufferPool::put block to big buffers end, size="+buf.capacity() + " bigBuffers.size="+mBigBuffers.size());
            }
        }
    }

    @Override
    public int totalSize() {
        // TODO Auto-generated method stub
        return 0;
    }

    @Override
    public void clear() {
        // TODO Auto-generated method stub

        synchronized (this) {

            mBigBuffers.clear();
            mBigBuffers = null;

            mBuffer4K.clear();
            mBuffer8K.clear();
            mBuffer16K.clear();
            mBuffer32K.clear();
            mBuffer4K = null;
            mBuffer8K = null;
            mBuffer16K = null;
            mBuffer32K = null;
        }
    }

    public class ByteBufferChunk {

        public static final int kFreeFlag = 0x01;

        public ByteBuffer[] mBufferBlocks = null;
        public int[] mBlockFlags = null;
        public int mFreeCnt = 0;

        public ByteBufferChunk(int blockSize, int blockCnt) {
            mBufferBlocks = new ByteBuffer[blockCnt];
            mBlockFlags = new int[blockCnt];
            mFreeCnt = blockCnt;

            int i = 0;
            while (i < blockCnt) {
                mBufferBlocks[i] = ByteBuffer.allocate(blockSize).order(ByteOrder.LITTLE_ENDIAN);
                mBlockFlags[i] = kFreeFlag;
                i++;
            }
        }

        public ByteBuffer newBuffer() {
            //Log.i("yysdk", "ByteBufferPool::ByteBufferChunk::get");
            int i = 0;
            while (i < mBufferBlocks.length) {
                if ((mBlockFlags[i] & kFreeFlag) != 0) {
                    mBlockFlags[i] &= ~kFreeFlag;
                    mFreeCnt--;
                    //Log.i("yysdk", "ByteBufferPool::ByteBufferChunk::get succeed, pos="+mBufferBlocks[i].position()+ " capactity="+mBufferBlocks[i].capacity() + " remains="+mBufferBlocks[i].remaining());
                    return mBufferBlocks[i];
                }
                i++;
            }
            return null;
        }

        public boolean freeBuffer(ByteBuffer buf) {
            //Log.i("yysdk", "ByteBufferPool::ByteBufferChunk::put");
            int i = 0;
            while (i < mBufferBlocks.length) {
                //if(buf.equals(mBufferBlocks[i]) && (mBlockFlags[i] & kBusyFlag) != 0)
                //if(buf.equals(mBufferBlocks[i]) && (mBlockFlags[i] & kFreeFlag) ==0)
                if ((buf == mBufferBlocks[i]) && (mBlockFlags[i] & kFreeFlag) == 0) {
                    mBlockFlags[i] |= kFreeFlag;
                    mBufferBlocks[i].clear();
                    mFreeCnt++;
                    //Log.i("yysdk", "ByteBufferPool::ByteBufferChunk::put succeed.");
                    return true;
                }
                i++;
            }
            return false;
        }

        public void clear() {
            int i = 0;
            while (i < mBufferBlocks.length) {
                mBufferBlocks[i] = null;
                i++;
            }

            mBufferBlocks = null;
            mBlockFlags = null;
        }
    }
}
