package com.thunder.livesdk;

import com.yy.mediaframework.CameraPreviewConfig;

/**
 * Created by xiongxiong on 2017/10/31.
 */

public class ThunderPreviewConfig extends ThunderVideoCaptureConfig {

    /**
     * 预览模式 - 标清
     */
    public static final int YYPREVIEW_MODE_NORMAL = 0;
    /**
     * 预览模式 - 高清
     */
    public static final int YYPREVIEW_MODE_HIGHQULITY = 1;
    /**
     * 设置手机采集朝向
     */
    public int captureOrientation;
    /**
     * 相机位置
     * <p>
     * {@link ThunderRtcConstant.ThunderCameraPosition}
     */
    public int cameraPosition;
    /**
     * 预览模式
     * 如果服务器配置中心isDefault = 1， 会更改此设置
     */
    public int previewMode;
    /**
     * 玩法
     */
    public int playType;

    public ThunderPreviewConfig() {
        this.playType = 0;    //单人开播玩法
        this.previewMode = -1;
        this.captureOrientation = ThunderRtcConstant.ThunderPublishOrientation.THUNDERPUBLISH_VIDEO_ORIENTATION_PORTRAIT;

    }

    /**
     * 使用模式初始化各配置项的值
     * <br>
     * <br>sdk会根据模式设置合适的配置项，若sdk给的配置项不能很好的满足需求可以自己修改配置项
     *
     * @param mode 预览模式 {@link ThunderPreviewConfig#YYPREVIEW_MODE_NORMAL} etc.
     */
    @Deprecated
    public ThunderPreviewConfig(int mode) {
        if (mode == YYPREVIEW_MODE_NORMAL) {
            this.captureResolutionWidth = CameraPreviewConfig.DEFAULT_PREVIEW_WIDTH;
            this.captureResolutionHeight = CameraPreviewConfig.DEFAULT_PREVIEW_HEIGHT;
            this.captureFrameRate = CameraPreviewConfig.DEFAULT_PREVIEW_FRAMERATE;
            this.captureOrientation =
                    ThunderRtcConstant.ThunderPublishOrientation.THUNDERPUBLISH_VIDEO_ORIENTATION_PORTRAIT;
        } else {
            this.captureResolutionWidth = CameraPreviewConfig.DEFAULT_PREVIEW_HIGH_WIDTH;
            this.captureResolutionHeight = CameraPreviewConfig.DEFAULT_PREVIEW_HIGH_HEIGHT;
            this.captureFrameRate = CameraPreviewConfig.DEFAULT_PREVIEW_HIGH_FRAMERATE;
            this.captureOrientation =
                    ThunderRtcConstant.ThunderPublishOrientation.THUNDERPUBLISH_VIDEO_ORIENTATION_PORTRAIT;
        }
        this.playType = 0;    //单人开播玩法
        this.previewMode = mode;
    }

    /**
     * 输出字符串形式的配置信息
     *
     * @return 返回字符串形式的配置信息，用于日志输出
     */
    @Override
    public String toString() {
        return "{captureResolutionWidth:" + this.captureResolutionWidth +
                " captureResolutionHeight:" + this.captureResolutionHeight +
                " captureFrameRate:" + this.captureFrameRate +
                " captureOrientation:" + this.captureOrientation +
                " cameraPosition:" + this.cameraPosition +
                " playType:" + this.playType +
                " previewMode:" + this.previewMode +
                "}";
    }

}
