package com.thunder.livesdk;

import android.graphics.Bitmap;

import com.thunder.livesdk.video.ThunderMultiVideoViewCoordinate;
import com.yy.videoplayer.videoview.VideoPosition;

import java.util.ArrayList;

public class ThunderMultiVideoViewParam {
    public int mViewId = -1; // view index, counting from 0
    public Object mView = null; // Corresponding view for viewId
    public Bitmap mBgBitmap; // Video/view background picture
    public ArrayList<ThunderMultiVideoViewCoordinate> mVideoViewPositions; // Video/view layout parameters
    public ThunderMultiVideoViewCoordinate mBgViewPosition; // Video/view background layout parameters

    @Deprecated
    /**
     * 建议使用 {@link ThunderMultiVideoViewParam#mVideoViewPositions}
     */
    public ArrayList<VideoPosition> mVideoPositions;
    @Deprecated
    /**
     * 建议使用 {@link ThunderMultiVideoViewParam#mBgViewPosition}
     */
    public VideoPosition mBgPosition;

    public ThunderMultiVideoViewParam() {
    }


    public ThunderMultiVideoViewParam(Bitmap bgBitmap,
                                      ArrayList<ThunderMultiVideoViewCoordinate> videoViewPositions,
                                      ThunderMultiVideoViewCoordinate bgViewPosition) {
        this.mBgBitmap = bgBitmap;
        this.mVideoViewPositions = videoViewPositions;
        this.mBgViewPosition = bgViewPosition;
    }

    public ThunderMultiVideoViewParam(int viewId, Object view, Bitmap bgBitmap,
                                      ArrayList<ThunderMultiVideoViewCoordinate> videoViewPositions,
                                      ThunderMultiVideoViewCoordinate bgViewPosition) {
        this.mViewId = viewId;
        this.mView = view;
        this.mBgBitmap = bgBitmap;
        this.mVideoViewPositions = videoViewPositions;
        this.mBgViewPosition = bgViewPosition;
    }

    @Deprecated
    /**
     * 该构造函数已废弃，建议使用{@link ThunderMultiVideoViewParam#ThunderMultiVideoViewParam(Bitmap, ArrayList, ThunderMultiVideoViewCoordinate)}
     */
    public ThunderMultiVideoViewParam(ArrayList<VideoPosition> _videoPositions,
                               VideoPosition bgPosition,
                               Bitmap _bgBitmap) {
        mVideoPositions = _videoPositions;
        mBgPosition = bgPosition;
        mBgBitmap = _bgBitmap;
    }

    @Deprecated
    /**
     * 该构造函数已废弃，建议使用{@link ThunderMultiVideoViewParam#ThunderMultiVideoViewParam(int, Object, Bitmap, ArrayList, ThunderMultiVideoViewCoordinate)}
     */
    public ThunderMultiVideoViewParam(ArrayList<VideoPosition> _videoPositions,
                                      VideoPosition bgPosition,
                                      Bitmap _bgBitmap,
                                      int viewId,
                                      Object view) {
        mVideoPositions = _videoPositions;
        mBgPosition = bgPosition;
        mBgBitmap = _bgBitmap;
        mViewId = viewId;
        mView = view;
    }
}
