package com.thunder.livesdk;

import java.util.ArrayList;

public interface IThunderMediaExtraInfoCallback {

	/**
	 * Send a callback of failed status of media extra information
	 *
	 * @param status Error code of failed status {@link ThunderRtcConstant.ThunderSendMediaExtraInfoFailedStatus}
	 */
	void onSendMediaExtraInfoFailedStatus(int status);

	/**
	 * Receive the media extra information
	 *
	 * @param uid       Anchor uid
	 * @param data      Received media extra information
	 * @param dataLen   Length of media extra information
	 */
	void onRecvMediaExtraInfo(java.lang.String uid,
							  java.nio.ByteBuffer data,
							  int dataLen);
				
	 /**
      * Extra information of mixed audio stream received
      * @param uid   uid of mixed audio stream user
      * @param infos Original stream information about mixed audio stream, identifying which streams contribute to this mixed audio stream
     */
    void onRecvMixAudioInfo(java.lang.String uid, ArrayList<ThunderEventHandler.MixAudioInfo> infos);
    /**
     * Extra information of mixed video stream received
     *
     * @param uid   uid of mixed video stream user
     * @param infos Original stream information about mixed video stream, identifying which streams contribute to this mixed video stream and the stream layout information.
     */
    void onRecvMixVideoInfo(java.lang.String uid, ArrayList<ThunderEventHandler.MixVideoInfo> infos);

}
