package com.thunder.livesdk;

public abstract class IThunderAudioFilePlayerEventCallback{
    /**
     * 播放音量回调
     *
     * @param volume    音量值[0-100]
     * @param currentMs 播放进度值（单位：毫秒）
     * @param totalMs   文件总长度（单位：毫秒）
     */
    public void onAudioFileVolume(long volume, long currentMs, long totalMs) {}

    /**
     * 播放器状态回调
     * @param event 播放状态，详见 {@link ThunderRtcConstant.ThunderAudioFilePlayerEvent}\
     * @param errorCode 播放状态错误码，详见 {@link ThunderRtcConstant.ThunderAudioFilePLayerErrorCode}\
     */
    public void onAudioFileStateChange(int event, int errorCode) {}
}
