/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.stream;

import com.perforce.p4java.Log;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.impl.mapbased.rpc.ServerStats;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;

public class RpcSocketOutputStream
extends OutputStream {
    public static final String TRACE_PREFIX = "RpcSocketOutputStream";
    private Socket socket = null;
    private OutputStream socketStream = null;
    private ServerStats stats = null;

    public RpcSocketOutputStream(Socket socket, ServerStats stats) {
        if (socket == null) {
            throw new NullPointerError("null RPC socket passed to RpcSocketInputStream constructor");
        }
        this.socket = socket;
        this.stats = stats;
        try {
            this.socketStream = socket.getOutputStream();
        }
        catch (IOException ioexc) {
            Log.error("Unexpected I/O exception thrown during output stream retrieval in RpcSocketInputStream constructor: " + ioexc.getLocalizedMessage());
            Log.exception(ioexc);
            throw new P4JavaError("Unexpected I/O exception thrown during output stream retrieval in RpcSocketInputStream constructor: " + ioexc.getLocalizedMessage());
        }
    }

    public void write(int b) throws IOException {
        if (this.socketStream == null) {
            throw new NullPointerError("null socket stream in RpcSocketOutputStream.write()");
        }
        this.socketStream.write(b);
    }

    public void write(byte[] bytes) throws IOException {
        if (this.socketStream == null) {
            throw new NullPointerError("null socket stream in RpcSocketOutputStream.write()");
        }
        if (bytes == null) {
            throw new NullPointerError("null byte array in RpcSocketOutputStream.write()");
        }
        if (this.stats != null && this.stats.largestSend.get() < (long)bytes.length) {
            this.stats.largestSend.set(bytes.length);
        }
        this.socketStream.write(bytes);
    }

    public void write(byte[] bytes, int offset, int len) throws IOException {
        if (this.socketStream == null) {
            throw new NullPointerError("null socket stream in RpcSocketOutputStream.write()");
        }
        if (bytes == null) {
            throw new NullPointerError("null byte array in RpcSocketOutputStream.write()");
        }
        if (this.stats != null && this.stats.largestSend.get() < (long)len) {
            this.stats.largestSend.set(len);
        }
        this.socketStream.write(bytes, offset, len);
    }

    protected Socket getSocket() {
        return this.socket;
    }

    protected void setSocket(Socket socket) {
        this.socket = socket;
    }

    protected OutputStream getSocketStream() {
        return this.socketStream;
    }

    protected void setSocketStream(OutputStream socketStream) {
        this.socketStream = socketStream;
    }
}

