/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.gradle;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.palantir.javaformat.gradle.JavaFormatExtension;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;

public final class PalantirJavaFormatProviderPlugin
implements Plugin<Project> {
    static final String CONFIGURATION_NAME = "palantirJavaFormat";

    public void apply(Project rootProject) {
        Preconditions.checkState((rootProject == rootProject.getRootProject() ? 1 : 0) != 0, (Object)"May only apply com.palantir.java-format-provider to the root project");
        Configuration configuration = (Configuration)rootProject.getConfigurations().create(CONFIGURATION_NAME, conf -> {
            conf.setDescription("Internal configuration for resolving the palantir-java-format implementation");
            conf.setVisible(false);
            conf.setCanBeConsumed(false);
            conf.defaultDependencies(deps -> deps.add((Object)rootProject.getDependencies().create((Object)ImmutableMap.of((Object)"group", (Object)"com.palantir.javaformat", (Object)"name", (Object)"palantir-java-format", (Object)"version", (Object)JavaFormatExtension.class.getPackage().getImplementationVersion()))));
        });
        rootProject.getExtensions().create(CONFIGURATION_NAME, JavaFormatExtension.class, new Object[]{configuration});
    }
}

