/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.gradle;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import groovy.util.Node;
import groovy.util.XmlNodePrinter;
import groovy.util.XmlParser;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.gradle.api.DefaultTask;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.xml.sax.SAXException;

public abstract class UpdateIntellijXmlTask
extends DefaultTask {
    private final Property<File> xmlFile = this.getProject().getObjects().property(File.class);
    static final String INTELLIJ_TASK_GROUP = "intellij";

    protected abstract void configure(Node var1);

    public UpdateIntellijXmlTask() {
        this.setGroup(INTELLIJ_TASK_GROUP);
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @OutputFile
    protected final Property<File> getXmlFile() {
        return this.xmlFile;
    }

    @TaskAction
    public final void run() {
        Node rootNode;
        File configurationFile = (File)this.getXmlFile().get();
        if (configurationFile.isFile()) {
            try {
                rootNode = new XmlParser().parse(configurationFile);
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                throw new RuntimeException("Couldn't parse existing configuration file: " + configurationFile, e);
            }
        } else {
            rootNode = new Node(null, (Object)"project", (Map)ImmutableMap.of((Object)"version", (Object)"4"));
        }
        this.configure(rootNode);
        try (BufferedWriter writer = Files.newWriter((File)configurationFile, (Charset)Charset.defaultCharset());
             PrintWriter printWriter = new PrintWriter(writer);){
            XmlNodePrinter nodePrinter = new XmlNodePrinter(printWriter);
            nodePrinter.setPreserveWhitespace(true);
            nodePrinter.print(rootNode);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write back to configuration file: " + configurationFile, e);
        }
    }
}

