/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.gradle;

import com.google.common.base.Preconditions;
import com.palantir.javaformat.gradle.ConfigureExternalDependenciesXml;
import com.palantir.javaformat.gradle.ConfigureJavaFormatterXml;
import com.palantir.javaformat.gradle.ConfigurePalantirJavaFormatXml;
import com.palantir.javaformat.gradle.PalantirJavaFormatProviderPlugin;
import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.jetbrains.gradle.ext.TaskTriggersConfig;

public final class PalantirJavaFormatIdeaPlugin
implements Plugin<Project> {
    public void apply(Project rootProject) {
        Preconditions.checkState((rootProject == rootProject.getRootProject() ? 1 : 0) != 0, (Object)"May only apply com.palantir.java-format-idea to the root project");
        rootProject.getPlugins().apply(PalantirJavaFormatProviderPlugin.class);
        rootProject.getPluginManager().withPlugin("idea", ideaPlugin -> {
            Configuration implConfiguration = rootProject.getConfigurations().getByName("palantirJavaFormat");
            PalantirJavaFormatIdeaPlugin.configureLegacyIdea(rootProject, implConfiguration);
            PalantirJavaFormatIdeaPlugin.configureIntelliJImport(rootProject, implConfiguration);
        });
    }

    private static void configureLegacyIdea(Project project, Configuration implConfiguration) {
        IdeaModel ideaModel = (IdeaModel)project.getExtensions().getByType(IdeaModel.class);
        ideaModel.getProject().getIpr().withXml(xmlProvider -> {
            List<URI> uris = implConfiguration.getFiles().stream().map(File::toURI).collect(Collectors.toList());
            ConfigureJavaFormatterXml.configureJavaFormat(xmlProvider.asNode(), uris);
            ConfigureJavaFormatterXml.configureExternalDependencies(xmlProvider.asNode());
        });
    }

    private static void configureIntelliJImport(Project project, Configuration implConfiguration) {
        project.getPluginManager().apply("org.jetbrains.gradle.plugin.idea-ext");
        TaskProvider configurePalantirJavaFormatXmlTask = project.getTasks().register("configurePalantirJavaFormatXml", ConfigurePalantirJavaFormatXml.class, task -> task.getImplConfiguration().set((Object)implConfiguration));
        TaskProvider configurePalantirJavaFormatPluginDependencyXml = project.getTasks().register("configurePalantirJavaFormatPluginDependencyXml", ConfigureExternalDependenciesXml.class);
        Task palantirJavaFormatIntellij = (Task)project.getTasks().create("palantirJavaFormatIntellij", arg_0 -> PalantirJavaFormatIdeaPlugin.lambda$configureIntelliJImport$3((Provider)configurePalantirJavaFormatXmlTask, (Provider)configurePalantirJavaFormatPluginDependencyXml, arg_0));
        ExtensionAware ideaProject = (ExtensionAware)((IdeaModel)project.getExtensions().getByType(IdeaModel.class)).getProject();
        ExtensionAware settings = (ExtensionAware)ideaProject.getExtensions().getByName("settings");
        TaskTriggersConfig taskTriggers = (TaskTriggersConfig)settings.getExtensions().getByType(TaskTriggersConfig.class);
        taskTriggers.beforeSync(new Object[]{palantirJavaFormatIntellij});
    }

    private static /* synthetic */ void lambda$configureIntelliJImport$3(Provider configurePalantirJavaFormatXmlTask, Provider configurePalantirJavaFormatPluginDependencyXml, Task task) {
        task.setDescription("Configure IntelliJ directory-based repository after importing");
        task.setGroup("intellij");
        task.dependsOn(new Object[]{configurePalantirJavaFormatXmlTask, configurePalantirJavaFormatPluginDependencyXml});
    }
}

