/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.versions.lockstate;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.palantir.gradle.versions.GradleComparators;
import com.palantir.gradle.versions.internal.MyModuleIdentifier;
import com.palantir.gradle.versions.lockstate.ImmutableLockState;
import com.palantir.gradle.versions.lockstate.Line;
import java.io.Serializable;
import java.util.List;
import java.util.NavigableMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.immutables.value.Value;

@Value.Immutable
public interface LockState
extends Serializable {
    @Value.Parameter
    public List<Line> productionLines();

    @Value.Parameter
    public List<Line> testLines();

    @Value.Lazy
    default public List<Line> allLines() {
        return ImmutableList.builder().addAll(this.productionLines()).addAll(this.testLines()).build();
    }

    @Value.Lazy
    default public NavigableMap<MyModuleIdentifier, Line> productionLinesByModuleIdentifier() {
        return (NavigableMap)this.productionLines().stream().collect(ImmutableSortedMap.toImmutableSortedMap(GradleComparators.MODULE_IDENTIFIER_COMPARATOR, Line::identifier, Function.identity()));
    }

    @Value.Lazy
    default public NavigableMap<MyModuleIdentifier, Line> testLinesByModuleIdentifier() {
        return (NavigableMap)this.testLines().stream().collect(ImmutableSortedMap.toImmutableSortedMap(GradleComparators.MODULE_IDENTIFIER_COMPARATOR, Line::identifier, Function.identity()));
    }

    public static LockState from(Stream<Line> productionLines, Stream<Line> testLines) {
        return ImmutableLockState.of(productionLines.collect(Collectors.toList()), testLines.collect(Collectors.toList()));
    }
}

