/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.versions.lockstate;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.palantir.gradle.versions.internal.MyModuleIdentifier;
import com.palantir.gradle.versions.lockstate.Line;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Line", generator="Immutables")
@Immutable
public final class ImmutableLine
implements Line {
    private final String group;
    private final String name;
    private final String version;
    private final int numDependents;
    private final String dependentsHash;
    private volatile transient long lazyInitBitmap;
    private static final long IDENTIFIER_LAZY_INIT_BIT = 1L;
    private transient MyModuleIdentifier identifier;
    private static final long STRING_REPRESENTATION_LAZY_INIT_BIT = 2L;
    private transient String stringRepresentation;

    private ImmutableLine(String group, String name, String version, int numDependents, String dependentsHash) {
        this.group = Objects.requireNonNull(group, "group");
        this.name = Objects.requireNonNull(name, "name");
        this.version = Objects.requireNonNull(version, "version");
        this.numDependents = numDependents;
        this.dependentsHash = Objects.requireNonNull(dependentsHash, "dependentsHash");
    }

    private ImmutableLine(ImmutableLine original, String group, String name, String version, int numDependents, String dependentsHash) {
        this.group = group;
        this.name = name;
        this.version = version;
        this.numDependents = numDependents;
        this.dependentsHash = dependentsHash;
    }

    @Override
    public String group() {
        return this.group;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String version() {
        return this.version;
    }

    @Override
    public int numDependents() {
        return this.numDependents;
    }

    @Override
    public String dependentsHash() {
        return this.dependentsHash;
    }

    public final ImmutableLine withGroup(String value) {
        String newValue = Objects.requireNonNull(value, "group");
        if (this.group.equals(newValue)) {
            return this;
        }
        return new ImmutableLine(this, newValue, this.name, this.version, this.numDependents, this.dependentsHash);
    }

    public final ImmutableLine withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableLine(this, this.group, newValue, this.version, this.numDependents, this.dependentsHash);
    }

    public final ImmutableLine withVersion(String value) {
        String newValue = Objects.requireNonNull(value, "version");
        if (this.version.equals(newValue)) {
            return this;
        }
        return new ImmutableLine(this, this.group, this.name, newValue, this.numDependents, this.dependentsHash);
    }

    public final ImmutableLine withNumDependents(int value) {
        if (this.numDependents == value) {
            return this;
        }
        return new ImmutableLine(this, this.group, this.name, this.version, value, this.dependentsHash);
    }

    public final ImmutableLine withDependentsHash(String value) {
        String newValue = Objects.requireNonNull(value, "dependentsHash");
        if (this.dependentsHash.equals(newValue)) {
            return this;
        }
        return new ImmutableLine(this, this.group, this.name, this.version, this.numDependents, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLine && this.equalTo((ImmutableLine)another);
    }

    private boolean equalTo(ImmutableLine another) {
        return this.group.equals(another.group) && this.name.equals(another.name) && this.version.equals(another.version) && this.numDependents == another.numDependents && this.dependentsHash.equals(another.dependentsHash);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.group.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.version.hashCode();
        h += (h << 5) + this.numDependents;
        h += (h << 5) + this.dependentsHash.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Line").omitNullValues().add("group", (Object)this.group).add("name", (Object)this.name).add("version", (Object)this.version).add("numDependents", this.numDependents).add("dependentsHash", (Object)this.dependentsHash).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MyModuleIdentifier identifier() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableLine immutableLine = this;
            synchronized (immutableLine) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.identifier = Objects.requireNonNull(Line.super.identifier(), "identifier");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.identifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String stringRepresentation() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            ImmutableLine immutableLine = this;
            synchronized (immutableLine) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.stringRepresentation = Objects.requireNonNull(Line.super.stringRepresentation(), "stringRepresentation");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.stringRepresentation;
    }

    public static ImmutableLine of(String group, String name, String version, int numDependents, String dependentsHash) {
        return new ImmutableLine(group, name, version, numDependents, dependentsHash);
    }

    public static ImmutableLine copyOf(Line instance) {
        if (instance instanceof ImmutableLine) {
            return (ImmutableLine)instance;
        }
        return ImmutableLine.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Line", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_GROUP = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_VERSION = 4L;
        private static final long INIT_BIT_NUM_DEPENDENTS = 8L;
        private static final long INIT_BIT_DEPENDENTS_HASH = 16L;
        private long initBits = 31L;
        @Nullable
        private String group;
        @Nullable
        private String name;
        @Nullable
        private String version;
        private int numDependents;
        @Nullable
        private String dependentsHash;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Line instance) {
            Objects.requireNonNull(instance, "instance");
            this.group(instance.group());
            this.name(instance.name());
            this.version(instance.version());
            this.numDependents(instance.numDependents());
            this.dependentsHash(instance.dependentsHash());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder group(String group) {
            this.group = Objects.requireNonNull(group, "group");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder version(String version) {
            this.version = Objects.requireNonNull(version, "version");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder numDependents(int numDependents) {
            this.numDependents = numDependents;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder dependentsHash(String dependentsHash) {
            this.dependentsHash = Objects.requireNonNull(dependentsHash, "dependentsHash");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableLine build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLine(null, this.group, this.name, this.version, this.numDependents, this.dependentsHash);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("group");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("version");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("numDependents");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("dependentsHash");
            }
            return "Cannot build Line, some of required attributes are not set " + attributes;
        }
    }
}

