/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.versions.lockstate;

import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import com.palantir.gradle.versions.lockstate.ImmutableDependents;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.immutables.value.Value;

@Value.Immutable
public interface Dependents {
    @Value.Parameter
    public NavigableMap<ComponentIdentifier, Set<VersionConstraint>> get();

    @Value.Derived
    default public NavigableSet<VersionConstraint> projectConstraints() {
        return (NavigableSet)Maps.filterKeys(this.get(), k -> k instanceof ProjectComponentIdentifier).values().stream().flatMap(Collection::stream).collect(ImmutableSortedSet.toImmutableSortedSet(Comparator.comparing(Object::toString)));
    }

    @Value.Derived
    default public Map<ComponentIdentifier, Set<VersionConstraint>> nonProjectConstraints() {
        return Maps.filterKeys(this.get(), k -> !(k instanceof ProjectComponentIdentifier));
    }

    public static Dependents of(NavigableMap<ComponentIdentifier, Set<VersionConstraint>> dependents) {
        return ImmutableDependents.of(dependents);
    }
}

