/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.versions;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;

public class VersionRecommendationsExtension {
    private static final ImmutableSet<String> DEFAULT_EXCLUDED_CONFIGURATIONS = ImmutableSet.of((Object)"archives", (Object)"nebulaRecommenderBom", (Object)"provided", (Object)"versionManagement", (Object)"resolutionRules", (Object)"bootArchives", (Object[])new String[]{"webapp"});
    public static final String EXTENSION = "versionRecommendations";
    private final SetProperty<String> excludeConfigurations;

    @Inject
    public VersionRecommendationsExtension(Project project) {
        this.excludeConfigurations = project.getObjects().setProperty(String.class).empty();
        this.excludeConfigurations.addAll(DEFAULT_EXCLUDED_CONFIGURATIONS);
    }

    public final void excludeConfigurations(String ... configurations) {
        this.excludeConfigurations.addAll((Object[])configurations);
    }

    public final void setExcludeConfigurations(String ... configurations) {
        this.excludeConfigurations.set((Iterable)Lists.newArrayList((Object[])configurations));
    }

    final Provider<Set<String>> getExcludeConfigurations() {
        return this.excludeConfigurations;
    }

    final boolean shouldExcludeConfiguration(String configuration) {
        return ((Set)this.excludeConfigurations.get()).contains(configuration);
    }
}

