/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.versions;

import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

final class TaskNameMatcher {
    private final List<String> fullTaskNameParts;

    TaskNameMatcher(String fullTaskName) {
        this.fullTaskNameParts = TaskNameMatcher.toParts(fullTaskName);
    }

    public boolean matches(String taskName) {
        List<String> taskNameParts = TaskNameMatcher.toParts(taskName);
        if (taskNameParts.size() != this.fullTaskNameParts.size()) {
            return false;
        }
        return Streams.zip(this.fullTaskNameParts.stream(), taskNameParts.stream(), String::startsWith).allMatch(bool -> bool);
    }

    public boolean matchesAny(Collection<String> tasks) {
        return tasks.stream().anyMatch(this::matches);
    }

    private static List<String> toParts(String fullTaskName) {
        ArrayList<String> parts = new ArrayList<String>();
        StringBuilder currentPart = new StringBuilder();
        for (int i = 0; i < fullTaskName.length(); ++i) {
            char chr = fullTaskName.charAt(i);
            if (Character.isUpperCase(chr)) {
                parts.add(currentPart.toString());
                currentPart.setLength(0);
            }
            currentPart.append(chr);
        }
        parts.add(currentPart.toString());
        return parts.stream().filter(string -> !string.isEmpty()).collect(Collectors.toList());
    }
}

