/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.versions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.stream.Stream;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;

final class GradleConfigurations {
    private static final ImmutableList<String> DEPRECATED_SOURCESET_SUFFIXES = ImmutableList.of((Object)"Compile", (Object)"Runtime");

    public static Stream<Configuration> getResolvableConfigurations(Project project) {
        Set<String> legacyJavaConfigurations = GradleConfigurations.getLegacyJavaConfigurations(project);
        return project.getConfigurations().stream().filter(Configuration::isCanBeResolved).filter(conf -> !legacyJavaConfigurations.contains(conf.getName())).filter(conf -> DEPRECATED_SOURCESET_SUFFIXES.stream().noneMatch(suffix -> conf.getName().endsWith((String)suffix)));
    }

    private static Set<String> getLegacyJavaConfigurations(Project project) {
        JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().findPlugin(JavaPluginConvention.class);
        if (javaConvention == null) {
            return ImmutableSet.of();
        }
        return ImmutableSet.builder().add((Object)"default").addAll(javaConvention.getSourceSets().stream().map(SourceSet::getCompileOnlyConfigurationName).iterator()).build();
    }

    private GradleConfigurations() {
    }
}

