/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.versions;

import com.google.common.collect.Comparators;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.Optional;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;

public final class GradleComparators {
    public static final Comparator<ModuleIdentifier> MODULE_IDENTIFIER_COMPARATOR = Comparator.comparing(ModuleIdentifier::getGroup).thenComparing(ModuleIdentifier::getName);
    public static final Comparator<ComponentIdentifier> COMPONENT_IDENTIFIER_COMPARATOR = Comparator.comparing(id -> GradleComparators.tryCast(ModuleComponentIdentifier.class, id), Comparators.emptiesFirst((Comparator)Ordering.from(MODULE_IDENTIFIER_COMPARATOR).onResultOf(ModuleComponentIdentifier::getModuleIdentifier))).thenComparing(ComponentIdentifier::getDisplayName);

    private GradleComparators() {
    }

    static <A, T> Optional<T> tryCast(Class<T> to, A value) {
        return to.isInstance(value) ? Optional.of(to.cast(value)) : Optional.empty();
    }
}

