/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.versions;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.palantir.gradle.versions.GradleWorkarounds;
import groovy.lang.Closure;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.result.ResolvedComponentResult;

public final class GetVersionPlugin
implements Plugin<Project> {
    public void apply(final Project project) {
        project.getExtensions().getExtraProperties().set("getVersion", (Object)new Closure<String>((Object)project, (Object)project){

            public String doCall(Object moduleVersion) {
                return this.doCall(moduleVersion, project.getRootProject().getConfigurations().getByName("unifiedClasspath"));
            }

            public String doCall(Object moduleVersion, Configuration configuration) {
                List strings = Splitter.on((char)':').splitToList((CharSequence)moduleVersion.toString());
                Preconditions.checkState((strings.size() == 2 ? 1 : 0) != 0, (String)"Expected 'group:name', found: %s", (Object)moduleVersion.toString());
                return GetVersionPlugin.getVersion(project, (String)strings.get(0), (String)strings.get(1), configuration);
            }

            public String doCall(String group, String name) {
                return GetVersionPlugin.getVersion(project, group, name, project.getRootProject().getConfigurations().getByName("unifiedClasspath"));
            }

            public String doCall(String group, String name, Configuration configuration) {
                return GetVersionPlugin.getVersion(project, group, name, configuration);
            }
        });
    }

    private static String getVersion(Project project, String group, String name, Configuration configuration) {
        return GetVersionPlugin.getOptionalVersion(project, group, name, configuration).orElseThrow(() -> GetVersionPlugin.notFound(group, name, configuration));
    }

    static Optional<String> getOptionalVersion(Project project, String group, String name, Configuration configuration) {
        if (GradleWorkarounds.isConfiguring(project.getState())) {
            throw new GradleException(String.format("Not allowed to call gradle-consistent-versions's getVersion(\"%s\", \"%s\", configurations.%s) at configuration time", group, name, configuration.getName()));
        }
        List list = configuration.getIncoming().getResolutionResult().getAllComponents().stream().map(ResolvedComponentResult::getModuleVersion).filter(item -> item.getGroup().equals(group) && item.getName().equals(name)).collect(Collectors.toList());
        if (list.isEmpty()) {
            return Optional.empty();
        }
        if (list.size() > 1) {
            throw new GradleException(String.format("Multiple modules matching '%s:%s' in %s: %s", group, name, configuration, list));
        }
        return Optional.of(((ModuleVersionIdentifier)Iterables.getOnlyElement(list)).getVersion());
    }

    private static GradleException notFound(String group, String name, Configuration configuration) {
        String actual = configuration.getIncoming().getResolutionResult().getAllComponents().stream().map(ResolvedComponentResult::getModuleVersion).map(mvi -> String.format("\t- %s:%s:%s", mvi.getGroup(), mvi.getName(), mvi.getVersion())).collect(Collectors.joining("\n"));
        return new GradleException(String.format("Unable to find '%s:%s' in %s. This may happen if you specify the version in versions.props but do not have a dependency in the configuration. The configuration contained:\n%s", group, name, configuration, actual));
    }
}

