/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.versions;

import com.google.common.base.Preconditions;
import com.palantir.gradle.versions.GetVersionPlugin;
import com.palantir.gradle.versions.VersionsLockPlugin;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.plugins.JavaPlugin;

public class FixLegacyJavaConfigurationsPlugin
implements Plugin<Project> {
    public final void apply(Project project) {
        if (!project.getPlugins().hasPlugin(JavaPlugin.class)) {
            throw new GradleException("FixLegacyJavaConfigurationsPlugin must be applied after 'java' / JavaPlugin");
        }
        if (VersionsLockPlugin.isIgnoreLockFile(project)) {
            return;
        }
        Configuration unifiedClasspath = (Configuration)project.getRootProject().getConfigurations().findByName("unifiedClasspath");
        Preconditions.checkNotNull((Object)unifiedClasspath, (Object)"FixLegacyJavaConfigurationsPlugin must be applied after VersionsLockPlugin");
        this.fixLegacyResolvableJavaConfigurations(project, unifiedClasspath);
    }

    private void fixLegacyResolvableJavaConfigurations(Project project, Configuration unifiedClasspath) {
        Stream.of("compile", "runtime", "compileOnly").map(arg_0 -> ((ConfigurationContainer)project.getConfigurations()).findByName(arg_0)).filter(Objects::nonNull).forEach(conf -> this.injectVersions((Configuration)conf, (group, name) -> GetVersionPlugin.getOptionalVersion(project, group, name, unifiedClasspath)));
    }

    private void injectVersions(Configuration conf, GetVersion getVersion) {
        ResolvableDependencies incoming = conf.getIncoming();
        incoming.beforeResolve(dependencies -> {
            if (incoming != dependencies) {
                return;
            }
            conf.getResolutionStrategy().eachDependency(details -> {
                ModuleVersionSelector requested = details.getTarget();
                for (ModuleVersionSelector force : conf.getResolutionStrategy().getForcedModules()) {
                    if (!requested.getGroup().equals(force.getGroup()) || !requested.getName().equals(force.getName())) continue;
                    details.because(String.format("Would have recommended a version for %s:%s, but a force is in place", requested.getGroup(), requested.getName()));
                    return;
                }
                getVersion.getVersion(details.getRequested().getGroup(), details.getRequested().getName()).ifPresent(ver -> {
                    details.useVersion(ver);
                    details.because("Forced by gradle-consistent-versions versions.lock");
                });
            });
        });
    }

    private static interface GetVersion {
        public Optional<String> getVersion(String var1, String var2);
    }
}

