/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.junit;

import com.palantir.gradle.junit.Report;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

final class JunitReportCreator {
    static Document reportToXml(Report report) {
        try {
            Document xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            String elapsedTimeString = String.format("%.03f", (double)report.elapsedTimeNanos() / 1.0E9);
            Element testSuitesXml = xml.createElement("testsuites");
            xml.appendChild(testSuitesXml);
            testSuitesXml.setAttribute("id", JunitReportCreator.asId(report.name()));
            testSuitesXml.setAttribute("name", report.name());
            testSuitesXml.setAttribute("tests", Integer.toString(report.testCases().size()));
            testSuitesXml.setAttribute("time", elapsedTimeString);
            Element testSuiteXml = xml.createElement("testsuite");
            testSuitesXml.appendChild(testSuiteXml);
            testSuiteXml.setAttribute("id", JunitReportCreator.asId(report.subname()));
            testSuiteXml.setAttribute("name", report.subname());
            testSuiteXml.setAttribute("tests", Integer.toString(report.testCases().size()));
            testSuiteXml.setAttribute("time", elapsedTimeString);
            int failures = 0;
            for (Report.TestCase testCase : report.testCases()) {
                Element testCaseXml = xml.createElement("testcase");
                testSuiteXml.appendChild(testCaseXml);
                testCaseXml.setAttribute("id", JunitReportCreator.asId(testCase.name()));
                testCaseXml.setAttribute("name", testCase.name());
                Report.Failure failure = testCase.failure();
                if (failure == null) continue;
                ++failures;
                Element failureXml = xml.createElement("failure");
                testCaseXml.appendChild(failureXml);
                failureXml.setAttribute("message", failure.message());
                failureXml.setAttribute("type", "ERROR");
                failureXml.setTextContent(failure.details());
            }
            testSuitesXml.setAttribute("failures", Integer.toString(failures));
            testSuiteXml.setAttribute("failures", Integer.toString(failures));
            return xml;
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private static String asId(String name) {
        return name.replace(" - ", ".");
    }

    private JunitReportCreator() {
    }
}

