/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.junit;

import com.palantir.gradle.junit.BuildFailureListener;
import com.palantir.gradle.junit.JunitReportCreator;
import com.palantir.gradle.junit.Report;
import com.palantir.gradle.junit.XmlUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.xml.transform.TransformerException;
import org.gradle.BuildResult;
import org.gradle.api.Action;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.w3c.dom.Document;

public final class BuildFinishedAction
implements Action<BuildResult> {
    private final Provider<RegularFile> targetFile;
    private final long startTimeNanos;
    private final BuildFailureListener failureListener;

    public BuildFinishedAction(Provider<RegularFile> targetFile, BuildFailureListener failureListener) {
        this.targetFile = targetFile;
        this.failureListener = failureListener;
        this.startTimeNanos = System.nanoTime();
    }

    public void execute(BuildResult result) {
        Report report = new Report.Builder().name("gradle").subname("gradle").elapsedTimeNanos(System.nanoTime() - this.startTimeNanos).addAllTestCases(this.failureListener.getTestCases()).build();
        Document xml = JunitReportCreator.reportToXml(report);
        try {
            Files.createDirectories(this.getTargetFile().getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(this.getTargetFile(), StandardCharsets.UTF_8, new OpenOption[0]);){
            XmlUtils.write(writer, xml);
        }
        catch (IOException | TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    private Path getTargetFile() {
        return ((RegularFile)this.targetFile.get()).getAsFile().toPath();
    }
}

