/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.junit;

import com.palantir.gradle.junit.Report;
import com.palantir.gradle.junit.StyleTaskTimer;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.tasks.TaskExecutionException;
import org.gradle.api.tasks.TaskState;
import org.gradle.api.tasks.testing.Test;

public final class BuildFailureListener
implements TaskExecutionListener {
    private final List<Report.TestCase> testCases = new ArrayList<Report.TestCase>();

    public void beforeExecute(Task task) {
    }

    public synchronized void afterExecute(Task task, TaskState state) {
        if (BuildFailureListener.isUntracked(task)) {
            Report.TestCase.Builder testCase = new Report.TestCase.Builder().name(":" + task.getProject().getName() + ":" + task.getName());
            Throwable failure = state.getFailure();
            if (failure != null && BuildFailureListener.isUntracked(task)) {
                if (failure instanceof TaskExecutionException && failure.getCause() != null) {
                    failure = failure.getCause();
                }
                StringWriter stackTrace = new StringWriter();
                failure.printStackTrace(new PrintWriter(stackTrace));
                testCase.failure(new Report.Failure.Builder().message(BuildFailureListener.getMessage(failure)).details(stackTrace.toString()).build());
            }
            this.testCases.add(testCase.build());
        }
    }

    public List<Report.TestCase> getTestCases() {
        return this.testCases;
    }

    private static String getMessage(Throwable throwable) {
        if (throwable.getMessage() == null) {
            return throwable.getClass().getSimpleName();
        }
        return throwable.getClass().getSimpleName() + ": " + throwable.getMessage();
    }

    private static boolean isUntracked(Task task) {
        return !(task instanceof Test) && !StyleTaskTimer.isStyleTask(task);
    }
}

