/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.ErrorProneToken;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.parser.Tokens;

@BugPattern(name="VarUsage", link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.ERROR, summary="The `var` keyword results in illegible code in most cases and should not be used.")
@AutoService(value={BugChecker.class})
public final class VarUsage
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    public Description matchVariable(VariableTree tree, VisitorState state) {
        Tree typeTree = tree.getType();
        String sourceType = state.getSourceForNode(typeTree);
        if (sourceType != null) {
            return Description.NO_MATCH;
        }
        TreePath parentPath = state.getPath().getParentPath();
        if (parentPath == null) {
            return Description.NO_MATCH;
        }
        Tree parentTree = parentPath.getLeaf();
        if (parentTree instanceof LambdaExpressionTree) {
            return Description.NO_MATCH;
        }
        for (ErrorProneToken token : state.getOffsetTokensForNode((Tree)tree)) {
            if (token.kind() != Tokens.TokenKind.IDENTIFIER || !token.hasName() || !token.name().contentEquals("var")) continue;
            SuggestedFix.Builder fix = SuggestedFix.builder();
            return this.buildDescription(typeTree).addFix((Fix)fix.replace(token.pos(), token.endPos(), SuggestedFixes.prettyType((VisitorState)state, (SuggestedFix.Builder)fix, (Type)ASTHelpers.getType((Tree)typeTree))).build()).build();
        }
        return Description.NO_MATCH;
    }
}

