/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.Collections;

@BugPattern(name="PreferImmutableStreamExCollections", link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, summary="Prefer immutable/unmodifable collections wherever possible because they are inherently threadsafe and easier to reason about when passed between different functions. If you really want a mutable output then explicitly suppress this check.")
@AutoService(value={BugChecker.class})
public final class PreferImmutableStreamExCollections
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<ExpressionTree> STREAMEX_TO_MAP = MethodMatchers.instanceMethod().onExactClass("one.util.streamex.EntryStream").named("toMap").withParameters(Collections.emptyList());
    private static final Matcher<ExpressionTree> STREAMEX_TO_SET = MethodMatchers.instanceMethod().onDescendantOf("one.util.streamex.AbstractStreamEx").named("toSet").withParameters(Collections.emptyList());
    private static final Matcher<ExpressionTree> STREAMEX_TO_LIST = MethodMatchers.instanceMethod().onDescendantOf("one.util.streamex.AbstractStreamEx").named("toList").withParameters(Collections.emptyList());
    private static final Matcher<ExpressionTree> STREAMEX_COLLECT = MethodMatchers.instanceMethod().onDescendantOf("one.util.streamex.AbstractStreamEx").named("collect");
    private static final Matcher<ExpressionTree> COLLECT_TO_SET = MethodMatchers.staticMethod().onClass("java.util.stream.Collectors").named("toSet").withParameters(Collections.emptyList());
    private static final Matcher<ExpressionTree> COLLECT_TO_LIST = MethodMatchers.staticMethod().onClass("java.util.stream.Collectors").named("toList").withParameters(Collections.emptyList());

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (STREAMEX_TO_MAP.matches((Tree)tree, state)) {
            return this.buildDescription(tree).addFix((Fix)SuggestedFixes.renameMethodInvocation((MethodInvocationTree)tree, (String)"toImmutableMap", (VisitorState)state)).build();
        }
        if (STREAMEX_TO_SET.matches((Tree)tree, state)) {
            return this.buildDescription(tree).addFix((Fix)SuggestedFixes.renameMethodInvocation((MethodInvocationTree)tree, (String)"toImmutableSet", (VisitorState)state)).build();
        }
        if (STREAMEX_TO_LIST.matches((Tree)tree, state)) {
            return this.buildDescription(tree).addFix((Fix)SuggestedFixes.renameMethodInvocation((MethodInvocationTree)tree, (String)"toImmutableList", (VisitorState)state)).build();
        }
        if (STREAMEX_COLLECT.matches((Tree)tree, state) && tree.getArguments().size() == 1) {
            ExpressionTree argument = tree.getArguments().get(0);
            if (COLLECT_TO_SET.matches((Tree)argument, state)) {
                return this.buildDescription(tree).addFix((Fix)SuggestedFix.builder().delete((Tree)argument).merge(SuggestedFixes.renameMethodInvocation((MethodInvocationTree)tree, (String)"toImmutableSet", (VisitorState)state)).build()).build();
            }
            if (COLLECT_TO_LIST.matches((Tree)argument, state)) {
                return this.buildDescription(tree).addFix((Fix)SuggestedFix.builder().delete((Tree)argument).merge(SuggestedFixes.renameMethodInvocation((MethodInvocationTree)tree, (String)"toImmutableList", (VisitorState)state)).build()).build();
            }
        }
        return Description.NO_MATCH;
    }
}

