/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.CompileTimeConstantExpressionMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.List;
import java.util.regex.Pattern;

@BugPattern(name="PreconditionsConstantMessage", link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.ERROR, summary="Allow only constant messages to Preconditions.checkX() methods")
@AutoService(value={BugChecker.class})
public final class PreconditionsConstantMessage
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<ExpressionTree> PRECONDITIONS_METHOD = MethodMatchers.staticMethod().onClass("com.google.common.base.Preconditions").withNameMatching(Pattern.compile("checkArgument|checkState|checkNotNull"));
    private final Matcher<ExpressionTree> compileTimeConstExpressionMatcher = new CompileTimeConstantExpressionMatcher();

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!PRECONDITIONS_METHOD.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        List<? extends ExpressionTree> args = tree.getArguments();
        if (args.size() <= 1) {
            return Description.NO_MATCH;
        }
        ExpressionTree messageArg = args.get(1);
        if (this.compileTimeConstExpressionMatcher.matches((Tree)messageArg, state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage("Preconditions.checkX() statement uses a non-constant message. Consider using a template string with '%s'.").build();
    }
}

