/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.AnnotationMatcherUtils;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.palantir.baseline.errorprone.JUnit5RuleUsage;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@BugPattern(name="JUnit5SuiteMisuse", link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.ERROR, summary="Referencing JUnit5 tests from JUnit4 Suites will silently not work")
@AutoService(value={BugChecker.class})
public final class JUnit5SuiteMisuse
extends BugChecker
implements BugChecker.ClassTreeMatcher,
BugChecker.AnnotationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Set<Type.ClassType> knownJUnit5TestClasses = new HashSet<Type.ClassType>();
    private static final Set<Type.ClassType> referencedBySuites = new HashSet<Type.ClassType>();

    public Description matchClass(ClassTree tree, VisitorState state) {
        if (!JUnit5RuleUsage.hasJunit5TestCases.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        Type.ClassType type = ASTHelpers.getType((ClassTree)tree);
        knownJUnit5TestClasses.add(type);
        if (referencedBySuites.contains(type)) {
            return this.buildDescription(tree).setMessage("Class uses JUnit5 tests but is referenced by a JUnit4 SuiteClasses annotation").build();
        }
        return Description.NO_MATCH;
    }

    public Description matchAnnotation(AnnotationTree tree, VisitorState state) {
        if (!Matchers.isSameType((String)"org.junit.runners.Suite.SuiteClasses").matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        for (Type referencedClass : JUnit5SuiteMisuse.getReferencedClasses(tree, state)) {
            Type.ClassType classType = (Type.ClassType)referencedClass;
            referencedBySuites.add(classType);
            if (!knownJUnit5TestClasses.contains(classType)) continue;
            return this.buildDescription(tree).setMessage("Don't reference JUnit5 test classes from JUnit4 SuiteClasses annotation").build();
        }
        return Description.NO_MATCH;
    }

    private static List<Type> getReferencedClasses(AnnotationTree tree, VisitorState state) {
        ExpressionTree value = AnnotationMatcherUtils.getArgument((AnnotationTree)tree, (String)"value");
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof JCTree.JCFieldAccess) {
            return Collections.singletonList(((JCTree.JCFieldAccess)value).selected.type);
        }
        if (value instanceof JCTree.JCNewArray) {
            ImmutableList.Builder list = ImmutableList.builder();
            for (JCTree.JCExpression elem : ((JCTree.JCNewArray)value).elems) {
                list.add((Object)((JCTree.JCFieldAccess)elem).selected.type);
            }
            return list.build();
        }
        throw new UnsupportedOperationException(String.format("Unable to get referenced classes for %s of type %s", state.getSourceForNode((Tree)tree), value.getClass()));
    }
}

