/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(name="DeprecatedGuavaObjects", link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, summary="The standard library java.util.Objects utilities replace Guava com.google.common.base.Objects in java 1.7 and beyond.")
@AutoService(value={BugChecker.class})
public final class DeprecatedGuavaObjects
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final String GUAVA_OBJECTS_NAME = "com.google.common.base.Objects";
    private static final String GUAVA_OBJECTS_EQUAL = "com.google.common.base.Objects.equal";
    private static final String GUAVA_OBJECTS_HASH_CODE = "com.google.common.base.Objects.hashCode";
    private static final String JAVA_OBJECTS_NAME = "java.util.Objects";
    private static final Matcher<ExpressionTree> EQUAL_MATCHER = MethodMatchers.staticMethod().onClass("com.google.common.base.Objects").named("equal");
    private static final Matcher<ExpressionTree> HASH_CODE_MATCHER = MethodMatchers.staticMethod().onClass("com.google.common.base.Objects").named("hashCode");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        boolean hashCode = HASH_CODE_MATCHER.matches((Tree)tree, state);
        boolean equal = EQUAL_MATCHER.matches((Tree)tree, state);
        if (hashCode || equal) {
            return this.buildDescription(tree).addFix((Fix)SuggestedFix.builder().removeImport(GUAVA_OBJECTS_NAME).removeStaticImport(GUAVA_OBJECTS_EQUAL).removeStaticImport(GUAVA_OBJECTS_HASH_CODE).addImport(JAVA_OBJECTS_NAME).replace((Tree)tree.getMethodSelect(), equal ? "Objects.equals" : "Objects.hash").build()).build();
        }
        return Description.NO_MATCH;
    }
}

