/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.common.collect.Maps;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;

@BugPattern(name="AvoidNewHashMapInt", link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, summary="The HashMap(int) constructor is misleading: once the HashMap reaches 3/4 of the supplied size, it will double its internal storage array. Instead use Maps.newHashMapWithExpectedSize which behaves as expected.See https://github.com/palantir/gradle-baseline/blob/develop/docs/best-practices/java-coding-guidelines/readme.md#avoid-new-HashMap(int) for more information.")
@AutoService(value={BugChecker.class})
public final class AvoidNewHashMapInt
extends BugChecker
implements BugChecker.NewClassTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<ExpressionTree> NEW_HASH_MAP = MethodMatchers.constructor().forClass("java.util.HashMap").withParameters(new String[]{"int"});

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        if (!NEW_HASH_MAP.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
        String newType = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fixBuilder, (String)Maps.class.getName());
        String arg = state.getSourceForNode((Tree)tree.getArguments().get(0));
        String replacement = newType + ".newHashMapWithExpectedSize(" + arg + ")";
        return this.buildDescription(tree).addFix((Fix)fixBuilder.replace((Tree)tree, replacement).build()).build();
    }
}

