package com.netease.nimlib.sdk.mixpush.model;

import com.netease.nimlib.mixpush.model.PushType;

public enum MixPushTypeEnum {

    /** 未知 */
    UNKNOWN(PushType.DISABLE),

    /** 小米 */
    XIAO_MI(PushType.XIAO_MI),

    /** 华为 */
    HUA_WEI(PushType.HUA_WEI),

    /** 魅族 */
    MEI_ZU(PushType.MEI_ZU),

    /** FCM */
    FCM(PushType.FCM),

    /** VIVO */
    VIVO(PushType.VIVO),

    /** OPPO */
    OPPO(PushType.OPPO),
    /** HONOR */
    HONOR(PushType.HONOR),
    ;

    final private int value;

    MixPushTypeEnum(int value) {
        this.value = value;
    }

    public final int getValue() {
        return value;
    }

    public static MixPushTypeEnum typeOfValue(int value) {
        for (MixPushTypeEnum e : values()) {
            if (e.getValue() == value) {
                return e;
            }
        }
        return UNKNOWN;
    }
}
