package com.netease.nimlib.sdk.mixpush;


import com.netease.nimlib.mixpush.MixPushCache;
import com.netease.nimlib.mixpush.MixPushCore;

/**
 * 云信第三方推送接口
 */

public class NIMPushClient {

    /**
     *
     * @param config
     */
    public static void initPush(MixPushConfig config) {
        MixPushCache.init(config);
    }
    /**
     * 注册第三方推送消息接收handler
     * 在云信SDK初始化 NimClient.init 接口前调用
     * @param handler 第三方推送消息接收handler, 可自定义通知栏点击行为
     */
    public static void registerMixPushMessageHandler(MixPushMessageHandler handler) {
        MixPushCore.setMixPushMessageHandler(handler);
    }
}
